/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.text.dialogs.HTMLAttributeEditorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SizeAttributesPanel
extends HTMLAttributeEditorPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] MEASUREMENTS = new String[]{"percent", "pixels"};
    private JCheckBox widthCB = null;
    private JCheckBox heightCB = null;
    private JSpinner widthField = null;
    private JSpinner heightField = null;
    private JComboBox wMeasurementCombo = null;
    private JComboBox hMeasurementCombo = null;

    public SizeAttributesPanel() {
        this(new Hashtable());
    }

    public SizeAttributesPanel(Hashtable hashtable) {
        super(hashtable);
        this.initialize();
        this.updateComponentsFromAttribs();
    }

    @Override
    public void updateComponentsFromAttribs() {
        String string;
        if (this.attribs.containsKey("width")) {
            this.widthCB.setSelected(true);
            string = this.attribs.get("width").toString();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            } else {
                this.wMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.widthField.getModel().setValue(new Integer(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.wMeasurementCombo.setEnabled(true);
            this.widthField.setEnabled(true);
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.wMeasurementCombo.setEnabled(false);
        }
        if (this.attribs.containsKey("height")) {
            this.heightCB.setSelected(true);
            string = this.attribs.get("height").toString();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            } else {
                this.hMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.heightField.getModel().setValue(new Integer(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.hMeasurementCombo.setEnabled(true);
            this.heightField.setEnabled(true);
        } else {
            this.heightCB.setSelected(false);
            this.heightField.setEnabled(false);
            this.hMeasurementCombo.setEnabled(false);
        }
    }

    @Override
    public void updateAttribsFromComponents() {
        String string;
        if (this.widthCB.isSelected()) {
            string = this.widthField.getModel().getValue().toString();
            if (this.wMeasurementCombo.getSelectedIndex() == 0) {
                string = string + "%";
            }
            this.attribs.put("width", string);
        } else {
            this.attribs.remove("width");
        }
        if (this.heightCB.isSelected()) {
            string = this.heightField.getModel().getValue().toString();
            if (this.hMeasurementCombo.getSelectedIndex() == 0) {
                string = string + "%";
            }
            this.attribs.put("height", string);
        } else {
            this.attribs.remove("height");
        }
    }

    public void setComponentStates(Hashtable hashtable) {
        String string;
        if (hashtable.containsKey("width")) {
            this.widthCB.setSelected(true);
            string = hashtable.get("width").toString();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            } else {
                this.wMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.widthField.getModel().setValue(new Integer(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.wMeasurementCombo.setEnabled(true);
            this.widthField.setEnabled(true);
        } else {
            this.widthCB.setSelected(false);
            this.widthField.setEnabled(false);
            this.wMeasurementCombo.setEnabled(false);
        }
        if (hashtable.containsKey("height")) {
            this.heightCB.setSelected(true);
            string = hashtable.get("height").toString();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            } else {
                this.hMeasurementCombo.setSelectedIndex(1);
            }
            try {
                this.heightField.getModel().setValue(new Integer(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.hMeasurementCombo.setEnabled(true);
            this.heightField.setEnabled(true);
        } else {
            this.heightCB.setSelected(false);
            this.heightField.setEnabled(false);
            this.hMeasurementCombo.setEnabled(false);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints3.ipadx = 0;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints4.ipadx = 0;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(215, 95);
        this.setPreferredSize(new Dimension(215, 95));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, HtmleditorStringBank.size.getI18n(), 0, 0, null, null), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.add((Component)this.getWidthCB(), gridBagConstraints6);
        this.add((Component)this.getHeightCB(), gridBagConstraints5);
        this.add((Component)this.getWidthField(), gridBagConstraints4);
        this.add((Component)this.getHeightField(), gridBagConstraints3);
        this.add((Component)this.getWMeasurementCombo(), gridBagConstraints2);
        this.add((Component)this.getHMeasurementCombo(), gridBagConstraints);
    }

    private JCheckBox getWidthCB() {
        if (this.widthCB == null) {
            this.widthCB = new JCheckBox();
            this.widthCB.setText(HtmleditorStringBank.width.getI18n());
            this.widthCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SizeAttributesPanel.this.widthField.setEnabled(SizeAttributesPanel.this.widthCB.isSelected());
                    SizeAttributesPanel.this.wMeasurementCombo.setEnabled(SizeAttributesPanel.this.widthCB.isSelected());
                }
            });
        }
        return this.widthCB;
    }

    private JCheckBox getHeightCB() {
        if (this.heightCB == null) {
            this.heightCB = new JCheckBox();
            this.heightCB.setText(HtmleditorStringBank.height.getI18n());
            this.heightCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SizeAttributesPanel.this.heightField.setEnabled(SizeAttributesPanel.this.heightCB.isSelected());
                    SizeAttributesPanel.this.hMeasurementCombo.setEnabled(SizeAttributesPanel.this.heightCB.isSelected());
                }
            });
        }
        return this.heightCB;
    }

    private JSpinner getWidthField() {
        if (this.widthField == null) {
            this.widthField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.widthField;
    }

    private JSpinner getHeightField() {
        if (this.heightField == null) {
            this.heightField = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        }
        return this.heightField;
    }

    private JComboBox getWMeasurementCombo() {
        if (this.wMeasurementCombo == null) {
            this.wMeasurementCombo = new JComboBox<String>(MEASUREMENTS);
        }
        return this.wMeasurementCombo;
    }

    private JComboBox getHMeasurementCombo() {
        if (this.hMeasurementCombo == null) {
            this.hMeasurementCombo = new JComboBox<String>(MEASUREMENTS);
        }
        return this.hMeasurementCombo;
    }
}

