/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.dialogs.HTMLOptionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HTMLFontDialog
extends HTMLOptionDialog {
    private static final long serialVersionUID = 1L;
    private static Icon icon = UIUtils.getIcon("images/x32/", "fontsize.png");
    private static String title = HtmleditorStringBank.font.getI18n();
    private static String desc = HtmleditorStringBank.font_desc.getI18n();
    private static final Integer[] SIZES = new Integer[]{new Integer(8), new Integer(10), new Integer(12), new Integer(14), new Integer(18), new Integer(24), new Integer(36)};
    private JPanel jContentPane = null;
    private JLabel fontLabel = null;
    private JComboBox fontCombo = null;
    private JComboBox sizeCombo = null;
    private JPanel stylePanel = null;
    private JCheckBox boldCB = null;
    private JCheckBox italicCB = null;
    private JCheckBox ulCB = null;
    private JPanel previewPanel = null;
    private JLabel previewLabel = null;
    private JPanel spacerPanel = null;
    private String text = "";

    public HTMLFontDialog(Frame frame, String string) {
        super(frame, title, desc, icon);
        this.initialize(string);
    }

    public HTMLFontDialog(Dialog dialog, String string) {
        super(dialog, title, desc, icon);
        this.initialize(string);
    }

    public boolean isBold() {
        return this.boldCB.isSelected();
    }

    public boolean isItalic() {
        return this.italicCB.isSelected();
    }

    public boolean isUnderline() {
        return this.ulCB.isSelected();
    }

    public void setBold(boolean bl) {
        this.boldCB.setSelected(bl);
        this.updatePreview();
    }

    public void setItalic(boolean bl) {
        this.italicCB.setSelected(bl);
        this.updatePreview();
    }

    public void setUnderline(boolean bl) {
        this.ulCB.setSelected(bl);
        this.updatePreview();
    }

    public void setFontName(String string) {
        this.fontCombo.setSelectedItem(string);
        this.updatePreview();
    }

    public String getFontName() {
        return this.fontCombo.getSelectedItem().toString();
    }

    public int getFontSize() {
        Integer n = (Integer)this.sizeCombo.getSelectedItem();
        return n;
    }

    public void setFontSize(int n) {
        this.sizeCombo.setSelectedItem(new Integer(n));
        this.updatePreview();
    }

    @Override
    public String getHTML() {
        String string = "<font ";
        string = string + "name=\"" + this.fontCombo.getSelectedItem() + "\" ";
        string = string + "size=\"" + (this.sizeCombo.getSelectedIndex() + 1) + "\">";
        if (this.boldCB.isSelected()) {
            string = string + "<b>";
        }
        if (this.italicCB.isSelected()) {
            string = string + "<i>";
        }
        if (this.ulCB.isSelected()) {
            string = string + "<u>";
        }
        string = string + this.text;
        if (this.boldCB.isSelected()) {
            string = string + "</b>";
        }
        if (this.italicCB.isSelected()) {
            string = string + "</i>";
        }
        if (this.ulCB.isSelected()) {
            string = string + "</u>";
        }
        string = string + "</font>";
        return string;
    }

    private void initialize(String string) {
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.setSize(285, this.getHeight());
        this.setResizable(false);
        this.text = string;
    }

    private void updatePreview() {
        int n = 0;
        if (this.boldCB.isSelected()) {
            ++n;
        }
        if (this.italicCB.isSelected()) {
            n += 2;
        }
        if (this.ulCB.isSelected()) {
            this.previewLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.previewLabel.getForeground()));
        } else {
            this.previewLabel.setBorder(null);
        }
        String string = this.fontCombo.getSelectedItem().toString();
        Integer n2 = SIZES[this.sizeCombo.getSelectedIndex()];
        Font font = new Font(string, n, n2);
        this.previewLabel.setFont(font);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.gridy = 0;
            this.fontLabel = new JLabel();
            this.fontLabel.setText(HtmleditorStringBank.font.getI18n());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jContentPane.add((Component)this.fontLabel, gridBagConstraints4);
            this.jContentPane.add((Component)this.getFontCombo(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getSizeCombo(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getStylePanel(), gridBagConstraints);
            this.sizeCombo.setSelectedItem(new Integer(this.previewLabel.getFont().getSize()));
        }
        return this.jContentPane;
    }

    private JComboBox getFontCombo() {
        if (this.fontCombo == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
            Vector<String> vector = new Vector<String>();
            vector.add("Default");
            vector.add("serif");
            vector.add("sans-serif");
            vector.add("monospaced");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
            this.fontCombo = new JComboBox(vector);
            this.fontCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HTMLFontDialog.this.updatePreview();
                }
            });
        }
        return this.fontCombo;
    }

    private JComboBox getSizeCombo() {
        if (this.sizeCombo == null) {
            this.sizeCombo = new JComboBox<Integer>(SIZES);
            this.sizeCombo.setSelectedItem(new Integer(12));
            this.sizeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HTMLFontDialog.this.updatePreview();
                }
            });
        }
        return this.sizeCombo;
    }

    private JPanel getStylePanel() {
        if (this.stylePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 4;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints5.gridy = 0;
            this.stylePanel = new JPanel();
            this.stylePanel.setLayout(new GridBagLayout());
            this.stylePanel.add((Component)this.getBoldCB(), gridBagConstraints5);
            this.stylePanel.add((Component)this.getItalicCB(), gridBagConstraints4);
            this.stylePanel.add((Component)this.getUlCB(), gridBagConstraints3);
            this.stylePanel.add((Component)this.getPreviewPanel(), gridBagConstraints2);
            this.stylePanel.add((Component)this.getSpacerPanel(), gridBagConstraints);
        }
        return this.stylePanel;
    }

    private JCheckBox getBoldCB() {
        if (this.boldCB == null) {
            this.boldCB = new JCheckBox();
            this.boldCB.setText(HtmleditorStringBank.bold.getI18n());
            this.boldCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HTMLFontDialog.this.updatePreview();
                }
            });
        }
        return this.boldCB;
    }

    private JCheckBox getItalicCB() {
        if (this.italicCB == null) {
            this.italicCB = new JCheckBox();
            this.italicCB.setText(HtmleditorStringBank.italic.getI18n());
            this.italicCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HTMLFontDialog.this.updatePreview();
                }
            });
        }
        return this.italicCB;
    }

    private JCheckBox getUlCB() {
        if (this.ulCB == null) {
            this.ulCB = new JCheckBox();
            this.ulCB.setText(HtmleditorStringBank.underline.getI18n());
            this.ulCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HTMLFontDialog.this.updatePreview();
                }
            });
        }
        return this.ulCB;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewLabel = new JLabel();
            this.previewLabel.setText("AaBbYyZz");
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBackground(Color.WHITE);
            jPanel.add(this.previewLabel);
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new BorderLayout());
            this.previewPanel.setBorder(BorderFactory.createCompoundBorder(null, BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, HtmleditorStringBank.preview.getI18n(), 0, 0, null, null), BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createBevelBorder(1)))));
            this.previewPanel.setPreferredSize(new Dimension(90, 100));
            this.previewPanel.setMaximumSize(this.previewPanel.getPreferredSize());
            this.previewPanel.setMinimumSize(this.previewPanel.getPreferredSize());
            this.previewPanel.add((Component)jPanel, null);
        }
        return this.previewPanel;
    }

    private JPanel getSpacerPanel() {
        if (this.spacerPanel == null) {
            this.spacerPanel = new JPanel();
        }
        return this.spacerPanel;
    }
}

