/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.ElementWriter;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.actions.DecoratedTextAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;

public class EnterKeyAction
extends DecoratedTextAction {
    private static final long serialVersionUID = 1L;

    public EnterKeyAction(Action action) {
        super("EnterAction", action);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HTMLDocument hTMLDocument;
        JEditorPane jEditorPane;
        try {
            jEditorPane = (JEditorPane)this.getTextComponent(actionEvent);
            hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            this.delegate.actionPerformed(actionEvent);
            return;
        }
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
        Element element2 = element.getParentElement();
        HTML.Tag tag = HTML.getTag(element.getName());
        HTML.Tag tag2 = HTML.getTag(element2.getName());
        int n = jEditorPane.getCaretPosition();
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        try {
            if (HTMLUtils.isImplied(element)) {
                if (tag2.equals(HTML.Tag.LI)) {
                    if (element2.getEndOffset() - element2.getStartOffset() > 1) {
                        String string = "";
                        if (n == element2.getStartOffset()) {
                            hTMLDocument.insertBeforeStart(element2, this.toListItem(string));
                        } else if (n < element2.getEndOffset() - 1 && n > element2.getStartOffset()) {
                            int n2 = element2.getEndOffset() - n;
                            string = hTMLDocument.getText(n, n2);
                            hTMLDocument.insertAfterEnd(element2, this.toListItem(string));
                            hTMLDocument.remove(--n, n2);
                        } else {
                            hTMLDocument.insertAfterEnd(element2, this.toListItem(string));
                        }
                        jEditorPane.setCaretPosition(n + 1);
                    } else {
                        Element element3 = HTMLUtils.getListParent(element2).getParentElement();
                        if (this.isListItem(HTML.getTag(element3.getName()))) {
                            HTML.Tag tag3 = HTML.getTag(HTMLUtils.getListParent(element3).toString());
                            int n3 = element2.getStartOffset();
                            Element element4 = HTMLUtils.getNextElement(hTMLDocument, element2);
                            int n4 = element4.getEndOffset() - n3;
                            String string = HTMLUtils.getElementHTML(element3, true);
                            string = string.replaceFirst("\\<li\\>\\s*\\<\\/li\\>\\s*\\<\\/ul\\>", "</ul>");
                            string = string.replaceFirst("\\<ul\\>\\s*\\<\\/ul\\>", "");
                            hTMLDocument.setOuterHTML(element3, string);
                        } else if (element3.getName().equals("td")) {
                            this.encloseInDIV(element3, hTMLDocument);
                            jEditorPane.setCaretPosition(n + 1);
                        } else {
                            if (this.isInList(element3)) {
                                HTML.Tag tag4 = HTML.getTag(HTMLUtils.getListParent(element3).toString());
                                HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insert", "<li></li>", tag4, HTML.Tag.LI);
                                insertHTMLTextAction.actionPerformed(actionEvent);
                            } else {
                                HTML.Tag tag5 = HTML.Tag.BODY;
                                if (HTMLUtils.getParent(element, HTML.Tag.TD) != null) {
                                    tag5 = HTML.Tag.TD;
                                }
                                HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insert", "<p></p>", tag5, HTML.Tag.P);
                                insertHTMLTextAction.actionPerformed(actionEvent);
                            }
                            HTMLUtils.removeElement(element2);
                        }
                    }
                } else if (tag2.isPreformatted()) {
                    this.insertImpliedBR(actionEvent);
                } else if (tag2.equals(HTML.Tag.TD)) {
                    this.encloseInDIV(element2, hTMLDocument);
                    jEditorPane.setCaretPosition(n + 1);
                } else if (tag2.equals(HTML.Tag.BODY) || this.isInList(element)) {
                    this.insertParagraphAfter(element, jEditorPane);
                } else {
                    this.insertParagraphAfter(element2, jEditorPane);
                }
            } else if (this.isListItem(tag)) {
                if (element.getEndOffset() - jEditorPane.getCaretPosition() == 1) {
                    jEditorPane.replaceSelection("\n ");
                    jEditorPane.setCaretPosition(jEditorPane.getCaretPosition() - 1);
                } else {
                    this.delegate.actionPerformed(actionEvent);
                }
            } else {
                this.insertParagraphAfter(element, jEditorPane);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    private boolean isListItem(HTML.Tag tag) {
        return tag.equals(HTML.Tag.LI) || tag.equals(HTML.Tag.DT) || tag.equals(HTML.Tag.DD);
    }

    private String toListItem(String string) {
        return "<li>" + string + "</li>";
    }

    private boolean isInList(Element element) {
        return HTMLUtils.getListParent(element) != null;
    }

    private void insertImpliedBR(ActionEvent actionEvent) {
        HTMLEditorKit.InsertHTMLTextAction insertHTMLTextAction = new HTMLEditorKit.InsertHTMLTextAction("insertBR", "<br>", HTML.Tag.IMPLIED, HTML.Tag.BR);
        insertHTMLTextAction.actionPerformed(actionEvent);
    }

    private void encloseInDIV(Element element, HTMLDocument hTMLDocument) throws Exception {
        HTML.Tag tag = HTML.getTag(element.getName());
        String string = HTMLUtils.getElementHTML(element, false);
        string = HTMLUtils.createTag(tag, element.getAttributes(), "<div>" + string + "</div><div></div>");
        hTMLDocument.setOuterHTML(element, string);
    }

    private void insertParagraphAfter(Element element, JEditorPane jEditorPane) throws BadLocationException, IOException {
        Object object;
        Object object2;
        String string;
        int n = jEditorPane.getCaretPosition();
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        HTML.Tag tag = HTML.getTag(element.getName());
        int n2 = element.getEndOffset();
        int n3 = element.getStartOffset();
        if (tag == null || element.getName().equals("p-implied")) {
            tag = HTML.Tag.DIV;
        }
        if (n == n3) {
            string = this.createBlock(tag, element, "");
        } else {
            object2 = new StringWriter();
            object = new ElementWriter((Writer)object2, element, n3, n);
            ((HTMLWriter)object).write();
            string = this.createBlock(tag, element, ((StringWriter)object2).toString());
        }
        if (n == n2 - 1) {
            string = string + this.createBlock(tag, element, "");
        } else {
            object2 = new StringWriter();
            object = new ElementWriter((Writer)object2, element, n, n2);
            ((HTMLWriter)object).write();
            string = string + this.createBlock(tag, element, ((StringWriter)object2).toString());
        }
        object2 = n2 > n3 && n == n2 - 1 ? new SimpleAttributeSet(hTMLDocument.getCharacterElement(n - 1).getAttributes()) : new SimpleAttributeSet(hTMLDocument.getCharacterElement(n).getAttributes());
        hTMLDocument.setOuterHTML(element, string);
        object = hTMLDocument.getParagraphElement(++n);
        if (n == n2) {
            this.setCharAttribs((Element)object, (AttributeSet)object2);
        }
        jEditorPane.setCaretPosition(object.getStartOffset());
    }

    private String createBlock(HTML.Tag tag, Element element, String string) {
        AttributeSet attributeSet = element.getAttributes();
        return HTMLUtils.createTag(tag, attributeSet, HTMLUtils.removeEnclosingTags(element, string));
    }

    private void setCharAttribs(Element element, AttributeSet attributeSet) {
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        simpleAttributeSet.removeAttribute(HTML.Attribute.SRC);
        boolean bl = false;
        Enumeration<?> enumeration = simpleAttributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            String string = attributeSet.getAttribute(obj).toString();
            bl = string.equals("br") || string.equals("hr") || string.equals("img");
        }
        if (!bl) {
            hTMLDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, true);
        }
    }
}

