/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ExceptionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int PREFERRED_WIDTH = 450;
    private static final String DEFAULT_TITLE = HtmleditorStringBank.error.getI18n();
    private JPanel jContentPane = null;
    private JLabel iconLabel = null;
    private JLabel titleLabel = null;
    private JLabel msgLabel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton detailsButton = null;
    private JScrollPane scrollPane = null;
    private JTextArea textArea = null;
    private JSeparator separator = null;

    public ExceptionDialog() {
        this.init(new Exception());
    }

    public ExceptionDialog(Frame frame, Throwable throwable) {
        super(frame, DEFAULT_TITLE);
        this.init(throwable);
    }

    public ExceptionDialog(Dialog dialog, Throwable throwable) {
        super(dialog, DEFAULT_TITLE);
        this.init(throwable);
    }

    private void init(Throwable throwable) {
        this.setModal(true);
        this.initialize();
        this.setThrowable(throwable);
        this.showDetails(false);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getOkButton());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 4;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridheight = 3;
            gridBagConstraints3.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 20, 5, 5);
            gridBagConstraints4.gridy = 1;
            this.msgLabel = new JLabel();
            this.msgLabel.setText("");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 10, 5, 5);
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridy = 0;
            this.titleLabel = new JLabel();
            this.titleLabel.setText(HtmleditorStringBank.error_prompt.getI18n());
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridheight = 3;
            gridBagConstraints6.anchor = 11;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.gridy = 0;
            this.iconLabel = new JLabel();
            this.iconLabel.setText("");
            this.iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(12, 5, 10, 5));
            this.jContentPane.add((Component)this.iconLabel, gridBagConstraints6);
            this.jContentPane.add((Component)this.titleLabel, gridBagConstraints5);
            this.jContentPane.add((Component)this.msgLabel, gridBagConstraints4);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getSeparator(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(0);
            gridLayout.setVgap(5);
            gridLayout.setColumns(1);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getDetailsButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(HtmleditorStringBank.ok.getI18n());
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setText(HtmleditorStringBank.details.getI18n());
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionDialog.this.toggleDetails();
                }
            });
        }
        return this.detailsButton;
    }

    private void toggleDetails() {
        this.showDetails(!this.isDetailsVisible());
    }

    public void showDetails(boolean bl) {
        if (bl) {
            this.detailsButton.setText(HtmleditorStringBank.details.getI18n());
            this.scrollPane.setVisible(true);
            this.separator.setVisible(false);
        } else {
            this.detailsButton.setText(HtmleditorStringBank.details.getI18n());
            this.scrollPane.setVisible(false);
            this.separator.setVisible(true);
        }
        this.setResizable(true);
        this.pack();
        this.setResizable(false);
    }

    public boolean isDetailsVisible() {
        return this.scrollPane.isVisible();
    }

    public void setThrowable(Throwable throwable) {
        String string = HtmleditorStringBank.no_message_given.getI18n();
        if (throwable.getLocalizedMessage() != null && !throwable.getLocalizedMessage().equals("")) {
            string = throwable.getLocalizedMessage();
        }
        this.msgLabel.setText(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        String string2 = new String(byteArrayOutputStream.toByteArray());
        this.textArea.setText(string2);
        this.textArea.setCaretPosition(0);
    }

    private JSeparator getSeparator() {
        if (this.separator == null) {
            this.separator = new JSeparator();
            this.separator.setPreferredSize(new Dimension(450, 3));
        }
        return this.separator;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(new Dimension(450, 200));
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setTabSize(2);
            this.textArea.setEditable(false);
            this.textArea.setOpaque(false);
        }
        return this.textArea;
    }
}

