/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import commvault.cte.CteStringBank;
import commvault.cte.component.dock.AbstractFeature;
import commvault.cte.component.dock.CNTasks;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.table.AbstractPopupAdapter;
import commvault.cte.component.table.CVTableModel;
import commvault.cte.component.table.NTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class TableFeature
extends AbstractFeature
implements ActionListener {
    public static final String SUB_TASKS = "Sub tasks";
    private static final String TASKS = CteStringBank.Tasks.getI18n();
    private static final String DELETE = CteStringBank.Delete.getI18n();
    private static final String EDIT = CteStringBank.Edit.getI18n();
    public static final String ADD = CteStringBank.Add.getI18n();
    public static final String NEW_SCHEDULE_POLICY = CteStringBank.NewSchedulePolicy.getI18n();
    public static final String NEW_REPORT = CteStringBank.NEW_REPORT.getI18n();
    protected NTable table = new NTable(new DefaultTableModel());
    protected Action CREATE_ACTION = new CTEAction(NEW_SCHEDULE_POLICY, this);
    protected Action CREATE_NEW_REPORT_ACTION = new CTEAction(NEW_REPORT, this);
    protected Action EDIT_ACTION = new CTEAction(EDIT, this);
    protected Action DELETE_ACTION = new CTEAction(DELETE, this);
    boolean loading = false;

    public TableFeature(String string) {
        super(Feature.FeatureType.COMMCELL_SUMMARY, string);
    }

    public TableFeature(String string, Icon icon) {
        super(Feature.FeatureType.COMMCELL_SUMMARY, string, icon);
        this.configurUI();
    }

    public TableFeature(String string, Icon icon, String string2) {
        super(Feature.FeatureType.COMMCELL_SUMMARY, string, icon, string2);
        this.configurUI();
    }

    protected void configurUI() {
        this.table.getTable().setSelectionMode(2);
        this.table.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TableFeature.this.enableActions();
                TableFeature.this.showDetails();
                CNTasks.instance().setContextMenu(TableFeature.this);
            }
        });
        this.table.setShowPopupInterface(new AbstractPopupAdapter(){

            @Override
            public void popupAction(MouseEvent mouseEvent) {
                if (TableFeature.this.table.getSelectedRowCount() > 0) {
                    super.popupAction(mouseEvent);
                }
            }

            @Override
            protected Action[] getActions() {
                return TableFeature.this.getActionGroups().get(TableFeature.SUB_TASKS);
            }

            @Override
            public void defaultPopupAction() {
                Object object = TableFeature.this.EDIT_ACTION.getValue("Name");
                TableFeature.this.EDIT_ACTION.actionPerformed(new ActionEvent(this, 0, object == null ? null : object.toString()));
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                if (TableFeature.this.table != null) {
                    Object object = TableFeature.this.EDIT_ACTION.getValue("Name");
                    TableFeature.this.EDIT_ACTION.actionPerformed(new ActionEvent(this, 0, object == null ? null : object.toString()));
                }
            }
        });
    }

    protected void enableActions() {
        this.EDIT_ACTION.setEnabled(this.table.getSelectedRowCount() == 1);
        this.DELETE_ACTION.setEnabled(this.table.getSelectedRowCount() != 0);
    }

    @Override
    public Component createFeatureUI() {
        return this.table;
    }

    @Override
    public Map<String, Action[]> getActionGroups() {
        HashMap<String, Action[]> hashMap = new HashMap<String, Action[]>();
        hashMap.put(TASKS, new Action[]{this.CREATE_ACTION, this.CREATE_NEW_REPORT_ACTION});
        hashMap.put(SUB_TASKS, new Action[]{this.EDIT_ACTION, this.DELETE_ACTION});
        return hashMap;
    }

    @Override
    public void refresh() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.load();
        this.loading = false;
    }

    @Override
    public void load() {
    }

    @Override
    public void actionPerformed(final ActionEvent actionEvent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (actionEvent.getActionCommand() == ADD || actionEvent.getActionCommand().equals(NEW_SCHEDULE_POLICY) || actionEvent.getActionCommand() == NEW_REPORT) {
                    Object object = TableFeature.this.createRow();
                    if (object != null && TableFeature.this.table.getModel() instanceof CVTableModel) {
                        CVTableModel cVTableModel = (CVTableModel)TableFeature.this.table.getModel();
                        cVTableModel.getDatas().add(object);
                        cVTableModel.fireTableRowsInserted(cVTableModel.getDatas().size() - 1, cVTableModel.getDatas().size() - 1);
                    }
                } else if (actionEvent.getActionCommand() == EDIT) {
                    if (TableFeature.this.table.getModel() instanceof CVTableModel) {
                        CVTableModel cVTableModel = (CVTableModel)TableFeature.this.table.getModel();
                        Object object = TableFeature.this.getSelectedRow();
                        Object object2 = TableFeature.this.modifyRow(object);
                        if (object2 != null) {
                            if (object2 != object) {
                                cVTableModel.getDatas().set(cVTableModel.getDatas().indexOf(object), object2);
                            }
                            cVTableModel.fireTableRowsUpdated(TableFeature.this.table.getUnsortedSelectedRow(), TableFeature.this.table.getUnsortedSelectedRow());
                        }
                    }
                } else if (actionEvent.getActionCommand() == DELETE && TableFeature.this.table.getModel() instanceof CVTableModel) {
                    CVTableModel cVTableModel = (CVTableModel)TableFeature.this.table.getModel();
                    ArrayList arrayList = new ArrayList();
                    for (int n : TableFeature.this.table.getUnsortedSelectedRows()) {
                        arrayList.add(cVTableModel.getDatas().get(n));
                    }
                    if (TableFeature.this.deleteRows(arrayList.toArray())) {
                        cVTableModel.getDatas().removeAll(arrayList);
                    }
                    cVTableModel.fireTableRowsDeleted(TableFeature.this.table.getUnsortedSelectedRow(), TableFeature.this.table.getUnsortedSelectedRow());
                }
            }
        }).start();
    }

    protected Object getSelectedRow() {
        CVTableModel cVTableModel = (CVTableModel)this.table.getModel();
        int n = this.table.getUnsortedSelectedRow();
        if (n < 0) {
            return null;
        }
        return cVTableModel.getDatas().get(n);
    }

    protected boolean deleteRows(Object[] objectArray) {
        return false;
    }

    protected Object modifyRow(Object object) {
        return null;
    }

    protected Object createRow() {
        return null;
    }

    protected void showDetails() {
    }
}

