/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dialog;

import commvault.cte.CteStringBank;
import commvault.cte.common.GridbagHelper;
import commvault.cte.component.CVFrame;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.SaveFileFilter;
import commvault.cte.component.SaveOptions;
import commvault.cte.component.Utilities;
import commvault.cte.reports.components.ConversionType;
import commvault.cte.util.ReportUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SaveDialog
extends PropertyDialog
implements ActionListener,
ItemListener {
    JTextField fileNameTextField = new JTextField(30);
    JButton saveDialogButton = new JButton("...");
    public boolean isOKSelected = false;
    String defaultFileName = "";
    String directoryName = "";
    SaveOptions userPrefOptions = new SaveOptions();
    private JComboBox fileTypeBox = new JComboBox<ConversionType>(ConversionType.values());
    private ConversionType conversionType = ConversionType.PDF;
    private JLabel zoomLabel = null;
    private ConversionType saveDialogType = null;
    private JPanel tableOptionsPanel = new JPanel(new GridBagLayout());
    private static final String ILLEGAL_CHAR_PATTERN = "[\\\\/:*?<>|\\\"]";
    private static final String CHAR_TO_REPLACE = "_";

    public SaveDialog(String string) {
        this(string, null, null);
    }

    public SaveDialog(String string, String string2, ConversionType conversionType) {
        super((Frame)((Object)CVFrame.instance()), CteStringBank.Export_Options.getI18n(), true);
        Object object;
        String string3 = CteStringBank.Export_Options.getI18n();
        if (conversionType != null) {
            object = conversionType.name();
            if (conversionType == ConversionType.EXCEL) {
                object = "Excel";
            }
            string3 = (String)object + " " + CteStringBank.Export_Options.getI18n();
        }
        this.setTitle(string3);
        this.saveDialogType = conversionType;
        if (string != null && string.length() != 0) {
            this.defaultFileName = string = string.replaceAll(ILLEGAL_CHAR_PATTERN, CHAR_TO_REPLACE);
        }
        this.setResizable(true);
        this.contentPane.removeAll();
        this.contentPane.setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        JLabel jLabel = new JLabel(CteStringBank.Save_File_As.getI18n());
        this.fileTypeBox.addActionListener(this);
        if (conversionType != null) {
            this.fileTypeBox.setSelectedItem((Object)conversionType);
        } else {
            this.fileTypeBox.setSelectedItem((Object)ConversionType.PDF);
        }
        jLabel.setLabelFor(this.fileTypeBox);
        if (conversionType == null) {
            GridbagHelper.addRow(this.contentPane, (GridBagConstraints)object, jLabel, this.fileTypeBox, 10, 10, 0, 15);
        }
        this.conversionType = (ConversionType)((Object)this.fileTypeBox.getSelectedItem());
        this.updateComponents(this.conversionType);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string2 != null) {
            this.directoryName = string2;
        } else if (ReportUtilities.getCurrentBrowseDirectory() != null && ReportUtilities.getCurrentBrowseDirectory().isDirectory()) {
            try {
                this.directoryName = ReportUtilities.getCurrentBrowseDirectory().getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        String string4 = ConversionType.PDF.getFileExtension();
        if (string.lastIndexOf(46) != -1) {
            string4 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        }
        this.fileTypeBox.setSelectedItem((Object)this.getConversionType(string4));
        string = this.directoryName + (this.directoryName.endsWith(File.separator) ? "" : System.getProperty("file.separator")) + string;
        this.setFileNameField(string);
        jPanel.add(this.fileNameTextField);
        jPanel.add(this.saveDialogButton);
        jLabel = new JLabel(CteStringBank.File_name_.getI18n());
        jLabel.setLabelFor(jPanel);
        this.saveDialogButton.addActionListener(this);
        GridbagHelper.addRow(this.contentPane, (GridBagConstraints)object, jLabel, jPanel, 10, 10, 0, 15);
        this.contentPane.add((Component)new JSeparator(), Utilities.getConstraints((GridBagConstraints)object, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 15)));
        GridbagHelper.addRow(this.contentPane, (GridBagConstraints)object, jLabel, jPanel, 10, 10, 0, 15);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.helpButton);
        this.okButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.cancelButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.helpButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.contentPane.add((Component)jPanel2, Utilities.getConstraints((GridBagConstraints)object, -1, -1, 0, 0, 1.0, 1.0, 11, 2, new Insets(15, 5, 5, 5)));
        this.setLocationRelativeTo((Component)((Object)CVFrame.instance()));
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private ConversionType getConversionType(String string) {
        ConversionType[] conversionTypeArray = ConversionType.values();
        for (int i = 0; i < conversionTypeArray.length; ++i) {
            if (string.compareToIgnoreCase(conversionTypeArray[i].getFileExtension()) != 0) continue;
            return conversionTypeArray[i];
        }
        return ConversionType.PDF;
    }

    public void setConversionTypes(ConversionType[] conversionTypeArray) {
        this.fileTypeBox.setModel(new DefaultComboBoxModel<ConversionType>(conversionTypeArray));
    }

    public void setConversionType(ConversionType conversionType) {
        this.fileTypeBox.setSelectedItem((Object)conversionType);
    }

    public int getPageOrientation() {
        return 1;
    }

    public String getFileExtension() {
        return this.conversionType.getFileExtension();
    }

    private void setFileNameField(String string) {
        if (string.length() == 0) {
            return;
        }
        if (string.lastIndexOf(46) != -1) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        this.fileNameTextField.setText(string + "." + this.getFileExtension());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            String string = this.fileNameTextField.getText();
            this.directoryName = string.substring(0, string.lastIndexOf(File.separator));
            if (this.fileNameTextField.getText().length() == 0 || this.fileNameTextField.getText().trim().length() == 0) {
                Utilities.showErrorMessage(this, CteStringBank.Enter_destination_path.getI18n());
                this.fileNameTextField.requestFocus();
                return;
            }
            if (!ReportUtilities.isValidFileName(this.fileNameTextField.getText().trim())) {
                Utilities.showErrorMessage(this, CteStringBank.Invalid_Filename.getI18n());
                this.fileNameTextField.requestFocus();
                return;
            }
            if (!this.isDirectoryExists()) {
                if (Utilities.showYesNoMessage(CteStringBank.Specified_path_doesnt_exist.getI18n(), CteStringBank.Confirm.getI18n()) != 0) return;
                if (!new File(this.directoryName).mkdirs()) {
                    Utilities.showErrorMessage(CteStringBank.Error_creating_directory.getI18n());
                    return;
                }
                this.actionPerformed(actionEvent);
                return;
            } else if (new File(this.fileNameTextField.getText().trim()).exists()) {
                if (new File(this.fileNameTextField.getText().trim()).isDirectory()) {
                    Utilities.showErrorMessage(this, CteStringBank.Please_Enter_File_Name.getI18n());
                    this.fileNameTextField.requestFocus();
                    return;
                }
                if (Utilities.showYesNoMessage(this, CteStringBank.Do_you_want_to_overwrite_the_existing_file.getI18n(), "", 1) != 0) return;
                this.isOKSelected = true;
                super.okButtonActionPerformed(actionEvent);
                return;
            } else {
                this.isOKSelected = true;
                super.okButtonActionPerformed(actionEvent);
            }
            return;
        } else if (actionEvent.getSource().equals(this.saveDialogButton)) {
            this.showFileFilterDialog();
            return;
        } else if (actionEvent.getSource().equals(this.fileTypeBox)) {
            this.conversionType = (ConversionType)((Object)this.fileTypeBox.getSelectedItem());
            this.updateComponents(this.conversionType);
            return;
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void updateComponents(ConversionType conversionType) {
        this.setFileNameField(this.fileNameTextField.getText().trim());
    }

    private boolean isDirectoryExists() {
        File file = new File(this.directoryName);
        return file.exists() && file.isDirectory();
    }

    public void showFileFilterDialog() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SaveFileFilter saveFileFilter = new SaveFileFilter(ConversionType.PDF.getFileExtension(), ConversionType.PDF.getDisplayName());
        SaveFileFilter saveFileFilter2 = new SaveFileFilter(ConversionType.MHTML.getFileExtension(), ConversionType.MHTML.getDisplayName());
        SaveFileFilter saveFileFilter3 = new SaveFileFilter(ConversionType.EXCEL.getFileExtension(), ConversionType.EXCEL.getDisplayName());
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(CteStringBank.Browse.getI18n());
        jFileChooser.setApproveButtonText(CteStringBank.OK.getI18n());
        jFileChooser.setCurrentDirectory(ReportUtilities.getCurrentBrowseDirectory());
        switch (this.conversionType) {
            case PDF: {
                jFileChooser.setFileFilter(saveFileFilter);
                break;
            }
            case MHTML: {
                jFileChooser.setFileFilter(saveFileFilter2);
                break;
            }
            case EXCEL: {
                jFileChooser.setFileFilter(saveFileFilter3);
                break;
            }
            default: {
                jFileChooser.setFileFilter(saveFileFilter);
            }
        }
        if (this.fileNameTextField.getText().length() != 0 && this.fileNameTextField.getText().trim().length() != 0) {
            file = new File(this.fileNameTextField.getText());
            if (file != null) {
                jFileChooser.setSelectedFile(file);
            }
        } else if (this.defaultFileName != null && this.defaultFileName.length() != 0 && (file = new File(this.defaultFileName)) != null) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showDialog((Component)((Object)CVFrame.instance()), CteStringBank.OK.getI18n()) == 0) {
            file = jFileChooser.getSelectedFile();
            ReportUtilities.setCurrentBrowseDirectory(file.getParentFile());
            this.setFileNameField(file.getAbsolutePath());
            this.directoryName = file.getParentFile().getAbsolutePath();
        }
    }

    public void hideZoom(boolean bl) {
        if (bl) {
            this.zoomLabel.setVisible(false);
        }
    }

    public String getFileName() {
        return this.fileNameTextField.getText();
    }

    public boolean selectDefaultFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        if (this.defaultFileName != null && this.defaultFileName.length() != 0) {
            file = new File(this.defaultFileName);
            if (file != null) {
                jFileChooser.setSelectedFile(file);
            }
        } else {
            return false;
        }
        file = jFileChooser.getSelectedFile();
        this.fileNameTextField.setText(file.getAbsolutePath());
        return true;
    }

    public void selectDefaultFile(String string) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null && string.length() != 0 && (file = new File(string)) != null) {
            jFileChooser.setSelectedFile(file);
        }
        file = jFileChooser.getSelectedFile();
        this.fileNameTextField.setText(file.getAbsolutePath());
    }
}

