/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.chart;

import commvault.cte.reports.util.CapacityFormatter;

public class PieChartCounter {
    private double value = 0.0;
    private CapacityFormatter formatter = null;

    public PieChartCounter() {
        this.value = 0.0;
    }

    public PieChartCounter(int n) {
        this.value = n;
    }

    public PieChartCounter(long l) {
        this.value = l;
    }

    public PieChartCounter(double d) {
        this.value = d;
    }

    public PieChartCounter(double d, CapacityFormatter capacityFormatter) {
        this.value = capacityFormatter != null ? d / (double)capacityFormatter.getMinFactor() : d;
        this.formatter = capacityFormatter;
    }

    public double getValue() {
        return this.value;
    }

    public String getUnitString() {
        if (this.formatter != null) {
            return this.formatter.getUnits();
        }
        return "";
    }

    public void setValue(int n) {
        this.value += (double)n;
    }

    public void incrementValue() {
        this.value += 1.0;
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

