/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import commvault.cte.CteStringBank;
import commvault.cte.component.Utilities;
import commvault.cte.component.calender.CalView;
import commvault.cte.component.calender.CalendarUtil;
import commvault.cte.component.calender.CalendarView;
import commvault.cte.component.calender.CalendarViewModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class WeekCalView
extends CalView {
    public WeekCalView(CalendarViewModel calendarViewModel, CalendarView calendarView) {
        super(calendarViewModel, calendarView);
        this.label.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.setRowHeight(Utilities.userDefinedFont == 0 ? 20 : (Utilities.userDefinedFont > 14 && Utilities.userDefinedFont <= 15 ? 24 : (Utilities.userDefinedFont >= 12 && Utilities.userDefinedFont <= 14 ? 22 : 20)));
        this.label.setRowHeight(this.table.getRowHeight() * 2);
        this.label.setPreferredScrollableViewportSize(new Dimension(40, this.table.getPreferredScrollableViewportSize().height));
        HourTaskRenderer hourTaskRenderer = new HourTaskRenderer();
        this.table.setDefaultRenderer(Object.class, new HourTaskRenderer());
        this.table.setDefaultEditor(Object.class, hourTaskRenderer);
        this.setFocusTime(calendarView.getFocusDate());
    }

    protected String getDateRangeFormatter() {
        return CteStringBank.dateFormat.getI18n();
    }

    @Override
    protected void navigateLeft() {
    }

    @Override
    protected void navigateRight() {
    }

    @Override
    protected Date createStartTime(Date date) {
        return CalendarUtil.getStartDateForWeeklyView(date);
    }

    @Override
    protected void loadData(Date date, Date date2) throws Exception {
        this.outlookView.loadData(date, date2);
    }

    @Override
    public void refresh() {
    }

    class HourTaskRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        JList itemsRenderer = new JList();

        public HourTaskRenderer() {
            this.itemsRenderer.setCellRenderer(WeekCalView.this.outlookView.getTaskRenderer().getListRenderer());
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Calendar calendar = CalendarUtil.createCalendar((Date)object);
            ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get((Object)"Theme.painter");
            if (bl) {
                this.itemsRenderer.setBackground(jTable.getSelectionBackground());
            } else if (calendar.get(2) % 2 == 0) {
                this.itemsRenderer.setBackground(jTable.getBackground());
            } else {
                this.itemsRenderer.setBackground(themePainter.getCollapsiblePaneContentBackground());
            }
            int n3 = (int)(((Date)object).getTime() / 1000L);
            this.itemsRenderer.setListData(WeekCalView.this.outlookView.getTasksCache().getTasksForTime((Date)object, n3, n3 + 1800));
            return this.itemsRenderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

