/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.SComboBox;
import commvault.cte.component.SortedComboBoxModel;
import commvault.cte.component.Utilities;
import commvault.cte.component.calender.ChangeTimeZoneInterface;
import commvault.cte.net.IdIdNameItem;
import commvault.cte.util.Application;
import commvault.cte.util.CVTimezone;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class TimeZonePanel
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int WIZARD = 1;
    public static final int Y_AXIS = 2;
    public static final int COMMESERVER_TIMEZONE = 1000;
    public static final int CLIENT_TIMEZONE = 1001;
    public static final int LINE_TIMEZONE = -1000;
    private String commServerTimeZone = "";
    private String clientTimeZone = "";
    private boolean isOracle = false;
    SComboBox timeZoneCombo;
    Vector listeners = new Vector();
    JCheckBox dayLightCb = new JCheckBox(CteStringBank.TimeZonePanel_0.getI18n(), true);
    boolean hasChanged = false;
    static boolean setBrowseTimeZone = false;
    public static TimeZone browseTimeZone = Application.commServerTimeZone;
    JLabel JLabel1 = new JLabel();

    public TimeZonePanel(boolean bl) {
        this(bl ? 1 : 0);
    }

    public TimeZonePanel(int n) {
        setBrowseTimeZone = false;
        this.timeZoneCombo = new SComboBox(Application.instance().getTimezoneList(), false);
        this.timeZoneCombo.setMaximumRowCount(20);
        this.timeZoneCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TimeZonePanel.this.hasChanged = true;
                    TimeZonePanel.this.timeZoneCombo.setToolTipText(TimeZonePanel.this.timeZoneCombo.getSelectedItem().toString());
                    TimeZonePanel.this.setTimeZone();
                    if (setBrowseTimeZone) {
                        browseTimeZone = TimeZonePanel.this.getSelectedTimeZone();
                    }
                }
            }
        });
        if (n == 1) {
            this.wizardPageInit();
        } else if (n == 2) {
            this.doYLayoutInit();
        } else {
            this.dialogInit();
        }
        if (this.timeZoneCombo.getSelectedItem() == null) {
            this.timeZoneCombo.setSelectedItem(browseTimeZone);
        }
        if (this.timeZoneCombo.getSelectedItem() != null) {
            this.timeZoneCombo.setToolTipText(this.timeZoneCombo.getSelectedItem().toString());
        }
    }

    private void doYLayoutInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = Utilities.getRightConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(CteStringBank.Time_Zone.getI18n()), gridBagConstraints);
        this.add((Component)this.timeZoneCombo, gridBagConstraints);
    }

    public void setBrowseTimeZone(TimeZone timeZone) {
        browseTimeZone = timeZone;
    }

    public void setBrowseTimeZone() {
        setBrowseTimeZone = true;
        this.setChanged(TimeZonePanel.getTimeZoneItem(browseTimeZone));
    }

    public void addTimZoneListener(ChangeTimeZoneInterface changeTimeZoneInterface) {
        this.listeners.addElement(changeTimeZoneInterface);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(IdIdNameItem idIdNameItem) {
        TimeZone timeZone = null;
        Vector<TimeZone> vector = Application.instance().getTimezoneList();
        if (idIdNameItem != null && idIdNameItem.toString().length() != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!((SimpleTimeZone)vector.elementAt(i)).getID().equals(idIdNameItem.toString())) continue;
                timeZone = vector.elementAt(i);
                break;
            }
        }
        if (timeZone == null) {
            this.hasChanged = true;
            String string = Application.commServerTimeZone.getID();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((SimpleTimeZone)vector.elementAt(i)).getID().equals(string)) continue;
                timeZone = vector.elementAt(i);
                break;
            }
        }
        this.timeZoneCombo.setSelectedItem(timeZone);
    }

    public void setSelectedTimeZone(TimeZone timeZone) {
        this.timeZoneCombo.setSelectedItem(timeZone);
    }

    public SimpleTimeZone getSelectedTimeZone() {
        if (this.timeZoneCombo.getSelectedItem() == null) {
            if (this.timeZoneCombo.getModel().getSize() == 0) {
                return null;
            }
            return (SimpleTimeZone)this.timeZoneCombo.getModel().getElementAt(0);
        }
        return (SimpleTimeZone)this.timeZoneCombo.getSelectedItem();
    }

    public IdIdNameItem getSelectedTimeZoneItem() {
        return TimeZonePanel.getTimeZoneItem(this.getSelectedTimeZone());
    }

    public static SimpleTimeZone getTimeZone(IdIdNameItem idIdNameItem) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(TimeZone.getDefault().getRawOffset(), TimeZone.getDefault().getID()){

            @Override
            public String toString() {
                return this.getID();
            }
        };
        simpleTimeZone.setStartRule(0, 0, 0);
        simpleTimeZone.setID(idIdNameItem.toString());
        simpleTimeZone.setRawOffset(-(idIdNameItem.getSecondId() - 86400) * 1000);
        return simpleTimeZone;
    }

    public static IdIdNameItem getTimeZoneItem(TimeZone timeZone) {
        int n = timeZone.useDaylightTime() ? 1 : 0;
        int n2 = 86400 - timeZone.getRawOffset() / 1000;
        String string = timeZone.getID();
        return new IdIdNameItem(n, n2, string);
    }

    void setTimeZone() {
        block2: {
            SimpleTimeZone simpleTimeZone;
            block3: {
                simpleTimeZone = this.getSelectedTimeZone();
                if (simpleTimeZone == null) break block2;
                if (!this.isOracle) break block3;
                TimeZone timeZone = this.getTimeZoneFromClientTimeZone(simpleTimeZone);
                if (timeZone == null) break block2;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ChangeTimeZoneInterface)this.listeners.elementAt(i)).setTimeZone(timeZone);
                }
                break block2;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ChangeTimeZoneInterface)this.listeners.elementAt(i)).setTimeZone(simpleTimeZone);
            }
        }
    }

    public void dialogInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.add((Component)this.timeZoneCombo, Utilities.getConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 2, 10)));
        this.setBorder(BorderFactory.createTitledBorder(CteStringBank.Time_Zone.getI18n()));
    }

    public void wizardPageInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.JLabel1.setText(CteStringBank.Time_Zone7.getI18n());
        this.add((Component)this.JLabel1, Utilities.getConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 28)));
        this.add((Component)this.timeZoneCombo, Utilities.getConstraints(gridBagConstraints, 1, 0, 4, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5)));
        this.timeZoneCombo.setPrototypeDisplayValue("(GMT-05:00) Eastern Time (US & Canada)       ");
    }

    public void setDisable() {
        this.setChanged(null);
        this.timeZoneCombo.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.JLabel1.setEnabled(bl);
        this.timeZoneCombo.setEnabled(bl);
    }

    public void setDefaultTimeZone() {
        this.timeZoneCombo.setSelectedItem(Application.commServerTimeZone);
    }

    public void setCommServerClientTimeZones(String string, String string2, boolean bl) {
        this.commServerTimeZone = string;
        this.clientTimeZone = string2;
        this.isOracle = bl;
        this.setPreferredSizeTimeZoneCombo(new Dimension(400, 20));
    }

    public void setPreferredSizeTimeZoneCombo(Dimension dimension) {
        this.timeZoneCombo.setPreferredSize(dimension);
    }

    public void restTimeZoneFromSchedule(boolean bl) {
        Vector<TimeZone> vector = new Vector<TimeZone>(Application.instance().getTimezoneList());
        int n = 0;
        CVTimeZoneForDummyEntry cVTimeZoneForDummyEntry = new CVTimeZoneForDummyEntry(1000, Application.commServerTimeZone.getRawOffset(), CteStringBank.CommServe_Time_Zone.getI18n() + " " + this.commServerTimeZone);
        vector.add(n++, cVTimeZoneForDummyEntry);
        if (bl || this.isOracle) {
            cVTimeZoneForDummyEntry = new CVTimeZoneForDummyEntry(1001, 0, CteStringBank.Client_Time_Zone.getI18n() + " " + this.clientTimeZone);
            vector.add(n++, cVTimeZoneForDummyEntry);
        }
        cVTimeZoneForDummyEntry = new CVTimeZoneForDummyEntry(-1000, 0, CteStringBank.Separator.toString());
        vector.add(n++, cVTimeZoneForDummyEntry);
        this.timeZoneCombo.setModel(new SortedComboBoxModel(vector, false));
        this.timeZoneCombo.setUI(new TimeZoneComboBoxUI());
        final ListCellRenderer listCellRenderer = this.timeZoneCombo.getRenderer();
        this.timeZoneCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object.toString().equals(CteStringBank.Separator.toString())) {
                    return new JSeparator();
                }
                return component;
            }
        });
        if (this.isOracle && bl) {
            this.timeZoneCombo.setSelectedIndex(1);
        } else {
            this.timeZoneCombo.setSelectedIndex(0);
        }
        if (this.timeZoneCombo.getSelectedItem() != null) {
            this.timeZoneCombo.setToolTipText(this.timeZoneCombo.getSelectedItem().toString());
        }
    }

    public void setDefaultTimeZone(int n) {
        this.timeZoneCombo.setSelectedIndex(n);
    }

    private TimeZone getTimeZoneFromClientTimeZone(TimeZone timeZone) {
        int n;
        Object object;
        CVTimezone cVTimezone = null;
        String string = timeZone.getID();
        if (timeZone.getID().startsWith(CteStringBank.Client_Time_Zone.getI18n() + " ")) {
            object = CteStringBank.Client_Time_Zone.getI18n() + " ";
            n = timeZone.getID().indexOf(CteStringBank.Client_Time_Zone.getI18n() + " ");
            if (n > -1) {
                string = timeZone.getID().substring(n + ((String)object).length());
            }
        } else if (timeZone.getID().startsWith(CteStringBank.CommServe_Time_Zone.getI18n() + " ")) {
            object = CteStringBank.CommServe_Time_Zone.getI18n() + " ";
            n = timeZone.getID().indexOf(CteStringBank.CommServe_Time_Zone.getI18n() + " ");
            if (n > -1) {
                string = timeZone.getID().substring(n + ((String)object).length());
            }
        } else {
            return timeZone;
        }
        object = Application.instance().getTimezones().values().iterator();
        if (object != null) {
            while (object.hasNext()) {
                CVTimezone cVTimezone2;
                Object e = object.next();
                if (!(e instanceof CVTimezone) || !(cVTimezone2 = (CVTimezone)e).getID().equals(string)) continue;
                cVTimezone = cVTimezone2;
                break;
            }
        }
        return cVTimezone;
    }

    public static class CVTimeZoneForDummyEntry
    extends CVTimezone {
        public CVTimeZoneForDummyEntry(int n, int n2, String string) {
            super(n, n2, string);
        }

        @Override
        public String toString() {
            return this.getID();
        }
    }

    class TimeZoneComboBoxUI
    extends BasicComboBoxUI {
        Object object = null;

        TimeZoneComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            final BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
            this.object = this.comboBox.getSelectedItem();
            basicComboPopup.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getSource() == basicComboPopup.getList()) {
                        if (basicComboPopup.getList().getModel().getSize() > 0) {
                            if (TimeZoneComboBoxUI.this.comboBox.getSelectedIndex() != basicComboPopup.getList().getSelectedIndex()) {
                                TimeZoneComboBoxUI.this.comboBox.setSelectedIndex(basicComboPopup.getList().getSelectedIndex());
                            } else {
                                Object object = basicComboPopup.getList().getSelectedValue();
                                if (object instanceof CVTimezone && ((CVTimezone)object).getTZId() == -1000) {
                                    TimeZoneComboBoxUI.this.comboBox.setSelectedItem(TimeZoneComboBoxUI.this.object);
                                    return;
                                }
                                TimeZoneComboBoxUI.this.comboBox.getEditor().setItem(basicComboPopup.getList().getSelectedValue());
                            }
                        }
                        TimeZoneComboBoxUI.this.comboBox.setPopupVisible(false);
                        if (TimeZoneComboBoxUI.this.comboBox.isEditable() && TimeZoneComboBoxUI.this.comboBox.getEditor() != null) {
                            TimeZoneComboBoxUI.this.comboBox.configureEditor(TimeZoneComboBoxUI.this.comboBox.getEditor(), TimeZoneComboBoxUI.this.comboBox.getSelectedItem());
                        }
                        TimeZoneComboBoxUI.this.object = TimeZoneComboBoxUI.this.comboBox.getSelectedItem();
                        return;
                    }
                }
            });
            return basicComboPopup;
        }
    }
}

