/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.component.calender.CalendarUtil;
import java.util.Calendar;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class CalendarViewModel
extends AbstractTableModel {
    static String[] WEEK_DAYS = new String[]{CteStringBank.Sunday.getI18n(), CteStringBank.Monday.getI18n(), CteStringBank.Tuesday.getI18n(), CteStringBank.Wednesday.getI18n(), CteStringBank.Thursday.getI18n(), CteStringBank.Friday.getI18n(), CteStringBank.Saturday.getI18n()};
    private CalendarType calType = CalendarType.MONTHLY;
    private Date startDateTimeOfCalendar = new Date();

    public CalendarViewModel(CalendarType calendarType) {
        this.calType = calendarType;
    }

    @Override
    public int getColumnCount() {
        if (this.calType == CalendarType.DAILY) {
            return 1;
        }
        return WEEK_DAYS.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        if (this.calType == CalendarType.DAILY) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.startDateTimeOfCalendar);
            return WEEK_DAYS[calendar.get(7) - 1];
        }
        return WEEK_DAYS[(n + Calendar.getInstance().getFirstDayOfWeek() - 1) % 7];
    }

    @Override
    public int getRowCount() {
        if (this.calType == CalendarType.MONTHLY) {
            return 105;
        }
        return 48;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.calType == CalendarType.DAILY) {
            return CalendarUtil.getTime(n, this.startDateTimeOfCalendar);
        }
        if (this.calType == CalendarType.MONTHLY) {
            Date date = CalendarUtil.getDay(n, n2, this.startDateTimeOfCalendar);
            return date;
        }
        return CalendarUtil.getTime(n, n2, this.startDateTimeOfCalendar);
    }

    public CalendarType getCalType() {
        return this.calType;
    }

    public void setStartTime(Date date) {
        this.startDateTimeOfCalendar = date;
    }

    public Date getStartTime() {
        return this.startDateTimeOfCalendar;
    }

    public int getCellIndex(Date date) {
        int n = this.getCellTimeWidth();
        return (int)((date.getTime() - this.startDateTimeOfCalendar.getTime()) / (long)(1000 * n));
    }

    public int getCellTimeWidth() {
        int n = this.calType == CalendarType.MONTHLY ? 86400 : (this.calType == CalendarType.WEEKLY ? 1800 : 1800);
        return n;
    }

    public static enum CalendarType {
        MONTHLY,
        WEEKLY,
        DAILY,
        DETAIL;

    }
}

