/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.JideTabbedPane;
import commvault.cte.CteStringBank;
import commvault.cte.component.calender.CalNavigationPanel;
import commvault.cte.component.calender.CalendarViewModel;
import commvault.cte.component.calender.CalenderFilter;
import commvault.cte.component.calender.DailyCalView;
import commvault.cte.component.calender.ICalendarDataLoader;
import commvault.cte.component.calender.MonthlyCalView;
import commvault.cte.component.calender.TaskRenderer;
import commvault.cte.component.calender.WeekCalView;
import commvault.cte.component.dock.DockLayoutUtil;
import commvault.cte.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarView<T>
extends JPanel
implements ChangeListener {
    protected JideTabbedPane pane = new JideTabbedPane();
    private ICalendarDataLoader<T> tasksCache;
    private TaskRenderer taskRenderer;
    private JPanel viewContainer = new JPanel(new BorderLayout());
    private boolean loaded = true;
    private DockingManager mgr;

    public CalendarView() {
        super(new BorderLayout());
        this.initUI();
    }

    public CalenderFilter getFilter() {
        return null;
    }

    private void initUI() {
        this.pane.setTabShape(3);
        JLabel jLabel = new JLabel();
        jLabel.setFocusable(false);
        this.pane.addTab(CteStringBank.Monthy.getI18n(), (Component)jLabel);
        this.pane.setPreferredSize(new Dimension(200, 20));
        this.pane.setMinimumSize(new Dimension(200, 20));
        this.pane.setFocusable(false);
        this.mgr = DockLayoutUtil.doBorderLayout(this, this.viewContainer, this.crateFilterPanel(), null, null);
        DockableFrame dockableFrame = this.mgr.getFrame("left");
        dockableFrame.setTitle(CteStringBank.Filter.getI18n());
        dockableFrame.setFrameIcon(null);
    }

    public void cleanup() {
        Logger.instance().println("closing calendar");
        if (this.getCurrentView() != null) {
            this.getCurrentView().unLoad();
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.pane.removeChangeListener((ChangeListener)this);
        this.pane.removeAll();
        this.mgr.removeAllFrames();
        this.mgr.dispose();
        this.viewContainer.removeAll();
        this.tasksCache.clear();
        this.viewContainer = null;
        this.tasksCache = null;
        this.taskRenderer = null;
        this.pane = null;
        this.mgr = null;
    }

    public void loadView() {
        this.pane.addChangeListener((ChangeListener)this);
        this.setView(CalendarViewModel.CalendarType.MONTHLY);
        this.setFocusDate(new Date());
    }

    protected Component crateFilterPanel() {
        return new JPanel();
    }

    private void setView(CalendarViewModel.CalendarType calendarType) {
        this.setView(calendarType, null);
    }

    private void setView(CalendarViewModel.CalendarType calendarType, Date date) {
        CalNavigationPanel calNavigationPanel = this.getCurrentView();
        if (calNavigationPanel != null) {
            calNavigationPanel.unLoad();
        }
        this.viewContainer.removeAll();
        CalNavigationPanel calNavigationPanel2 = (CalNavigationPanel)this.viewContainer.getClientProperty((Object)calendarType);
        if (calNavigationPanel2 == null) {
            calNavigationPanel2 = this.createView(calendarType, true, date);
        }
        this.viewContainer.add(calNavigationPanel2);
        this.viewContainer.invalidate();
        this.viewContainer.validate();
        this.viewContainer.doLayout();
    }

    protected CalNavigationPanel createView(CalendarViewModel.CalendarType calendarType, boolean bl, Date date) {
        switch (calendarType) {
            case MONTHLY: {
                return new MonthlyCalView(new CalendarViewModel(calendarType), this);
            }
            case WEEKLY: {
                return new WeekCalView(new CalendarViewModel(calendarType), this);
            }
            case DAILY: {
                return new DailyCalView(new CalendarViewModel(calendarType), this);
            }
        }
        return null;
    }

    public CalNavigationPanel getCurrentView() {
        if (this.viewContainer.getComponentCount() == 0) {
            return null;
        }
        return (CalNavigationPanel)this.viewContainer.getComponent(0);
    }

    public void setLoader(ICalendarDataLoader iCalendarDataLoader) {
        this.tasksCache = iCalendarDataLoader;
    }

    public CalendarViewModel.CalendarType getCalType() {
        if (this.pane.getSelectedIndex() == 0) {
            return CalendarViewModel.CalendarType.MONTHLY;
        }
        return CalendarViewModel.CalendarType.DETAIL;
    }

    public Component getTabView() {
        return this.pane;
    }

    public Date getFocusDate() {
        Component component = this.viewContainer.getComponent(0);
        if (component != null && component instanceof CalNavigationPanel) {
            return ((CalNavigationPanel)component).getFocusTime();
        }
        return new Date();
    }

    public void ensureTasksLoaded(Date date, Date date2) throws Exception {
        if (this.tasksCache == null) {
            return;
        }
        this.tasksCache.setDataAvailable(date, date2);
    }

    public TaskRenderer getTaskRenderer() {
        return this.taskRenderer;
    }

    public void setTaskRenderer(TaskRenderer taskRenderer) {
        this.taskRenderer = taskRenderer;
    }

    public void setFocusDate(Date date) {
        ((CalNavigationPanel)this.viewContainer.getComponent(0)).setFocusTime(date);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void loadData(Date date, Date date2) throws Exception {
        this.tasksCache.loadAndPopulateCache(date, date2);
    }

    public Component geView() {
        return this.viewContainer;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public void setDailyView(Date date) {
        this.pane.removeChangeListener((ChangeListener)this);
        this.pane.setSelectedIndex(1);
        this.setView(CalendarViewModel.CalendarType.DETAIL, date);
        this.pane.addChangeListener((ChangeListener)this);
        this.setFocusDate(date);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Date date = this.getFocusDate();
        this.setView(this.getCalType());
        this.setFocusDate(date);
    }

    public String getTooltipText(Date date) {
        return this.taskRenderer.getTooltipText(this, date);
    }

    public ICalendarDataLoader<T> getTasksCache() {
        return this.tasksCache;
    }

    public void refresh() {
        Date date = this.getFocusDate();
        this.getTasksCache().clear();
        this.getTasksCache().setFilter(this.getFilter());
        this.getFilter().refresh();
        this.setFocusDate(date);
    }
}

