/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.component.calender.CTask;
import commvault.cte.component.calender.CalendarUtil;
import commvault.cte.component.calender.CalenderFilter;
import commvault.cte.component.calender.ICalendarDataLoader;
import commvault.cte.component.calender.TasksForDay;
import commvault.cte.util.Logger;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractCalendarDataLoader<T>
implements ICalendarDataLoader<T> {
    Map<Integer, Year> calData = new Hashtable<Integer, Year>();
    private CalenderFilter filter;
    Vector avoidGC = new Vector();

    @Override
    public TasksForDay<T> getTasksForDay(Date date) {
        TasksForDay<T> tasksForDay = this.getTasksForDay1(date);
        return tasksForDay;
    }

    private TasksForDay<T> getTasksForDay1(Date date) {
        Calendar calendar = CalendarUtil.getDay(date);
        Year year = this.calData.get(calendar.get(1));
        if (year == null) {
            return null;
        }
        SoftReference softReference = year.days[calendar.get(6)];
        if (softReference == null) {
            return null;
        }
        return (TasksForDay)softReference.get();
    }

    @Override
    public Vector<CTask<T>> getTasksForTime(Date date, int n, int n2) {
        TasksForDay<T> tasksForDay = this.getTasksForDay(date);
        if (tasksForDay == null || tasksForDay.getTasks(this.filter) == null) {
            return null;
        }
        Vector<CTask<T>> vector = new Vector<CTask<T>>();
        for (CTask<T> cTask : tasksForDay.getTasks(this.filter)) {
            if (cTask.getTime() < n || cTask.getTime() >= n2) continue;
            vector.add(cTask);
        }
        return vector;
    }

    @Override
    public synchronized void setDataAvailable(Date date, Date date2) throws Exception {
        Logger.instance().println("from:" + date + " to:" + date2);
        this.avoidGC.clear();
        this.loadAndPopulateCache(date, date2);
        for (long i = date.getTime(); i < date2.getTime(); i += 86400000L) {
            TasksForDay<T> tasksForDay = this.getTasksForDay(new Date(i));
            this.avoidGC.add(tasksForDay);
        }
    }

    @Override
    public synchronized void loadAndPopulateCache(Date date, Date date2) throws Exception {
        long l;
        boolean bl = false;
        for (l = date.getTime(); l < date2.getTime(); l += 86400000L) {
            if (this.getTasksForDay(new Date(l)) != null) continue;
            date = new Date(l);
            bl = true;
            break;
        }
        for (l = date2.getTime(); l > date.getTime(); l -= 86400000L) {
            if (this.getTasksForDay(new Date(l)) != null) continue;
            date2 = new Date(l);
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Calendar calendar = CalendarUtil.getStartDayOfMonth(date);
        Calendar calendar2 = CalendarUtil.getEndDayOfMonth(date2);
        Logger.instance().println("actual loading time from:" + calendar.getTime() + " to:" + calendar2.getTime());
        Collection collection = this.loadTasks(calendar.getTime(), calendar2.getTime());
        while (calendar2.after(calendar)) {
            Year year = this.calData.get(calendar.get(1));
            if (year == null) {
                year = new Year(calendar);
                this.calData.put(calendar.get(1), year);
            }
            ((Year)year).days[calendar.get((int)6)] = new SoftReference(new TasksForDay());
            calendar.add(6, 1);
        }
        this.populateBuckets(collection);
    }

    protected void populateBuckets(Collection<CTask<T>> collection) {
        for (CTask<T> cTask : collection) {
            Date date = new Date((long)cTask.getTime() * 1000L);
            try {
                TasksForDay<T> tasksForDay = this.getTasksForDay1(date);
                tasksForDay.addTask(cTask);
                tasksForDay.setDisplayString(null);
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("Not Found:" + date);
                nullPointerException.printStackTrace();
            }
        }
    }

    @Override
    public void setFilter(CalenderFilter calenderFilter) {
        this.filter = calenderFilter;
        for (Year year : this.calData.values()) {
            for (SoftReference softReference : year.days) {
                if (softReference == null || softReference.get() == null) continue;
                ((TasksForDay)softReference.get()).setDisplayString(null);
            }
        }
    }

    @Override
    public synchronized void clear() {
        this.calData.clear();
    }

    static class Year {
        private SoftReference<TasksForDay>[] days;

        public Year(Calendar calendar) {
            this.days = new SoftReference[calendar.getMaximum(6) + 1];
        }
    }
}

