/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.util.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericDocument
extends PlainDocument {
    private long minValue = Integer.MIN_VALUE;
    private long maxValue = Integer.MAX_VALUE;
    private long validValue = 0L;
    private int maxChars = -1;
    private boolean allowNonNumericValue;

    public NumericDocument() {
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
    }

    public NumericDocument(long l, long l2) {
        this.minValue = l;
        this.maxValue = l2;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (this.getMaxChars() != -1) {
            try {
                if (string.length() + this.getContentString().length() > this.getMaxChars()) {
                    string = string.substring(0, this.getMaxChars() - this.getContentString().length());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.allowNonNumericValue) {
            super.insertString(n, string, attributeSet);
        } else {
            try {
                int n2 = this.getStartPosition().getOffset();
                int n3 = this.getLength();
                String string2 = this.getText(n2, n3);
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.insert(n, string);
                int n4 = Integer.parseInt(stringBuffer.toString());
                long l = this.validValue;
                if ((long)n4 < this.getMinValue() || (long)n4 > this.getMaxValue()) {
                    if ((long)this.getIntValue() >= this.getMinValue() && this.getContentString().length() != 0) {
                        return;
                    }
                    this.setLastKnownValidValue(l);
                    super.insertString(n, string, attributeSet);
                } else {
                    super.insertString(n, string, attributeSet);
                    this.setLastKnownValidValue(this.getIntValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void recalculateValue() {
        try {
            int n = this.getStartPosition().getOffset();
            int n2 = this.getLength();
            int n3 = Integer.parseInt(super.getText(n, n2));
            if ((long)n3 < this.getMinValue() || (long)n3 > this.getMaxValue()) {
                super.remove(n, n2);
            }
            if ((long)n3 < this.getMinValue()) {
                super.insertString(0, Long.toString(this.getMinValue()), null);
            } else if ((long)n3 > this.getMaxValue()) {
                super.insertString(0, Long.toString(this.getMaxValue()), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxValue(long l) {
        this.maxValue = l;
        this.recalculateValue();
    }

    public void setMinValue(long l) {
        this.minValue = l;
        this.recalculateValue();
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxValueReached() {
        return this.getMaxValue() <= (long)this.getIntValue();
    }

    public boolean isMinValueReached() {
        return this.getMinValue() >= (long)this.getIntValue();
    }

    public boolean isValidValue() {
        return this.getMaxValue() >= (long)this.getIntValue() && this.getMinValue() <= (long)this.getIntValue();
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getContentString());
        }
        catch (Exception exception) {
            return (int)this.minValue;
        }
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.getContentString());
        }
        catch (Exception exception) {
            return this.minValue;
        }
    }

    public String getContentString() throws Exception {
        int n = this.getStartPosition().getOffset();
        int n2 = this.getLength();
        return this.getText(n, n2);
    }

    public void setLastKnownValidValue(long l) {
        this.validValue = l;
    }

    public long getLastKnownValidValue() {
        return this.validValue;
    }

    public void resetToValidValue() {
        try {
            long l = this.getLastKnownValidValue();
            int n = this.getStartPosition().getOffset();
            int n2 = this.getLength();
            super.remove(n, n2);
            this.insertString(0, Long.toString(l), null);
        }
        catch (Exception exception) {
            Logger.write(Logger.INFO, this.getClass(), "resetToValidValue", "Exception in NumericDocument.resetToValidValue ():" + exception);
        }
    }

    public void setMaxChars(int n) {
        this.maxChars = n;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.allowNonNumericValue = bl;
    }

    public boolean isAllowNonNumericValue() {
        return this.allowNonNumericValue;
    }
}

