/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.common.SendMessage;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MailParamsDialog
extends PropertyDialog {
    protected JTextField smtpHost = new JTextField();
    protected JTextField toUser = new JTextField();
    protected JTextField fromUser = new JTextField();
    protected JTextField subject = new JTextField();
    protected String data = null;
    protected String fileName = null;
    private InitMailData initMailData;
    protected JPanel m_gridBtPanel = new JPanel(new GridLayout(1, 0, 8, 0));
    private String INVALID_ADDRESS = CteStringBank.Invalid_address.getI18n();

    public MailParamsDialog() {
        this.init();
    }

    public MailParamsDialog(JDialog jDialog) {
        this.init();
    }

    public void setData(String string) {
        this.data = string;
    }

    public String getData() {
        return this.data;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public MailParamsDialog(JFrame jFrame) {
        super(jFrame);
        this.init();
    }

    private void init() {
        this.setLocationRelativeTo(this.getParent());
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        Object var1_1 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (var1_1 != null) {
            for (int i = 0; i < (var1_1).length; ++i) {
                stringBuffer.append((String)var1_1[i]);
                if (i >= (var1_1).length - 1) continue;
                stringBuffer.append(",");
            }
        }
        this.smtpHost.setText(null);
        this.toUser.setText(stringBuffer.toString());
        this.fromUser.setText(null);
        this.subject.setText(null);
        Dimension dimension = this.smtpHost.getPreferredSize();
        dimension.width = 300;
        this.smtpHost.setPreferredSize(dimension);
        this.setTitle(CteStringBank.SMTP_Parameters.getI18n());
        JLabel jLabel = null;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabel = new JLabel(CteStringBank.SMTP_Host7_.getI18n());
        this.addRow(jPanel2, gridBagConstraints, jLabel, this.smtpHost);
        jLabel.setDisplayedMnemonic('H');
        jLabel.setLabelFor(this.smtpHost);
        jLabel = new JLabel(CteStringBank.To7.getI18n());
        this.addRow(jPanel2, gridBagConstraints, jLabel, this.toUser);
        jLabel.setLabelFor(this.toUser);
        jLabel.setDisplayedMnemonic('T');
        jLabel = new JLabel(CteStringBank.From7.getI18n());
        this.addRow(jPanel2, gridBagConstraints, jLabel, this.fromUser);
        jLabel.setLabelFor(this.fromUser);
        jLabel.setDisplayedMnemonic('F');
        jLabel = new JLabel(CteStringBank.Subject7.getI18n());
        this.addRow(jPanel2, gridBagConstraints, jLabel, this.subject);
        jLabel.setLabelFor(this.subject);
        jLabel.setDisplayedMnemonic('S');
        LayoutUtils.fillRemaining(jPanel2);
        this.getContentPane().add(jPanel2);
        this.okButton.setDefaultOn(true);
        this.pack();
    }

    private void addRow(JPanel jPanel, GridBagConstraints gridBagConstraints, JLabel jLabel, JTextField jTextField) {
        jPanel.add((Component)jLabel, Utilities.getConstraints(gridBagConstraints, -1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5)));
        jPanel.add((Component)jTextField, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 13, 1, new Insets(5, 10, 5, 30)));
    }

    @Override
    public void okButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(this.toUser.getText(), ",;");
        Vector<String> vector = new Vector<String>();
        this.fileName = this.fileName + ".txt";
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = string.trim()).length() == 0) continue;
            vector.addElement(string);
        }
        boolean bl = false;
        String string = null;
        if (!bl && vector.size() == 0) {
            bl = true;
            string = CteStringBank.Please_specify_at_least_one_recipient.getI18n();
        }
        if (!bl && this.fromUser.getText().trim().length() == 0) {
            bl = true;
            string = CteStringBank.Invalid_from_value.getI18n();
        }
        if (!bl && this.smtpHost.getText().trim().length() == 0) {
            bl = true;
            string = CteStringBank.Invalid_SMTP_host_name.getI18n();
        }
        if (bl) {
            Utilities.showErrorMessage(this, string);
            return;
        }
        String[] stringArray = new String[vector.size()];
        InternetAddress[] internetAddressArray = new InternetAddress[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            try {
                internetAddressArray[n] = new InternetAddress((String)vector.elementAt(n));
                stringArray[n] = (String)vector.elementAt(n);
                continue;
            }
            catch (Exception exception) {
                Utilities.showErrorMessage(this.INVALID_ADDRESS + ":  " + (String)vector.elementAt(n), this.INVALID_ADDRESS);
                return;
            }
        }
        n = 0;
        String string2 = null;
        try {
            SendMessage.sendMessage(this.smtpHost.getText(), this.subject.getText(), internetAddressArray, this.fromUser.getText(), this.data, this.fileName, true);
        }
        catch (SendFailedException sendFailedException) {
            Throwable throwable = sendFailedException;
            while ((throwable = ((MessagingException)throwable).getNextException()) instanceof MessagingException) {
            }
            n = 1;
            StringBuffer stringBuffer = new StringBuffer(CteStringBank.Error_in_sending_mail6.getI18n());
            CteStringBank.Error_in_sending_mail6.getI18n();
            if (throwable instanceof UnknownHostException) {
                stringBuffer.setLength(0);
                stringBuffer.append(CteStringBank.Unknown_Host_7.getI18n() + this.smtpHost.getText());
            } else if (throwable instanceof ConnectException) {
                stringBuffer.setLength(0);
                stringBuffer.append(throwable.toString());
            }
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            n = 1;
            string2 = exception.toString();
        }
        if (n != 0) {
            Utilities.showErrorMessage((Component)this, string2, CteStringBank.Error_in_sending_mail6.getI18n());
            return;
        }
        this.cancelButtonActionPerformed(actionEvent);
    }

    public void update(Observable observable, Object object) {
    }

    public InitMailData getInitMailData() {
        return this.initMailData;
    }

    public void setInitMailData(InitMailData initMailData) {
        this.initMailData = initMailData;
        if (initMailData == null) {
            return;
        }
        this.subject.setText(initMailData.subject);
        this.fromUser.setText(initMailData.from);
        this.smtpHost.setText(initMailData.host);
        this.toUser.setText(Utilities.join(initMailData.recepients, ","));
    }

    public void setDefaultFocus() {
        this.toUser.requestFocus();
    }

    public static class InitMailData {
        public String[] recepients;
        public String host;
        public String from;
        public String subject;

        public InitMailData(String[] stringArray, String string, String string2, String string3) {
            this.recepients = stringArray;
            this.host = string;
            this.from = string2;
            this.subject = string3;
        }
    }
}

