/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.NumericDocument2;
import commvault.cte.component.NumericTextField2;
import commvault.cte.component.StickyButton;
import commvault.cte.component.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class JNumericTextField2
extends JPanel
implements ActionListener,
KeyListener,
NumericTextField2.FocusLostListener {
    private int incrementalValue = 1;
    NumericTextField2 nField;
    StickyButton incrButton = new StickyButton(1);
    StickyButton decrButton = new StickyButton(5);
    private static final String incr = CteStringBank.INCR.getI18n();
    private static final String decr = CteStringBank.DECR.getI18n();
    public static final int AUTO_RESET_TO_LAST_VALID = 0;
    public static final int AUTO_POPUP_ERROR = 1;
    public static final int RETURN_ERROR = 2;
    int behavior = 0;
    private int incrementalMode = 0;
    public static final int LINEAR = 0;
    public static final int MULTIPLY = 1;
    private JLabel unitLabel = new JLabel();
    private Vector listeners = new Vector();

    public JNumericTextField2(String string, NumericDocument2 numericDocument2, int n) {
        this(string, numericDocument2, null);
        this.behavior = n;
        this.nField.setBehavior(n);
    }

    public JNumericTextField2(String string, int n, NumericDocument2 numericDocument2) {
        this(string, numericDocument2, null);
        this.nField.setColumns(n);
    }

    public JNumericTextField2(String string, NumericDocument2 numericDocument2) {
        this(string, numericDocument2, null);
    }

    public JNumericTextField2(String string, NumericDocument2 numericDocument2, String string2) {
        this.setLayout(new BorderLayout(1, 1));
        this.nField = new NumericTextField2(string, numericDocument2);
        this.add((Component)this.nField, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.incrButton);
        jPanel.add(this.decrButton);
        if (string2 == null) {
            this.add((Component)jPanel, "East");
        } else {
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add((Component)jPanel, "West");
            this.unitLabel.setOpaque(false);
            jPanel2.add((Component)this.unitLabel, "East");
            this.setUnit(string2);
            this.add((Component)jPanel2, "East");
            jPanel2.setOpaque(false);
        }
        this.incrButton.setActionCommand(incr);
        this.decrButton.setActionCommand(decr);
        this.incrButton.addActionListener(this);
        this.decrButton.addActionListener(this);
        this.nField.addKeyListener(this);
        this.nField.addFocusLostListener(this);
    }

    public void setEditable(boolean bl) {
        this.nField.setEditable(bl);
    }

    @Override
    public void lostFocus() {
        this.triggerActionEvent();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (incr.equals(actionEvent.getActionCommand())) {
            long l = 0L;
            if (this.nField.getText().trim().equals("") || this.nField.getMinValue() > this.nField.getLongValue()) {
                l = this.nField.getMinValue();
            } else {
                l = Long.parseLong(this.nField.getText());
                l = this.getNextIncrementedValue();
                if (l > this.nField.getMaxValue()) {
                    l = this.nField.getMaxValue();
                }
            }
            this.nField.setText(String.valueOf(l));
            this.checkList();
        } else if (decr.equals(actionEvent.getActionCommand())) {
            long l = 0L;
            if (this.nField.getText().trim().equals("")) {
                l = this.nField.getMinValue();
            } else {
                l = Long.parseLong(this.nField.getText());
                l = this.getNextDecrementedValue();
                if (l < this.nField.getMinValue()) {
                    l = this.nField.getMinValue();
                }
            }
            this.nField.setText(String.valueOf(l));
            this.checkList();
        }
        this.triggerActionEvent();
    }

    public JNumericTextField2() {
        this.nField = new NumericTextField2();
    }

    public long getLong() {
        return new Long(this.nField.getText());
    }

    public void setLong(long l) {
        this.setText(Long.toString(l));
    }

    public int getIntValue() {
        return new Integer(this.nField.getText());
    }

    public void setIntValue(int n) {
        this.setText(Integer.toString(n));
    }

    public void setText(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.nField.setText(string);
    }

    public void setNonNumericText(String string) {
        this.nField.setNonNumericText(string);
    }

    public String getText() {
        return this.nField.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.nField.setEnabled(bl);
        this.incrButton.setEnabled(bl);
        this.decrButton.setEnabled(bl);
    }

    public NumericTextField2 getTextField() {
        return this.nField;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void triggerActionEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(new ActionEvent(this, 1, "Command"));
        }
    }

    public long getMaxValue() {
        return this.nField.getMaxValue();
    }

    public long getMinValue() {
        return this.nField.getMinValue();
    }

    public void setMaxValue(long l) {
        this.nField.setMaxValue(l);
    }

    public void setMinValue(long l) {
        this.nField.setMinValue(l);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.nField) {
            if (keyEvent.getKeyCode() == 38) {
                this.incrButton.doClick();
            } else if (keyEvent.getKeyCode() == 40) {
                this.decrButton.doClick();
            }
        }
    }

    public void checkList() {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public long getLongValue() {
        return this.nField.getLongValue();
    }

    @Override
    public void requestFocus() {
        this.nField.requestFocus();
    }

    public boolean isInvalidValue() {
        boolean bl = this.nField.isInvalidValue();
        if (bl) {
            if (this.behavior == 1) {
                Utilities.showErrorMessage(CteStringBank.Please_enter_valid_value6.getI18n());
            }
            this.requestFocus();
        }
        return bl;
    }

    public void setIncrementalValue(int n) {
        this.incrementalValue = n;
    }

    public int getIncrementalValue() {
        return this.incrementalValue;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nField.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nField.isAllowNonNumericValue();
    }

    public void setColumns(int n) {
        this.nField.setColumns(n);
    }

    public long getNextIncrementedValue() {
        if (this.incrementalMode == 1) {
            return this.getLong() * (long)this.incrementalValue;
        }
        return this.getLong() + (long)this.incrementalValue;
    }

    public long getNextDecrementedValue() {
        if (this.incrementalMode == 1) {
            return this.getLong() / (long)this.incrementalValue;
        }
        return this.getLong() - (long)this.incrementalValue;
    }

    public void setIncrementalMode(int n) {
        this.incrementalMode = n;
    }

    public void setUnit(String string) {
        this.unitLabel.setText(string);
    }
}

