/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.list.AbstractGroupableListModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GroupListModel<T, E>
extends AbstractGroupableListModel {
    private LinkedHashMap<T, List<E>> groupToMembersMap;
    private Comparator<E> comparator;

    public GroupListModel(LinkedHashMap<T, List<E>> linkedHashMap, Comparator<E> comparator) {
        this.groupToMembersMap = linkedHashMap;
        this.comparator = comparator;
        this.sort();
    }

    public Object getGroupAt(int n) {
        int n2 = 0;
        for (T t : this.groupToMembersMap.keySet()) {
            if (n >= (n2 += this.groupToMembersMap.get(t).size())) continue;
            return t;
        }
        return null;
    }

    public Object getElementAt(int n) {
        int n2 = 0;
        for (T t : this.groupToMembersMap.keySet()) {
            if (n < n2 + this.groupToMembersMap.get(t).size()) {
                return this.groupToMembersMap.get(t).get(n - n2);
            }
            n2 += this.groupToMembersMap.get(t).size();
        }
        return null;
    }

    public int getSize() {
        int n = 0;
        for (T t : this.groupToMembersMap.keySet()) {
            n += this.groupToMembersMap.get(t).size();
        }
        return n;
    }

    public Object[] getGroups() {
        return this.groupToMembersMap.keySet().toArray();
    }

    public Map<T, List<E>> getElementsAt(int ... nArray) {
        HashMap hashMap = new HashMap();
        for (int n : nArray) {
            this.getElementAt(n, hashMap);
        }
        return hashMap;
    }

    private void getElementAt(int n, Map<T, List<E>> map) {
        int n2 = 0;
        Object e = null;
        Object k = null;
        for (T t : this.groupToMembersMap.keySet()) {
            if (--n - n2 < 0) {
                return;
            }
            if (n < n2 + this.groupToMembersMap.get(t).size()) {
                e = this.groupToMembersMap.get(t).get(n - n2);
                k = t;
                break;
            }
            n2 += this.groupToMembersMap.get(t).size();
        }
        if (e == null || k == null) {
            return;
        }
        if (!map.containsKey(k) || map.get(k) == null) {
            map.put(k, new LinkedList());
        }
        map.get(k).add(e);
    }

    public Map<T, List<E>> removeElements(int ... nArray) {
        Map<Object, Object> map = new HashMap();
        map = this.getElementsAt(nArray);
        this.removeElements(map);
        return map;
    }

    public void removeElements(Map<T, List<E>> map) {
        for (T t : map.keySet()) {
            if (this.groupToMembersMap.get(t) == null) continue;
            for (E e : map.get(t)) {
                this.groupToMembersMap.get(t).remove(e);
            }
        }
        this.fireGroupChanged((Object)this);
    }

    public boolean addElements(Map<T, List<E>> map) {
        boolean bl = true;
        for (T t : map.keySet()) {
            for (E e : map.get(t)) {
                if (!this.groupToMembersMap.get(t).contains(e)) {
                    this.groupToMembersMap.get(t).add(e);
                    continue;
                }
                bl = false;
            }
        }
        this.sort();
        this.fireGroupChanged((Object)this);
        return bl;
    }

    public void moveElementsTo(GroupListModel<T, E> groupListModel, int ... nArray) {
        Map<T, List<E>> map = this.removeElements(nArray);
        groupListModel.addElements(map);
        this.sort();
        groupListModel.sort();
        this.fireGroupChanged((Object)this);
        this.fireGroupChanged(groupListModel);
    }

    public void moveAllElementsTo(GroupListModel<T, E> groupListModel) {
        HashMap<T, List<E>> hashMap = new HashMap<T, List<E>>();
        hashMap.putAll(this.groupToMembersMap);
        groupListModel.addElements(hashMap);
        for (T t : groupListModel.groupToMembersMap.keySet()) {
            this.groupToMembersMap.get(t).clear();
        }
        this.sort();
        groupListModel.sort();
        this.fireGroupChanged((Object)this);
        this.fireGroupChanged((Object)groupListModel);
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public void sort() {
        if (this.comparator != null) {
            for (T t : this.groupToMembersMap.keySet()) {
                Collections.sort(this.groupToMembersMap.get(t), this.comparator);
            }
        }
    }
}

