/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.CXTextField;
import commvault.cte.component.NameTextField;
import commvault.cte.component.Utilities;
import commvault.cte.util.StringPath;

public class FSTextField
extends NameTextField {
    private static final String prefix = "cte.component.FSTextField";
    private boolean checkForDriveLetter = true;
    String separator = "\\";
    int order = 0;
    boolean acceptPattern = false;
    String errorString = CteStringBank.Invalid_path.getI18n();

    public void setErrorString(String string) {
        this.errorString = string;
    }

    public FSTextField(String string, int n) {
        this.separator = string;
        this.order = n;
    }

    public FSTextField() {
        this("\\", 0);
    }

    public String getSeparator() {
        return this.separator;
    }

    public StringPath getPath() {
        String string = this.getText().trim();
        if (this.acceptPattern && this.isPattern(string)) {
            return StringPath.getPatternStringPath(string);
        }
        if (this.validatePath(string, this.separator)) {
            return this.newStringPath(string);
        }
        this.UtilitiesshowErrorMessage();
        this.requestFocus();
        return null;
    }

    public StringPath getPath(boolean bl) {
        String string;
        if (bl && this.hasWildCard(string = this.getText().trim())) {
            return StringPath.getWildCardStringPath(string, string);
        }
        return this.getPath();
    }

    boolean hasWildCard(String string) {
        return StringPath.hasWildCard(string);
    }

    boolean isPattern(String string) {
        if (string.length() == 0) {
            return false;
        }
        return string.indexOf(this.separator) < 0;
    }

    public void setAcceptW(boolean bl) {
        this.acceptPattern = bl;
    }

    StringPath newStringPath(String string) {
        CXTextField cXTextField = new CXTextField(this.separator);
        cXTextField.setCheckForDriveLetter(this.getCheckForDriveLetter());
        cXTextField.setText(string);
        string = cXTextField.getText();
        return new StringPath(string, this.separator, this.order, true);
    }

    void UtilitiesshowErrorMessage() {
        Utilities.showErrorMessage(this.errorString);
    }

    public boolean validatePath(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        CXTextField cXTextField = new CXTextField(string2);
        cXTextField.setCheckForDriveLetter(this.getCheckForDriveLetter());
        cXTextField.setText(string);
        string = cXTextField.getText();
        return string != null;
    }

    public static FSTextField getTextField(boolean bl) {
        if (bl) {
            return new FSTextField("\\", 1);
        }
        return new FSTextField("/", 0);
    }

    public void setCheckForDriveLetter(boolean bl) {
        this.checkForDriveLetter = bl;
    }

    public boolean getCheckForDriveLetter() {
        return this.checkForDriveLetter;
    }
}

