/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.SList;
import commvault.cte.component.SortedListModel;
import commvault.cte.component.events.ListClickListener;
import commvault.cte.net.IdNameItem;
import commvault.cte.util.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;

public class DnDList
extends SList
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
ListClickListener {
    protected boolean allowDragging = true;
    protected Vector acceptableObjs = new Vector();
    protected DnDList dragSourceList;
    protected DnDList dropTargetList;
    private boolean isCurrentlyDragging = false;
    protected EventListenerList dndListenerList = new EventListenerList();
    protected EventListenerList dndActionListenerList;
    protected EventListenerList dndSelectionListenerList;

    public DnDList() {
        this.init();
    }

    public DnDList(ListModel listModel) {
        this.init(listModel);
    }

    public DnDList(Object[] objectArray) {
        this.init();
        this.addElements(objectArray);
    }

    public DnDList(Vector vector) {
        this.init();
        this.addElements(vector);
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof SortedListModel)) {
            throw new IllegalArgumentException("Model for DnDList can only be SortedListModel and it's subclasses");
        }
        super.setModel(listModel);
    }

    private void init() {
        this.init(new SortedListModel());
    }

    private void init(ListModel listModel) {
        this.acceptableObjs.addElement("java.lang.String");
        this.acceptableObjs.addElement("commvault.cte.net.IdIdNameItem");
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, 2, this, true);
        super.addListClickListener(this);
        this.setModel(listModel);
    }

    public void addElements(Object[] objectArray) {
        SortedListModel sortedListModel = (SortedListModel)super.getModel();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel.addElement(objectArray[i]);
        }
    }

    public void addElements(Vector vector) {
        SortedListModel sortedListModel = (SortedListModel)super.getModel();
        for (int i = 0; i < vector.size(); ++i) {
            sortedListModel.addElement(vector.get(i));
        }
    }

    public void setDragSourceList(DnDList dnDList) {
        this.dragSourceList = dnDList;
    }

    public DnDList getDragSourceList() {
        return this.dragSourceList;
    }

    public void setDropTargetList(DnDList dnDList) {
        this.dropTargetList = dnDList;
    }

    public DnDList getDropTargetList() {
        return this.dropTargetList;
    }

    public boolean getAllowsDragging() {
        return this.allowDragging;
    }

    public void setAllowsDragging(boolean bl) {
        this.allowDragging = bl;
    }

    public void addAcceptableDropObject(String string) {
        this.acceptableObjs.addElement(string);
    }

    public boolean acceptDropObject(Object object) {
        return this.acceptDropObject(object.getClass().getName());
    }

    public boolean acceptDropObject(String string) {
        return this.acceptableObjs.contains(string);
    }

    public boolean canDrag() {
        return this.getAllowsDragging() && this.fireDnDActionListener();
    }

    public String getSelectionAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].toString());
            if (i == objectArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Transferable getTransferableObj() {
        if (this.getSelectedValues().length == 1 && this.getSelectedValues()[0] instanceof Transferable) {
            try {
                return (Transferable)((Transferable)this.getSelectedValues()[0]).getTransferData(null);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
        StringSelection stringSelection = new StringSelection(this.getSelectionAsString());
        return stringSelection;
    }

    public void removeSelectedValues() {
        Object[] objectArray = this.getSelectedValues();
        if (!(super.getModel() instanceof SortedListModel)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((SortedListModel)super.getModel()).removeElement(objectArray[i]);
        }
    }

    public Transferable getTransferableObj(int n) throws ArrayIndexOutOfBoundsException {
        Object e = this.getModel().getElementAt(n);
        StringSelection stringSelection = new StringSelection(e.toString());
        return stringSelection;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.isCurrentlyDragging = false;
        if (!this.canDrag()) {
            return;
        }
        if ((dragGestureEvent.getDragAction() & 2) == 0) {
            return;
        }
        if (dragGestureEvent.getComponent() != this) {
            return;
        }
        Transferable transferable = this.getTransferableObj();
        this.isCurrentlyDragging = true;
        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
        this.dropTargetList.setDragSourceList(this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if ((dragSourceDragEvent.getDropAction() & 2) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.isCurrentlyDragging = false;
        if (!dragSourceDropEvent.getDropSuccess()) {
            return;
        }
        Object[] objectArray = this.getSelectedValues();
        if (dragSourceDropEvent.getDropAction() == 2) {
            this.removeDroppedValues();
        }
        this.fireDnDPerformed();
        this.firePostDnDSelectionUpdate(objectArray);
    }

    private void removeDroppedValues() {
        Object[] objectArray = this.getSelectedValues();
        if (!(this.getModel() instanceof SortedListModel)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((SortedListModel)this.dropTargetList.getModel()).contains(objectArray[i])) continue;
            ((SortedListModel)this.getModel()).removeElement(objectArray[i]);
        }
    }

    protected void fireDnDPerformed() {
        Object[] objectArray = this.dndListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DnDPerformedListener)) continue;
            ((DnDPerformedListener)object).dndPerformed(this);
        }
    }

    protected void firePostDnDSelectionUpdate(Object[] objectArray) {
        if (this.dndSelectionListenerList == null) {
            return;
        }
        Object[] objectArray2 = this.dndSelectionListenerList.getListenerList();
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof DnDSelectionListener)) continue;
            ((DnDSelectionListener)object).postDnDSelectionUpdate(this, objectArray);
        }
    }

    protected boolean fireDnDActionListener() {
        if (this.dndActionListenerList == null) {
            return true;
        }
        Object[] objectArray = this.dndActionListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DnDActionListener) || ((DnDActionListener)object).canPerformDnD(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentlyDragging() {
        return this.isCurrentlyDragging;
    }

    protected boolean acceptDrop(DropTargetDragEvent dropTargetDragEvent) {
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        DnDList dnDList = this.getDragSourceList();
        return dnDList != null && !dropTargetContext.getComponent().equals(dnDList);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Logger.write(Logger.INFO, this, "drop", "Component dropped");
        dropTargetDropEvent.getDropTargetContext();
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            System.err.println("No flavor match found");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.getDropAction();
        int n = dropTargetDropEvent.getSourceActions();
        if ((n & 2) == 0) {
            System.err.println("No action match found");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(2);
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't get transfer data: " + throwable.getMessage());
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (this.acceptDropObject(object)) {
            if (object instanceof String) {
                dropTargetDropEvent.dropComplete(this.processDropObject((String)object));
            } else {
                dropTargetDropEvent.dropComplete(this.processDropObject(object));
            }
        } else {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.dropComplete(true);
    }

    protected boolean processDropObject(Object object) {
        DnDList dnDList = this.getDragSourceList();
        if (dnDList == null) {
            return false;
        }
        if (!dnDList.isCurrentlyDragging()) {
            return false;
        }
        ((SortedListModel)super.getModel()).addElement(object);
        return true;
    }

    protected boolean processDropObject(String string) {
        if (!(string instanceof String)) {
            return false;
        }
        DnDList dnDList = this.getDragSourceList();
        if (dnDList == null) {
            return false;
        }
        if (!dnDList.isCurrentlyDragging()) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Object object = this.getMatchingObject(string2);
            if (object == null) {
                return false;
            }
            vector.addElement(object);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ((SortedListModel)super.getModel()).addElement(vector.elementAt(i));
        }
        return true;
    }

    protected Object getMatchingObject(String string) {
        DnDList dnDList = this.getDragSourceList();
        for (int i = 0; i < dnDList.getModel().getSize(); ++i) {
            if (!dnDList.getModel().getElementAt(i).toString().equals(string)) continue;
            return dnDList.getModel().getElementAt(i);
        }
        return null;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isLocalTransfer()) {
            return null;
        }
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    public void performDnD(int n) {
        if (!this.canDrag()) {
            return;
        }
        DnDList dnDList = this.getDropTargetList();
        DnDList dnDList2 = dnDList.getDragSourceList();
        dnDList.setDragSourceList(this);
        String string = this.getSelectionAsString();
        this.isCurrentlyDragging = true;
        Object[] objectArray = null;
        if (dnDList.processDropObject(string) && (objectArray = this.getSelectedValues()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((SortedListModel)this.getModel()).removeElement(objectArray[i]);
            }
        }
        this.isCurrentlyDragging = false;
        dnDList.setDragSourceList(dnDList2);
        this.fireDnDPerformed();
        this.firePostDnDSelectionUpdate(objectArray);
    }

    @Override
    public void mouseClicked(JComponent jComponent, int n, int n2) {
        if (n2 < 0 || n2 > this.getModel().getSize()) {
            return;
        }
        if (n != 2) {
            return;
        }
        DnDList dnDList = this.getDropTargetList();
        if (dnDList == null || jComponent != this) {
            return;
        }
        this.performDnD(n2);
    }

    public void addDnDPerformedListener(DnDPerformedListener dnDPerformedListener) {
        this.dndListenerList.add(DnDPerformedListener.class, dnDPerformedListener);
    }

    public void removeDnDPerformedListener(DnDPerformedListener dnDPerformedListener) {
        this.dndListenerList.remove(DnDPerformedListener.class, dnDPerformedListener);
    }

    public void addDnDActionListener(DnDActionListener dnDActionListener) {
        if (this.dndActionListenerList == null) {
            this.dndActionListenerList = new EventListenerList();
        }
        this.dndActionListenerList.add(DnDActionListener.class, dnDActionListener);
    }

    public void removeDnDActionListener(DnDActionListener dnDActionListener) {
        this.dndActionListenerList.remove(DnDActionListener.class, dnDActionListener);
        if (this.dndActionListenerList.getListenerCount() == 0) {
            this.dndActionListenerList = null;
        }
    }

    public void addDnDSelectionListener(DnDSelectionListener dnDSelectionListener) {
        if (this.dndSelectionListenerList == null) {
            this.dndSelectionListenerList = new EventListenerList();
        }
        this.dndSelectionListenerList.add(DnDSelectionListener.class, dnDSelectionListener);
    }

    public void removeDnDSelectionListener(DnDSelectionListener dnDSelectionListener) {
        this.dndSelectionListenerList.remove(DnDSelectionListener.class, dnDSelectionListener);
        if (this.dndSelectionListenerList.getListenerCount() == 0) {
            this.dndSelectionListenerList = null;
        }
    }

    public void disposeOff() {
        this.dragSourceList = null;
        this.dropTargetList = null;
        this.dndListenerList = null;
        this.dndActionListenerList = null;
        this.dndSelectionListenerList = null;
    }

    public static interface DnDSelectionListener
    extends EventListener {
        public void postDnDSelectionUpdate(Object var1, Object[] var2);
    }

    public static interface DnDActionListener
    extends EventListener {
        public boolean canPerformDnD(Object var1);
    }

    public static interface IncludeExcludeListListener {
        public IdNameItem addToIncludeList(Vector var1);

        public IdNameItem addToExcludeList(Vector var1);
    }

    public static interface DnDPerformedListener
    extends EventListener {
        public void dndPerformed(Object var1);
    }
}

