/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.common.DesktopBrowserLauncher;
import commvault.cte.component.EditorPaneLinkDetector;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.CTEAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;

public class DescriptionPanel
extends JPanel {
    private String oldValue = "";
    private EditorPaneLinkDetector textArea;
    private boolean editable = true;
    private int maxNumberOfChars = 4000;
    private Border border;
    private boolean html = false;
    boolean descriptionSetForTheFirstTime = true;

    public DescriptionPanel() {
        this.init();
    }

    public EditorPaneLinkDetector getTextArea() {
        return this.textArea;
    }

    private void init() {
        this.textArea = new EditorPaneLinkDetector(){

            @Override
            protected EditorPaneLinkDetector.HTMLDocLinkDetector createDocument(StyleSheet styleSheet) {
                return new EditorPaneLinkDetector.HTMLDocLinkDetector(styleSheet){

                    @Override
                    public void remove(int n, int n2) throws BadLocationException {
                        String string = DescriptionPanel.this.textArea.getText();
                        super.remove(n, n2);
                        if (!DescriptionPanel.this.isHtml() || DescriptionPanel.this.isEmptyDescription()) {
                            DescriptionPanel.this.firePropertyChange("description", string, DescriptionPanel.this.getPlainText());
                        } else {
                            DescriptionPanel.this.firePropertyChange("description", string, DescriptionPanel.this.textArea.getText());
                        }
                    }

                    @Override
                    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (string.indexOf("href=") >= 0) {
                            DescriptionPanel.this.setHtml(true);
                        }
                        int n2 = DescriptionPanel.this.textArea.getDocument().getLength();
                        String string2 = DescriptionPanel.this.textArea.getDocument().getText(0, n2).trim();
                        if (string2.length() >= DescriptionPanel.this.maxNumberOfChars) {
                            Utilities.showInfoMessage(DescriptionPanel.this, CteStringBank.DescriptionPanel_limit.getI18n(), CteStringBank.Warning.getI18n());
                            try {
                                DescriptionPanel.this.textArea.getDocument().remove(DescriptionPanel.this.maxNumberOfChars, n2 - DescriptionPanel.this.maxNumberOfChars);
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                                DescriptionPanel.this.textArea.setText(string2.substring(0, DescriptionPanel.this.maxNumberOfChars));
                            }
                            return;
                        }
                        super.insertString(n, string, attributeSet);
                        DescriptionPanel.this.textArea.correctLinks();
                        if (!DescriptionPanel.this.isHtml() || DescriptionPanel.this.isEmptyDescription()) {
                            DescriptionPanel.this.firePropertyChange("description", string2, DescriptionPanel.this.getPlainText());
                        } else {
                            DescriptionPanel.this.firePropertyChange("description", string2, DescriptionPanel.this.textArea.getText());
                        }
                    }
                };
            }

            @Override
            public int getCaretPosition() {
                if (DescriptionPanel.this.descriptionSetForTheFirstTime) {
                    return Integer.MAX_VALUE;
                }
                return super.getCaretPosition();
            }
        };
        Action action = this.textArea.getActionMap().get("paste-from-clipboard");
        this.textArea.getActionMap().put("paste-from-clipboard", new CTEAction(action){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = DescriptionPanel.this.textArea.getText();
                DescriptionPanel.this.setHtml(true);
                try {
                    Integer n2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                        @Override
                        public Integer run() throws Exception {
                            Transferable transferable = DescriptionPanel.this.textArea.getToolkit().getSystemClipboard().getContents(null);
                            DataFlavor dataFlavor = new DataFlavor("text/html;class=java.lang.String");
                            for (DataFlavor dataFlavor2 : transferable.getTransferDataFlavors()) {
                                String string;
                                String string2;
                                Object object;
                                if (!dataFlavor2.equals(dataFlavor) || (object = transferable.getTransferData(dataFlavor2)) == null || (string2 = object.toString()).length() <= 1024 || (string = DescriptionPanel.this.getPlainText(string2)).length() >= 1024) continue;
                                JOptionPane.showMessageDialog(DescriptionPanel.this.textArea, CteStringBank.Descriptionpanel_paste_warning.getI18n());
                                DescriptionPanel.this.textArea.replaceSelection(string);
                                return 1;
                            }
                            return 0;
                        }
                    });
                    if (n2 == 1) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                super.actionPerformed(actionEvent);
                int n3 = DescriptionPanel.this.textArea.getDocument().getLength();
                String string2 = "";
                try {
                    string2 = DescriptionPanel.this.textArea.getDocument().getText(0, n3).trim();
                    n = string2.length();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string2 = DescriptionPanel.this.textArea.getText();
                    n = n3;
                }
                if (n >= DescriptionPanel.this.maxNumberOfChars) {
                    Utilities.showInfoMessage(DescriptionPanel.this, CteStringBank.DescriptionPanel_limit.getI18n(), CteStringBank.Warning.getI18n());
                    try {
                        DescriptionPanel.this.textArea.getDocument().remove(DescriptionPanel.this.maxNumberOfChars, n3 - DescriptionPanel.this.maxNumberOfChars);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                        DescriptionPanel.this.textArea.setText(string2.substring(0, DescriptionPanel.this.maxNumberOfChars));
                    }
                }
                if (!DescriptionPanel.this.isHtml() || DescriptionPanel.this.isEmptyDescription()) {
                    DescriptionPanel.this.firePropertyChange("description", string, DescriptionPanel.this.getPlainText());
                } else {
                    DescriptionPanel.this.firePropertyChange("description", string, DescriptionPanel.this.textArea.getText());
                }
            }
        });
        this.textArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                URL uRL = hyperlinkEvent.getURL();
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        if (uRL == null && hyperlinkEvent.getDescription().toLowerCase().startsWith("www.")) {
                            uRL = new URL("http://" + hyperlinkEvent.getDescription());
                        }
                        DesktopBrowserLauncher.openURL(uRL.toExternalForm());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.add(jScrollPane);
        this.setPreferredSize(new Dimension(300, 95));
        this.setBorder(new TitledBorder(CteStringBank.Description.getI18n()){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(20, 10, 10, 10);
            }
        });
    }

    protected String getPlainText(String string) throws Exception {
        final StringBuffer stringBuffer = new StringBuffer();
        new HTMLEditorKit.ParserCallback(){

            public void parse(Reader reader) throws IOException {
                ParserDelegator parserDelegator = new ParserDelegator();
                parserDelegator.parse(reader, this, Boolean.TRUE);
            }

            @Override
            public void handleText(char[] cArray, int n) {
                stringBuffer.append(cArray);
            }

            public String getText() {
                return stringBuffer.toString();
            }
        }.parse(new StringReader(string));
        return stringBuffer.toString();
    }

    public DescriptionPanel(String string) {
        this.init();
        this.setDescription(string);
    }

    public synchronized String getDescription() {
        if (!this.isHtml() || this.isEmptyDescription()) {
            return this.getPlainText();
        }
        int n = this.textArea.getDocument().getLength();
        int n2 = 0;
        try {
            n2 = this.textArea.getDocument().getText(0, n).trim().length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n2 = n;
        }
        try {
            if (n2 >= this.maxNumberOfChars) {
                return this.textArea.getDocument().getText(0, this.maxNumberOfChars).trim();
            }
            return this.textArea.getDocument().getText(0, n).trim();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return this.textArea.getText();
        }
    }

    private boolean isEmptyDescription() {
        return this.getPlainText().equals("");
    }

    public String getPlainText() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setDocument(this.textArea.getDocument());
        String string = jTextArea.getText();
        if (string.length() > 0 && string.charAt(0) == '\n') {
            return string.substring(1);
        }
        return string;
    }

    public synchronized void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() >= this.maxNumberOfChars) {
            string = string.substring(0, this.maxNumberOfChars);
        }
        this.setDescription1(string);
    }

    private void setDescription1(String string) {
        if (this.descriptionSetForTheFirstTime) {
            if (this.isHtml(string)) {
                this.setHtml(true);
                this.textArea.setText(string);
            } else {
                this.setHtml(false);
                try {
                    this.textArea.getDocument().insertString(0, string, null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            this.descriptionSetForTheFirstTime = false;
        } else {
            if (this.hasFocus() || this.oldValue.equals(string)) {
                return;
            }
            if (this.isHtml(string)) {
                this.setHtml(true);
                this.textArea.setText(string);
            } else {
                this.setHtml(false);
                try {
                    this.textArea.getDocument().insertString(0, string, null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        this.oldValue = string;
    }

    private boolean isHtml(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().toLowerCase().startsWith("<html>");
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    public boolean isModified() {
        if (!this.textArea.isEditable()) {
            return false;
        }
        return this.oldValue == null || !this.textArea.getText().equalsIgnoreCase(this.oldValue);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.textArea.setEditable(bl);
    }

    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public boolean hasFocus() {
        return this.textArea.hasFocus();
    }

    @Override
    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public String validateDescription() {
        int n = this.isHtml() ? this.textArea.getDocument().getLength() : this.textArea.getText().length();
        if (n >= this.maxNumberOfChars) {
            return MessageFormat.format(CteStringBank.DescriptionPanel_limit2.getI18n(), this.maxNumberOfChars, n);
        }
        return null;
    }

    public void setMaxNumberOfCharacters(int n) {
        this.maxNumberOfChars = n;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        super.setBorder(border);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean bl) {
        this.html = bl;
    }

    public void resetDescription(String string) {
        this.textArea.setText(string);
        this.oldValue = string;
    }

    public static final class Clipboard {
        public static String text() throws Exception {
            Object object = Clipboard.clipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            if (object instanceof String) {
                return (String)object;
            }
            return null;
        }

        public static void clear() {
            try {
                Clipboard.clipboard().setContents(new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[0];
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                        return false;
                    }

                    @Override
                    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                        throw new UnsupportedFlavorException(dataFlavor);
                    }
                }, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public static void copy(String string) {
            Clipboard.clipboard().setContents(new StringSelection(string), null);
        }

        private static java.awt.datatransfer.Clipboard clipboard() {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }

        private Clipboard() {
        }

        public static Clipboard getClipboard() {
            return new Clipboard();
        }
    }
}

