/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.ControlledDocument;
import commvault.cte.component.LabelLikeTextField;
import java.util.Vector;
import javax.swing.text.Document;

public class ControlledTextField
extends LabelLikeTextField {
    private Vector rules = null;
    private String lastErrorMessage = "";
    private String lastRuleIdentifier = "";

    public ControlledTextField() {
        this.setDocument(new ControlledDocument());
    }

    public ControlledTextField(ControlledDocument controlledDocument) {
        this.setDocument(controlledDocument);
    }

    public ControlledTextField(String string, String string2) {
        this.setDocument(new ControlledDocument(string2));
        this.setText(string);
    }

    public ControlledTextField(String string, String string2, int n) {
        this.setDocument(new ControlledDocument(string2, n));
        this.setText(string);
    }

    public ControlledTextField(String string, int n) {
        this.setDocument(new ControlledDocument(n));
        this.setText(string);
    }

    public ControlledTextField(int n) {
        super(new ControlledDocument(), "", n);
    }

    public ControlledTextField(String string) {
        this.setDocument(new ControlledDocument());
        this.setText(string);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(true);
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            controlledDocument.setEditable(bl);
        }
    }

    @Override
    public void setDocument(Document document) {
        if (!(document instanceof ControlledDocument)) {
            return;
        }
        super.setDocument(document);
    }

    @Override
    public void setText(String string) {
        boolean bl = ((ControlledDocument)this.getDocument()).isEditable();
        ((ControlledDocument)this.getDocument()).setEditable(true);
        super.setText(string);
        ((ControlledDocument)this.getDocument()).setEditable(bl);
    }

    public void setMaximumChars(int n) {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            controlledDocument.setMaximumChars(n);
        }
    }

    public int getMaximumChars() {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            return controlledDocument.getMaximumChars();
        }
        return -1;
    }

    public char[] getUnwantedChars() {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            return controlledDocument.getUnwantedChars();
        }
        return null;
    }

    public void setUnwantedChars(char[] cArray) {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            controlledDocument.setUnwantedChars(cArray);
        }
    }

    public void setUnwantedChars(String string) {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            controlledDocument.setUnwantedChars(string);
        }
    }

    public void setUnwantedChars(char c) {
        ControlledDocument controlledDocument = (ControlledDocument)this.getDocument();
        if (controlledDocument != null) {
            controlledDocument.setUnwantedChars(c);
        }
    }

    public void removeAllRules() {
        this.rules = null;
    }

    public void addRule(TextRule textRule) {
        if (this.rules == null) {
            this.rules = new Vector();
        }
        this.rules.addElement(textRule);
    }

    public void removeRule(TextRule textRule) {
        this.rules.removeElement(textRule);
        if (this.rules.size() == 0) {
            this.rules = null;
        }
    }

    public boolean isValidText() {
        return this.isValidText(this.getText());
    }

    public boolean isValidText(String string) {
        if (this.rules == null) {
            return true;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            TextRule textRule = (TextRule)this.rules.elementAt(i);
            if (textRule.passesRule(string)) continue;
            this.setLastErrorMessage(textRule.getErrorString());
            this.setLastRuleIdentifier(textRule.getRuleIdentifier());
            return false;
        }
        this.setLastErrorMessage("");
        return true;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setLastErrorMessage(String string) {
        this.lastErrorMessage = string;
    }

    public String getLastRuleIdentifier() {
        return this.lastRuleIdentifier;
    }

    public void setLastRuleIdentifier(String string) {
        this.lastRuleIdentifier = string;
    }

    public static class NameRule
    implements TextRule {
        public static final String RULEIDENTIFIER = "NameRule";

        @Override
        public String getRuleIdentifier() {
            return RULEIDENTIFIER;
        }

        @Override
        public boolean passesRule(String string) {
            return string != null && string.trim().length() != 0;
        }

        @Override
        public String getErrorString() {
            return CteStringBank.Please_enter_a_valid_name.getI18n();
        }
    }

    public static class NoSpaceRule
    implements TextRule {
        public static final String RULEIDENTIFIER = "NoSpaceRule";

        @Override
        public String getRuleIdentifier() {
            return RULEIDENTIFIER;
        }

        @Override
        public boolean passesRule(String string) {
            if (string == null) {
                return false;
            }
            return string.trim().length() == string.length();
        }

        @Override
        public String getErrorString() {
            return CteStringBank.No_leading_and_trailing_spaces_allowed_.getI18n();
        }
    }

    public static interface TextRule {
        public boolean passesRule(String var1);

        public String getErrorString();

        public String getRuleIdentifier();
    }
}

