/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.QuickListFilterField;
import commvault.cte.component.SList;
import commvault.cte.component.SortedListModel;
import commvault.cte.component.events.ListClickListener;
import commvault.cte.net.IdNameItem;
import commvault.cte.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;

public class CVFilterDnDList
extends SList
implements KeyListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
ListClickListener {
    private static final long serialVersionUID = 1L;
    protected boolean allowDragging = true;
    protected Vector acceptableObjs = new Vector();
    protected CVFilterDnDList dragSourceList;
    protected CVFilterDnDList dropTargetList;
    private boolean isCurrentlyDragging = false;
    protected EventListenerList dndListenerList = new EventListenerList();
    protected EventListenerList dndActionListenerList;
    protected EventListenerList dndSelectionListenerList;
    QuickListFilterField searchField = new QuickListFilterField();
    private boolean showSearchFieldByDefault;

    public CVFilterDnDList() {
        this.init();
    }

    public CVFilterDnDList(boolean bl) {
        this.showSearchFieldByDefault = bl;
        this.init();
    }

    public CVFilterDnDList(ListModel listModel, boolean bl, QuickListFilterField quickListFilterField) {
        this.searchField = quickListFilterField;
        this.showSearchFieldByDefault = bl;
        this.init(listModel);
    }

    public CVFilterDnDList(ListModel listModel, boolean bl) {
        this.showSearchFieldByDefault = bl;
        this.init(listModel);
    }

    public CVFilterDnDList(ListModel listModel) {
        this.init(listModel);
    }

    public CVFilterDnDList(Object[] objectArray) {
        this.init();
        this.addElements(objectArray);
    }

    public CVFilterDnDList(Vector vector) {
        this.init();
        this.addElements(vector);
    }

    public void setModel(ListModel listModel) {
        if (this.searchField != null && listModel != null) {
            this.searchField.setListModel(listModel);
            super.setModel(this.searchField.getDisplayListModel());
            this.searchField.setList((JList)this);
            int n = (int)this.getPreferredSize().getWidth();
            this.searchField.setPreferredSize(new Dimension(n, 19));
        }
    }

    private void init() {
        this.init(new SortedListModel());
    }

    private void init(ListModel listModel) {
        this.acceptableObjs.addElement("java.lang.String");
        this.acceptableObjs.addElement("commvault.cte.net.IdIdNameItem");
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this, true);
        super.addListClickListener(this);
        this.setModel(listModel);
    }

    public JPanel getCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.addKeyListener(this);
        jPanel.add((Component)this.searchField, "First");
        if (!this.showSearchFieldByDefault) {
            this.searchField.setVisible(false);
        }
        jPanel.add((Component)new JScrollPane(this), "Center");
        return jPanel;
    }

    public void addElements(Object[] objectArray) {
        SortedListModel sortedListModel = (SortedListModel)this.getActualModel();
        sortedListModel.addAll(objectArray);
    }

    public void addElements(Vector vector) {
        SortedListModel sortedListModel = (SortedListModel)this.getActualModel();
        sortedListModel.addAll(vector);
    }

    public void setDragSourceList(CVFilterDnDList cVFilterDnDList) {
        this.dragSourceList = cVFilterDnDList;
    }

    public CVFilterDnDList getDragSourceList() {
        return this.dragSourceList;
    }

    public void setDropTargetList(CVFilterDnDList cVFilterDnDList) {
        this.dropTargetList = cVFilterDnDList;
    }

    public CVFilterDnDList getDropTargetList() {
        return this.dropTargetList;
    }

    public boolean getAllowsDragging() {
        return this.allowDragging;
    }

    public void setAllowsDragging(boolean bl) {
        this.allowDragging = bl;
    }

    public void addAcceptableDropObject(String string) {
        this.acceptableObjs.addElement(string);
    }

    public boolean acceptDropObject(Object object) {
        return this.acceptDropObject(object.getClass().getName());
    }

    public boolean acceptDropObject(String string) {
        return this.acceptableObjs.contains(string);
    }

    public boolean canDrag() {
        return this.getAllowsDragging() && this.fireDnDActionListener();
    }

    public String getSelectionAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].toString());
            if (i == objectArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Transferable getTransferableObj() {
        if (this.getSelectedValues().length == 1 && this.getSelectedValues()[0] instanceof Transferable) {
            try {
                return (Transferable)((Transferable)this.getSelectedValues()[0]).getTransferData(null);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
        StringSelection stringSelection = new StringSelection(this.getSelectionAsString());
        return stringSelection;
    }

    public void removeSelectedValues() {
        Object[] objectArray = this.getSelectedValues();
        if (!(this.getActualModel() instanceof SortedListModel)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((SortedListModel)this.getActualModel()).removeElement(objectArray[i]);
        }
    }

    public Transferable getTransferableObj(int n) throws ArrayIndexOutOfBoundsException {
        Object e = this.getActualModel().getElementAt(n);
        StringSelection stringSelection = new StringSelection(e.toString());
        return stringSelection;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.isCurrentlyDragging = false;
        if (!this.canDrag()) {
            return;
        }
        if ((dragGestureEvent.getDragAction() & 3) == 0) {
            return;
        }
        if (dragGestureEvent.getComponent() != this) {
            return;
        }
        Transferable transferable = this.getTransferableObj();
        this.isCurrentlyDragging = true;
        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
        this.dropTargetList.setDragSourceList(this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if ((dragSourceDragEvent.getDropAction() & 3) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.isCurrentlyDragging = false;
        if (!dragSourceDropEvent.getDropSuccess()) {
            return;
        }
        Object[] objectArray = this.getSelectedValues();
        if (dragSourceDropEvent.getDropAction() == 2) {
            this.removeDroppedValues();
        }
        this.fireDnDPerformed();
        this.firePostDnDSelectionUpdate(objectArray);
    }

    private void removeDroppedValues() {
        Object[] objectArray = this.getSelectedValues();
        if (!(this.getActualModel() instanceof SortedListModel)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((SortedListModel)this.dropTargetList.getActualModel()).contains(objectArray[i])) continue;
            ((SortedListModel)this.getActualModel()).removeElement(objectArray[i]);
        }
    }

    protected void fireDnDPerformed() {
        Object[] objectArray = this.dndListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DnDPerformedListener)) continue;
            ((DnDPerformedListener)object).dndPerformed(this);
        }
    }

    protected void firePostDnDSelectionUpdate(Object[] objectArray) {
        if (this.dndSelectionListenerList == null) {
            return;
        }
        Object[] objectArray2 = this.dndSelectionListenerList.getListenerList();
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof DnDSelectionListener)) continue;
            ((DnDSelectionListener)object).postDnDSelectionUpdate(this, objectArray);
        }
    }

    protected boolean fireDnDActionListener() {
        if (this.dndActionListenerList == null) {
            return true;
        }
        Object[] objectArray = this.dndActionListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DnDActionListener) || ((DnDActionListener)object).canPerformDnD(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentlyDragging() {
        return this.isCurrentlyDragging;
    }

    protected boolean acceptDrop(DropTargetDragEvent dropTargetDragEvent) {
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        CVFilterDnDList cVFilterDnDList = this.getDragSourceList();
        return cVFilterDnDList != null && !dropTargetContext.getComponent().equals(cVFilterDnDList);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.acceptDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Logger.write(Logger.INFO, this, "drop", "Component dropped");
        dropTargetDropEvent.getDropTargetContext();
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            System.err.println("No flavor match found");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.getDropAction();
        int n = dropTargetDropEvent.getSourceActions();
        if ((n & 3) == 0) {
            System.err.println("No action match found");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(3);
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't get transfer data: " + throwable.getMessage());
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (this.acceptDropObject(object)) {
            if (object instanceof String) {
                dropTargetDropEvent.dropComplete(this.processDropObject((String)object));
            } else {
                dropTargetDropEvent.dropComplete(this.processDropObject(object));
            }
        } else {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.dropComplete(true);
    }

    protected boolean processDropObject(Object object) {
        CVFilterDnDList cVFilterDnDList = this.getDragSourceList();
        if (cVFilterDnDList == null) {
            return false;
        }
        if (!cVFilterDnDList.isCurrentlyDragging()) {
            return false;
        }
        ((SortedListModel)this.getActualModel()).addElement(object);
        return true;
    }

    protected boolean processDropObject(String string) {
        if (!(string instanceof String)) {
            return false;
        }
        CVFilterDnDList cVFilterDnDList = this.getDragSourceList();
        if (cVFilterDnDList == null) {
            return false;
        }
        if (!cVFilterDnDList.isCurrentlyDragging()) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Vector<Object> vector = new Vector<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Object object = this.getMatchingObject(string2);
            if (object == null) {
                return false;
            }
            vector.addElement(object);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ((SortedListModel)this.getActualModel()).addElement(vector.elementAt(i));
        }
        return true;
    }

    public ListModel getActualModel() {
        ListModel listModel = super.getModel();
        if (listModel instanceof FilterableListModel) {
            return ((FilterableListModel)listModel).getActualModel();
        }
        return listModel;
    }

    protected Object getMatchingObject(String string) {
        CVFilterDnDList cVFilterDnDList = this.getDragSourceList();
        for (int i = 0; i < cVFilterDnDList.getModel().getSize(); ++i) {
            if (!cVFilterDnDList.getModel().getElementAt(i).toString().equals(string)) continue;
            return cVFilterDnDList.getModel().getElementAt(i);
        }
        return null;
    }

    protected DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        if (!dropTargetDropEvent.isLocalTransfer()) {
            return null;
        }
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    public void performDnD(int n) {
        if (!this.canDrag()) {
            return;
        }
        CVFilterDnDList cVFilterDnDList = this.getDropTargetList();
        CVFilterDnDList cVFilterDnDList2 = cVFilterDnDList.getDragSourceList();
        cVFilterDnDList.setDragSourceList(this);
        String string = this.getSelectionAsString();
        this.isCurrentlyDragging = true;
        Object[] objectArray = null;
        if (cVFilterDnDList.processDropObject(string) && (objectArray = this.getSelectedValues()) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((SortedListModel)this.getActualModel()).removeElement(objectArray[i]);
            }
        }
        this.isCurrentlyDragging = false;
        cVFilterDnDList.setDragSourceList(cVFilterDnDList2);
        this.fireDnDPerformed();
        this.firePostDnDSelectionUpdate(objectArray);
    }

    @Override
    public void mouseClicked(JComponent jComponent, int n, int n2) {
        if (n2 < 0 || n2 > this.getActualModel().getSize()) {
            return;
        }
        if (n != 2) {
            return;
        }
        CVFilterDnDList cVFilterDnDList = this.getDropTargetList();
        if (cVFilterDnDList == null || jComponent != this) {
            return;
        }
        this.performDnD(n2);
    }

    public void addDnDPerformedListener(DnDPerformedListener dnDPerformedListener) {
        this.dndListenerList.add(DnDPerformedListener.class, dnDPerformedListener);
    }

    public void removeDnDPerformedListener(DnDPerformedListener dnDPerformedListener) {
        this.dndListenerList.remove(DnDPerformedListener.class, dnDPerformedListener);
    }

    public void addDnDActionListener(DnDActionListener dnDActionListener) {
        if (this.dndActionListenerList == null) {
            this.dndActionListenerList = new EventListenerList();
        }
        this.dndActionListenerList.add(DnDActionListener.class, dnDActionListener);
    }

    public void removeDnDActionListener(DnDActionListener dnDActionListener) {
        this.dndActionListenerList.remove(DnDActionListener.class, dnDActionListener);
        if (this.dndActionListenerList.getListenerCount() == 0) {
            this.dndActionListenerList = null;
        }
    }

    public void addDnDSelectionListener(DnDSelectionListener dnDSelectionListener) {
        if (this.dndSelectionListenerList == null) {
            this.dndSelectionListenerList = new EventListenerList();
        }
        this.dndSelectionListenerList.add(DnDSelectionListener.class, dnDSelectionListener);
    }

    public void removeDnDSelectionListener(DnDSelectionListener dnDSelectionListener) {
        this.dndSelectionListenerList.remove(DnDSelectionListener.class, dnDSelectionListener);
        if (this.dndSelectionListenerList.getListenerCount() == 0) {
            this.dndSelectionListenerList = null;
        }
    }

    public void disposeOff() {
        this.dragSourceList = null;
        this.dropTargetList = null;
        this.dndListenerList = null;
        this.dndActionListenerList = null;
        this.dndSelectionListenerList = null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if ((keyEvent.getModifiers() & 2) == 2 && keyEvent.getKeyCode() == 70) {
            if (this.searchField.isVisible()) {
                this.searchField.setVisible(false);
                if (!this.searchField.getText().isEmpty()) {
                    this.searchField.setText("");
                }
            } else {
                this.searchField.setVisible(true);
            }
        }
    }

    public QuickListFilterField getSearchField() {
        return this.searchField;
    }

    public static interface DnDSelectionListener
    extends EventListener {
        public void postDnDSelectionUpdate(Object var1, Object[] var2);
    }

    public static interface DnDActionListener
    extends EventListener {
        public boolean canPerformDnD(Object var1);
    }

    public static interface IncludeExcludeListListener {
        public IdNameItem addToIncludeList(Vector var1);

        public IdNameItem addToExcludeList(Vector var1);
    }

    public static interface DnDPerformedListener
    extends EventListener {
        public void dndPerformed(Object var1);
    }
}

