/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jgoodies.binding.value.ValueModel;
import commvault.cte.CteStringBank;
import commvault.cte.component.ComponentComboEditor;
import commvault.cte.component.JComponentComboBox;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.tree.CommNetBrowseBaseNode;
import commvault.cte.component.tree.EntityTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXHyperlink;

public class CVComponentComboBox
extends JComponentComboBox {
    protected ComponentComboEditor popupEditor;
    protected JComponent component;
    String oldValue = "";
    String newValue = "";
    private Dimension poupSize = null;
    private String defaultString = "";

    public String getDefaultString() {
        return this.defaultString;
    }

    public void setDefaultString(String string) {
        this.defaultString = string;
    }

    public CVComponentComboBox(ComponentComboEditor componentComboEditor) {
        this.popupEditor = componentComboEditor;
        try {
            this.setPopupComponent(this.initPopupComponent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setTreeSelection();
    }

    public CVComponentComboBox(ComponentComboEditor componentComboEditor, Dimension dimension) {
        this(componentComboEditor, dimension, "");
    }

    public CVComponentComboBox(ComponentComboEditor componentComboEditor, Dimension dimension, String string) {
        this.setUI(new CVComponentComboBoxUI());
        this.popupEditor = componentComboEditor;
        this.poupSize = dimension;
        this.defaultString = string;
        try {
            this.setPopupComponent(this.initPopupComponent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setTreeSelection();
    }

    public JComponent getEditorComponent() {
        return this.component;
    }

    public ComponentComboEditor getPopupEditor() {
        return this.popupEditor;
    }

    protected JComponent initPopupComponent() {
        this.component = this.popupEditor.getEditor();
        this.component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' && !keyEvent.isControlDown()) {
                    CVComponentComboBox.this.setTreeSelection();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40) {
                    CVComponentComboBox.this.component.grabFocus();
                    CVComponentComboBox.this.showPopup();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.component){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = CVComponentComboBox.this.component.getPreferredSize();
                if (CVComponentComboBox.this.poupSize == null) {
                    if (dimension.getWidth() > (double)CVComponentComboBox.this.getSize().width) {
                        return dimension;
                    }
                    dimension.width = CVComponentComboBox.this.getSize().width;
                    dimension.height += 20;
                    return dimension;
                }
                dimension = CVComponentComboBox.this.poupSize;
                if (dimension.height > 500) {
                    dimension.height = 500;
                }
                if (dimension.getWidth() > (double)CVComponentComboBox.this.getSize().width) {
                    return dimension;
                }
                dimension.width = CVComponentComboBox.this.getSize().width;
                return dimension;
            }
        };
        if (this.component instanceof EntityTree) {
            this.component.addPropertyChangeListener("stateChange", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CVComponentComboBox.this.newValue = CVComponentComboBox.this.computeTreeState();
                    if (!CVComponentComboBox.this.oldValue.equals(CVComponentComboBox.this.newValue)) {
                        String string = CVComponentComboBox.this.oldValue;
                        CVComponentComboBox.this.oldValue = CVComponentComboBox.this.newValue;
                        CVComponentComboBox.this.firePropertyChange("value", string, CVComponentComboBox.this.newValue);
                    }
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(2, 5, 1));
            jPanel.setOpaque(false);
            JXHyperlink jXHyperlink = new JXHyperlink((Action)new CTEAction(CteStringBank.Close.getI18n(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JComponent)CVComponentComboBox.this.getEditor().getEditorComponent()).grabFocus();
                    CVComponentComboBox.this.hidePopup();
                    CVComponentComboBox.this.newValue = CVComponentComboBox.this.computeTreeState();
                    if (!CVComponentComboBox.this.oldValue.equals(CVComponentComboBox.this.newValue)) {
                        String string = CVComponentComboBox.this.oldValue;
                        CVComponentComboBox.this.oldValue = CVComponentComboBox.this.newValue;
                        CVComponentComboBox.this.firePropertyChange("value", string, CVComponentComboBox.this.newValue);
                    }
                }
            }));
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add((Component)jXHyperlink);
            jScrollPane.setColumnHeaderView(jPanel);
        }
        this.component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (!(this.component instanceof EntityTree) && this.popupEditor.isEditable()) {
            this.setEditable(true);
        }
        if (this.component instanceof JTree && !(this.component instanceof EntityTree)) {
            ((JTree)this.component).addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    String string = "";
                    for (int i = 1; i < treePath.getPathCount(); ++i) {
                        string = string + treePath.getPath()[i] + "\\";
                    }
                    if (!CVComponentComboBox.this.popupEditor.isEditable()) {
                        ValueModel valueModel = CVComponentComboBox.this.popupEditor.getSelectionValueModel();
                        if (valueModel != null) {
                            valueModel.setValue((Object)string);
                        }
                        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{string});
                        CVComponentComboBox.this.setModel(defaultComboBoxModel);
                        CVComponentComboBox.this.setSelectedIndex(0);
                    } else {
                        CVComponentComboBox.this.getEditor().setItem(string);
                    }
                    CVComponentComboBox.this.hidePopup();
                }
            });
        }
        return jScrollPane;
    }

    public String computeTreeState() {
        Object object;
        ComboBoxModel comboBoxModel;
        CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)((EntityTree)this.component).getModel().getRoot();
        ArrayList<CommNetBrowseBaseNode> arrayList = new ArrayList<CommNetBrowseBaseNode>();
        this.findSelectedNodes(commNetBrowseBaseNode, arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = "";
        if (commNetBrowseBaseNode.getTriState() == 2) {
            arrayList.clear();
            arrayList.add(commNetBrowseBaseNode);
        }
        for (Object object22 : arrayList) {
            if (stringBuffer.toString().length() + object22.toString().length() > 50) {
                object3 = stringBuffer.toString() + "...";
            }
            if (object22.toString().isEmpty()) continue;
            stringBuffer.append(object22).append(";");
        }
        String string = stringBuffer.toString();
        if (((String)object3).length() == 0) {
            object3 = string;
        }
        if ((comboBoxModel = this.getModel()).getSize() == 0) {
            object = new Vector();
            DataWrapper dataWrapper = new DataWrapper((String)object3);
            ((Vector)object).add(dataWrapper);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(object);
            this.setModel(defaultComboBoxModel);
        } else {
            object = (DataWrapper)comboBoxModel.getElementAt(0);
            ((DataWrapper)object).setData((String)object3);
            comboBoxModel.setSelectedItem(object);
        }
        comboBoxModel.setSelectedItem(string);
        object = this.popupEditor.getSelectionValueModel();
        object.setValue(arrayList);
        return string;
    }

    public void setTreeSelection() {
        this.oldValue = this.computeTreeState();
        ((JComponent)this.getEditor().getEditorComponent()).grabFocus();
        this.hidePopup();
    }

    public void findSelectedNodes(CommNetBrowseBaseNode commNetBrowseBaseNode, List<CommNetBrowseBaseNode> list) {
        if (commNetBrowseBaseNode.isSelected()) {
            list.clear();
            list.add(commNetBrowseBaseNode);
            return;
        }
        for (int i = 0; i < commNetBrowseBaseNode.getChildCount(); ++i) {
            CommNetBrowseBaseNode commNetBrowseBaseNode2 = (CommNetBrowseBaseNode)commNetBrowseBaseNode.getChildAt(i);
            if (commNetBrowseBaseNode2.isSelected()) {
                list.add(commNetBrowseBaseNode2);
                continue;
            }
            this.findSelectedNodes(commNetBrowseBaseNode2, list);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.component == null) {
            try {
                this.setPopupComponent(this.initPopupComponent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (focusEvent.getID() == 1004) {
            SwingUtilities.updateComponentTreeUI(this.component);
        }
        if (focusEvent.getID() == 1005 && focusEvent.getOppositeComponent() != this.component && focusEvent.getSource() != this) {
            this.setTreeSelection();
        }
    }

    @Override
    public void showPopup() {
        this.setPopupVisible(true);
    }

    class CVComponentComboBoxUI
    extends BasicComboBoxUI {
        CVComponentComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){

                @Override
                public boolean isFocusTraversable() {
                    return true;
                }
            };
            return basicComboPopup;
        }
    }

    public static class DataWrapper {
        String data;

        public DataWrapper(String string) {
            this.data = string;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String string) {
            this.data = string;
        }

        public String toString() {
            return this.data;
        }
    }
}

