/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.list.FilterableListModel;
import commvault.cte.CteStringBank;
import commvault.cte.component.CVFilterDnDList;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.MutablePanel;
import commvault.cte.component.SortedListModel;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.WRActionListener;
import commvault.cte.component.events.WRListSelectionListener;
import commvault.cte.util.Logger;
import commvault.msgs.CvEntities.ComponentEntity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CNFilterListSelectionPanel
extends MutablePanel
implements ListSelectionListener,
ActionListener,
CVFilterDnDList.DnDActionListener,
CVFilterDnDList.DnDPerformedListener {
    private static final ImageIcon UPORDER_ICON = Utilities.getIcon("up.gif");
    private static final ImageIcon DOWNORDER_ICON = Utilities.getIcon("down.GIF");
    public static String ADD_COLUMN = "ADD_COLUMN";
    public static String REMOVE_COLUMN = "REMOVE_COLUMN";
    public JButton removeButton;
    public JButton addAllButton;
    public JButton addButton;
    public CVFilterDnDList selectedList;
    public JButton removeAllButton;
    public JPanel buttonPanel;
    public CVFilterDnDList availableList;
    public JLabel availableLabel = new JLabel(CteStringBank.Available7.getI18n());
    public JLabel selectedLabel = new JLabel(CteStringBank.Selected7.getI18n());
    public JPanel leftPanel = new JPanel(new BorderLayout(0, 5));
    public JPanel rightPanel = new JPanel(new BorderLayout(0, 5));
    public boolean showOrderButtons = false;
    private boolean sortAvailableList = true;
    private boolean sortSelectedList = true;
    public JPanel upDownButtonPanel = new JPanel();
    public JButton upButton = new JButton();
    public JButton downButton = new JButton();
    public boolean showIncludeAll = false;
    public JCheckBox includeAllCheckBox = new JCheckBox(CteStringBank.Include_All.getI18n());
    Comparator comparator = null;
    public boolean editable = true;
    JPanel availablePanel = null;
    JPanel selectedPanel = null;
    private boolean isClusterClient = false;
    private boolean showSearchFieldByDefault = false;

    public boolean isClusterClient() {
        return this.isClusterClient;
    }

    public void setClusterClient(boolean bl) {
        this.isClusterClient = bl;
    }

    public CNFilterListSelectionPanel(boolean bl) {
        this(false, bl);
    }

    public CNFilterListSelectionPanel(boolean bl, boolean bl2) {
        this(false, bl, bl2);
    }

    public CNFilterListSelectionPanel(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, null, bl3);
    }

    public CNFilterListSelectionPanel(boolean bl, boolean bl2, WRActionListener wRActionListener, boolean bl3) {
        this.showIncludeAll = bl;
        this.showOrderButtons = bl2;
        this.sortAvailableList = !bl2;
        this.sortSelectedList = !bl2;
        this.showSearchFieldByDefault = bl3;
        this.initComponents(wRActionListener);
    }

    public void setShowOrderButtons(boolean bl) {
        this.showOrderButtons = bl;
        this.sortAvailableList = !bl;
        this.sortSelectedList = !bl;
    }

    public void setSortAvailableList(boolean bl) {
        this.sortAvailableList = bl;
    }

    public void setSortSelectedList(boolean bl) {
        this.sortSelectedList = bl;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    private void initComponents(WRActionListener wRActionListener) {
        if (wRActionListener == null) {
            wRActionListener = new WRActionListener(this);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.availableList = this.createDndList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.selectedList = this.createDndList();
        this.setLayout(new GridBagLayout());
        if (this.showIncludeAll) {
            this.add((Component)this.includeAllCheckBox, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5)));
        }
        this.leftPanel.add((Component)this.availableLabel, "North");
        this.availablePanel = this.availableList.getCenterPanel();
        this.leftPanel.add(this.availablePanel);
        this.add((Component)this.leftPanel, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5)));
        this.buttonPanel.setLayout(new GridLayout(4, 1, 10, 10));
        this.addButton.setText(CteStringBank.Add_25.getI18n());
        this.buttonPanel.add(this.addButton);
        this.removeButton.setText(CteStringBank._24_Remove.getI18n());
        this.buttonPanel.add(this.removeButton);
        this.addAllButton.setText(CteStringBank.Add_All_2525.getI18n());
        this.buttonPanel.add(this.addAllButton);
        this.removeAllButton.setText(CteStringBank._2424_Remove_All.getI18n());
        this.buttonPanel.add(this.removeAllButton);
        this.add((Component)this.buttonPanel, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 1, 1, 0.0, 1.0, 10, 0, new Insets(20, 5, 0, 5)));
        this.rightPanel.add((Component)this.selectedLabel, "North");
        this.selectedPanel = this.selectedList.getCenterPanel();
        this.rightPanel.add(this.selectedPanel);
        this.add((Component)this.rightPanel, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, this.showOrderButtons ? -1 : 0, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 0, 5)));
        if (this.showOrderButtons) {
            this.upDownButtonPanel.setLayout(new GridLayout(2, 1, 10, 10));
            this.upDownButtonPanel.setOpaque(false);
            this.upButton.setHorizontalAlignment(2);
            this.upButton.setIcon(UPORDER_ICON);
            this.upButton.setMargin(new Insets(2, 2, 2, 2));
            this.upDownButtonPanel.add(this.upButton);
            this.downButton.setHorizontalAlignment(2);
            this.downButton.setIcon(DOWNORDER_ICON);
            this.downButton.setMargin(new Insets(2, 2, 2, 2));
            this.upDownButtonPanel.add(this.downButton);
            this.add((Component)this.upDownButtonPanel, LayoutUtils.getConstraints(gridBagConstraints, -1, -1, 0, 1, 0.0, 1.0, 10, 0, new Insets(20, 5, 0, 5)));
        }
        this.setOpaque(false);
        this.buttonPanel.setOpaque(false);
        this.leftPanel.setOpaque(false);
        this.rightPanel.setOpaque(false);
        this.includeAllCheckBox.setOpaque(false);
        this.selectedList.setDropTargetList(this.availableList);
        this.availableList.setDropTargetList(this.selectedList);
        this.selectedList.addDnDPerformedListener(this);
        this.availableList.addDnDPerformedListener(this);
        this.selectedList.addDnDActionListener(this);
        WRListSelectionListener wRListSelectionListener = new WRListSelectionListener(this);
        this.selectedList.addListSelectionListener(wRListSelectionListener);
        this.availableList.addListSelectionListener(wRListSelectionListener);
        this.addButton.addActionListener(wRActionListener);
        this.addAllButton.addActionListener(wRActionListener);
        this.removeButton.addActionListener(wRActionListener);
        this.removeAllButton.addActionListener(wRActionListener);
        if (this.showOrderButtons) {
            this.upButton.addActionListener(wRActionListener);
            this.downButton.addActionListener(wRActionListener);
        }
        if (this.showIncludeAll) {
            this.includeAllCheckBox.addActionListener(wRActionListener);
        }
    }

    protected CVFilterDnDList createDndList() {
        return new CVFilterDnDList(new SortedListModel(false), this.showSearchFieldByDefault);
    }

    public void setDefaultPreferredSize() {
        this.availablePanel.setPreferredSize(new Dimension(1000, 1000));
        this.selectedPanel.setPreferredSize(new Dimension(1000, 1000));
        this.setPreferredSize(new Dimension(200, 100));
    }

    @Override
    public void dndPerformed(Object object) {
        this.sort();
        this.checkList();
    }

    public void checkList() {
        if (this.showIncludeAll && this.includeAllCheckBox.isSelected()) {
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        if (this.selectedList.getActualModel().getSize() == 0 || this.selectedList.getSelectedIndex() < 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        if (this.selectedList.getActualModel().getSize() == 0) {
            this.removeAllButton.setEnabled(false);
        } else {
            this.removeAllButton.setEnabled(true);
        }
        if (this.availableList.getActualModel().getSize() == 0 || this.availableList.getSelectedIndex() < 0) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (this.availableList.getActualModel().getSize() == 0) {
            this.addAllButton.setEnabled(false);
        } else {
            this.addAllButton.setEnabled(true);
        }
        if (this.selectedList.getActualModel().getSize() == 0 || this.selectedList.getSelectedIndex() < 0) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
            if (this.selectedList.getSelectedIndex() == 0) {
                this.upButton.setEnabled(false);
            }
            if (this.selectedList.getSelectedIndices()[this.selectedList.getSelectedIndices().length - 1] == this.selectedList.getActualModel().getSize() - 1) {
                this.downButton.setEnabled(false);
            }
        }
        if (this.availableList.getSearchField() != null && this.availableList.getSearchField().isVisible()) {
            this.addAllButton.setEnabled(this.availableList.getModel().getSize() != 0);
        }
        if (this.selectedList.getSearchField() != null && this.selectedList.getSearchField().isVisible()) {
            this.removeAllButton.setEnabled(this.selectedList.getModel().getSize() != 0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.availableList) {
            if (this.availableList.getSelectedValues().length > 0) {
                this.selectedList.clearSelection();
            }
        } else if (listSelectionEvent.getSource() == this.selectedList && this.selectedList.getSelectedValues().length > 0) {
            this.availableList.clearSelection();
        }
        this.checkList();
    }

    protected void add() {
        int n;
        if (this.availableList.getSelectedValue() == null || this.availableList.getActualModel().getSize() == 0) {
            return;
        }
        Object[] objectArray = this.availableList.getSelectedValues();
        if (objectArray == null) {
            return;
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            ((SortedListModel)this.selectedList.getActualModel()).addElement(objectArray[n]);
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            ((SortedListModel)this.availableList.getActualModel()).removeElement(objectArray[n]);
        }
        this.sort();
        this.showWarningMessageForNonCommonPackageSelection(objectArray);
        this.checkList();
    }

    public void showWarningMessageForNonCommonPackageSelection(Object[] objectArray) {
        if (this.isClusterClient() && objectArray != null) {
            int n = objectArray.length;
            String string = "";
            ComponentEntity componentEntity = null;
            for (int i = 0; i < n; ++i) {
                componentEntity = (ComponentEntity)objectArray[i];
                if (componentEntity.getNoApplicationRequired()) continue;
                string = i == n - 1 ? string + componentEntity.getComponentName() : string + componentEntity.getComponentName() + ",";
            }
            if (string != null && !string.trim().isEmpty()) {
                if (string.trim().endsWith(",")) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string + " " + CteStringBank.Uncommon_Packages_Existence_Warning.getI18n();
                Utilities.showInfoMessage("<html>" + this.getFormattedText(string, 120), CteStringBank.Warning.getI18n());
            }
        }
    }

    public String getFormattedText(String string, int n) {
        string = string.replaceAll("\n", "").trim();
        string = string.replaceAll("/\\s/", "");
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() <= n) {
            stringBuffer.append(string);
        } else {
            int n2 = 0;
            int n3 = string.indexOf(32, n2 + n);
            while (n3 > 0) {
                if (n3 >= string.length()) {
                    stringBuffer.append(string.substring(n2, string.length()));
                    break;
                }
                stringBuffer.append(string.substring(n2, n3) + "\n");
                n2 = n3;
                n3 = string.indexOf(32, n3 + n);
            }
            if (n3 == -1) {
                stringBuffer.append(string.substring(n2));
                string = string.replaceAll("/\\s/", " ");
            }
        }
        if (stringBuffer.toString().trim().length() <= 1) {
            return "";
        }
        return stringBuffer.toString().trim();
    }

    protected void addAll() {
        Object[] objectArray = null;
        if (this.availableList.getSearchField() != null && this.availableList.getSearchField().isVisible()) {
            if (this.availableList.getActualModel().getSize() != 0) {
                objectArray = new Object[this.availableList.getModel().getSize()];
            }
            FilterableListModel filterableListModel = (FilterableListModel)this.availableList.getModel();
            SortedListModel sortedListModel = (SortedListModel)this.availableList.getActualModel();
            SortedListModel sortedListModel2 = (SortedListModel)this.selectedList.getActualModel();
            for (int i = filterableListModel.getSize() - 1; i >= 0; --i) {
                objectArray[i] = filterableListModel.getElementAt(i);
                sortedListModel2.addElement(objectArray[i]);
                sortedListModel.removeElement(objectArray[i]);
            }
        } else {
            if (this.availableList.getActualModel().getSize() != 0) {
                objectArray = new Object[this.availableList.getActualModel().getSize()];
            }
            for (int i = 0; i < this.availableList.getActualModel().getSize(); ++i) {
                ((SortedListModel)this.selectedList.getActualModel()).addElement(((SortedListModel)this.availableList.getActualModel()).get(i));
                objectArray[i] = ((SortedListModel)this.availableList.getActualModel()).get(i);
            }
            ((SortedListModel)this.availableList.getActualModel()).clear();
        }
        this.sort();
        this.showWarningMessageForNonCommonPackageSelection(objectArray);
        this.checkList();
    }

    protected void remove() {
        int n;
        if (this.selectedList.getSelectedValue() == null || this.selectedList.getActualModel().getSize() == 0) {
            return;
        }
        Object[] objectArray = this.selectedList.getSelectedValues();
        if (objectArray == null) {
            return;
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            ((SortedListModel)this.availableList.getActualModel()).addElement(objectArray[n]);
        }
        for (n = objectArray.length - 1; n >= 0; --n) {
            ((SortedListModel)this.selectedList.getActualModel()).removeElement(objectArray[n]);
        }
        this.sort();
        this.checkList();
    }

    protected void removeAllA() {
        if (this.selectedList.getSearchField() != null && this.selectedList.getSearchField().isVisible()) {
            FilterableListModel filterableListModel = (FilterableListModel)this.selectedList.getModel();
            SortedListModel sortedListModel = (SortedListModel)this.selectedList.getActualModel();
            SortedListModel sortedListModel2 = (SortedListModel)this.availableList.getActualModel();
            for (int i = filterableListModel.getSize() - 1; i >= 0; --i) {
                Object object = filterableListModel.getElementAt(i);
                sortedListModel2.addElement(object);
                sortedListModel.removeElement(object);
            }
        } else {
            for (int i = 0; i < this.selectedList.getActualModel().getSize(); ++i) {
                ((SortedListModel)this.availableList.getActualModel()).addElement(((SortedListModel)this.selectedList.getActualModel()).get(i));
            }
            ((SortedListModel)this.selectedList.getActualModel()).clear();
        }
        this.sort();
        this.checkList();
    }

    public void addItem() {
        this.add();
    }

    public void removeItem() {
        this.remove();
    }

    public void addAllItems() {
        this.addAll();
    }

    public void removeAllItems() {
        this.removeAllA();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.remove();
        } else if (actionEvent.getSource() == this.addAllButton) {
            this.addAll();
        } else if (actionEvent.getSource() == this.removeAllButton) {
            this.removeAllA();
        } else if (actionEvent.getSource() == this.upButton) {
            this.moveUp();
        } else if (actionEvent.getSource() == this.downButton) {
            this.moveDown();
        } else if (actionEvent.getSource() == this.includeAllCheckBox) {
            this.includeAll();
        }
    }

    public void moveUp() {
        int[] nArray = this.selectedList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        SortedListModel sortedListModel = (SortedListModel)this.selectedList.getActualModel();
        for (int n : nArray) {
            Object e = sortedListModel.remove(n);
            sortedListModel.insertElementAt(e, n - 1);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        this.selectedList.setSelectedIndices(nArray);
        this.checkList();
    }

    public void moveDown() {
        int[] nArray = this.selectedList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            SortedListModel sortedListModel = (SortedListModel)this.selectedList.getActualModel();
            Object e = sortedListModel.remove(n);
            sortedListModel.insertElementAt(e, n + 1);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        this.selectedList.setSelectedIndices(nArray);
        this.checkList();
    }

    @Override
    public boolean canPerformDnD(Object object) {
        if (!this.isEditable()) {
            return false;
        }
        return this.selectedList.getSelectedValues() != null;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.showIncludeAll) {
            this.includeAllCheckBox.setEnabled(bl);
            this.includeAll();
        } else {
            this.removeButton.setEnabled(bl);
            this.addAllButton.setEnabled(bl);
            this.addButton.setEnabled(bl);
            this.selectedList.setEnabled(bl);
            this.removeAllButton.setEnabled(bl);
            this.buttonPanel.setEnabled(bl);
            this.availableList.setEnabled(bl);
            this.availableLabel.setEnabled(bl);
            this.selectedLabel.setEnabled(bl);
            this.leftPanel.setEnabled(bl);
            this.rightPanel.setEnabled(bl);
            this.upButton.setEnabled(bl);
            this.downButton.setEnabled(bl);
            if (bl) {
                this.checkList();
            }
        }
    }

    public void includeAll() {
        boolean bl = this.includeAllCheckBox.isEnabled() && !this.includeAllCheckBox.isSelected();
        this.removeButton.setEnabled(bl);
        this.addAllButton.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.selectedList.setEnabled(bl);
        this.removeAllButton.setEnabled(bl);
        this.buttonPanel.setEnabled(bl);
        this.availableList.setEnabled(bl);
        this.availableLabel.setEnabled(bl);
        this.selectedLabel.setEnabled(bl);
        this.leftPanel.setEnabled(bl);
        this.rightPanel.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        if (bl) {
            this.checkList();
        }
    }

    public boolean sort() {
        int n;
        if (!this.sortAvailableList && !this.sortSelectedList) {
            return false;
        }
        if (this.availableList.getActualModel().getSize() <= 0 && this.selectedList.getActualModel().getSize() <= 0) {
            return true;
        }
        SortedListModel sortedListModel = null;
        Object[] objectArray = null;
        if (this.comparator == null) {
            if (this.availableList.getActualModel().getSize() > 0) {
                sortedListModel = (SortedListModel)this.availableList.getActualModel();
                objectArray = sortedListModel.toArray();
            } else {
                sortedListModel = (SortedListModel)this.selectedList.getActualModel();
                objectArray = sortedListModel.toArray();
            }
            Class<?> clazz = objectArray[0].getClass();
            Class<?>[] classArray = clazz.getInterfaces();
            boolean bl = false;
            for (n = 0; n < classArray.length; ++n) {
                try {
                    Class<?> clazz2 = Class.forName("java.lang.Comparable");
                    if (!classArray[n].equals(clazz2)) continue;
                    bl = true;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (!bl) {
                Logger.write(Logger.ERROR, this, "sort()", "Objects should implement Comparable interface to support sorting");
                return false;
            }
        }
        if (this.availableList.getActualModel().getSize() > 0 && this.sortAvailableList) {
            sortedListModel = (SortedListModel)this.availableList.getActualModel();
            objectArray = sortedListModel.toArray();
            if (this.comparator == null) {
                Arrays.sort(objectArray);
            } else {
                Arrays.sort(objectArray, this.comparator);
            }
            sortedListModel.clear();
            for (n = 0; n < objectArray.length; ++n) {
                sortedListModel.addElement(objectArray[n]);
            }
        }
        if (this.selectedList.getActualModel().getSize() > 0 && this.sortSelectedList) {
            sortedListModel = (SortedListModel)this.selectedList.getActualModel();
            objectArray = sortedListModel.toArray();
            if (this.comparator == null) {
                Arrays.sort(objectArray);
            } else {
                Arrays.sort(objectArray, this.comparator);
            }
            sortedListModel.clear();
            for (n = 0; n < objectArray.length; ++n) {
                sortedListModel.addElement(objectArray[n]);
            }
        }
        return true;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.isEditable()) {
            this.checkList();
            this.upButton.setEnabled(this.editable);
            this.downButton.setEnabled(this.editable);
            this.includeAllCheckBox.setEnabled(this.editable);
        } else {
            this.addButton.setEnabled(this.editable);
            this.addAllButton.setEnabled(this.editable);
            this.removeButton.setEnabled(this.editable);
            this.removeAllButton.setEnabled(this.editable);
            this.upButton.setEnabled(this.editable);
            this.downButton.setEnabled(this.editable);
            this.includeAllCheckBox.setEnabled(this.editable);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setIncludeAllSelected(boolean bl) {
        this.includeAllCheckBox.setSelected(bl);
        this.includeAll();
    }

    public ArrayList getAvailableList() {
        SortedListModel sortedListModel = (SortedListModel)this.availableList.getActualModel();
        ArrayList arrayList = new ArrayList(sortedListModel.size());
        for (int i = 0; i < sortedListModel.size(); ++i) {
            arrayList.add(sortedListModel.elementAt(i));
        }
        return arrayList;
    }

    public ArrayList getSelectedList() {
        SortedListModel sortedListModel = (SortedListModel)this.selectedList.getActualModel();
        ArrayList arrayList = new ArrayList(sortedListModel.size());
        for (int i = 0; i < sortedListModel.size(); ++i) {
            arrayList.add(sortedListModel.elementAt(i));
        }
        return arrayList;
    }

    public void clear() {
        ((SortedListModel)this.availableList.getActualModel()).clear();
        ((SortedListModel)this.selectedList.getActualModel()).clear();
    }

    public void setAvailableList(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        SortedListModel sortedListModel = (SortedListModel)this.availableList.getActualModel();
        for (int i = 0; i < vector.size(); ++i) {
            sortedListModel.addElement(vector.elementAt(i));
        }
        this.checkList();
    }

    public void setSelectedList(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        SortedListModel sortedListModel = (SortedListModel)this.selectedList.getActualModel();
        for (int i = 0; i < vector.size(); ++i) {
            sortedListModel.addElement(vector.elementAt(i));
        }
        this.checkList();
    }
}

