/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryFieldDef;
import commvault.cte.common.xml.Bitwise;
import commvault.cte.common.xml.CVClass;
import commvault.cte.common.xml.CVEnum;
import commvault.cte.common.xml.CVTime;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.common.xml.EncryptionUtils;
import commvault.cte.common.xml.GenSource;
import commvault.cte.common.xml.Generate;
import commvault.cte.common.xml.MarkAsCDATA;
import commvault.cte.common.xml.Password;
import commvault.cte.common.xml.PasswordEncryptType;
import commvault.cte.common.xml.ReadOnly;
import commvault.cte.common.xml.XDate;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.util.Base64;
import commvault.cte.util.EnumUtil;
import commvault.cte.util.Logger;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class XMLEncoder {
    private static final String MODEL_CLASS_NAME = "com.jgoodies.binding.beans.Model";
    private PasswordEncryptType defaultEncryptionType = PasswordEncryptType.SESSION_ENCRYPTION;
    private int isSaveAsScript = 0;
    private boolean suppressReadOnly = true;

    private XMLEncoder() {
    }

    private XMLEncoder(int n, boolean bl) {
        this.isSaveAsScript = n;
        this.suppressReadOnly = bl;
    }

    private XMLEncoder(PasswordEncryptType passwordEncryptType, int n, boolean bl) {
        this.defaultEncryptionType = passwordEncryptType;
        this.isSaveAsScript = n;
        this.suppressReadOnly = bl;
    }

    public static String encode(Object object) throws Exception {
        return XMLEncoder.encode(object, false);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, false);
    }

    public static String encode(Object object, boolean bl) throws Exception {
        return XMLEncoder.encode(object, bl, false);
    }

    public static String encode(Object object, boolean bl, boolean bl2) throws Exception {
        return XMLEncoder.encode(object, null, bl, bl2);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, false);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, bl2, null);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2, String string) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, bl2, null, null, 0);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2, String string, int n) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, bl2, null, null, n);
    }

    public static void encode(Object object, XMLStreamWriter xMLStreamWriter) throws Exception {
        XMLEncoder.encode(object, xMLStreamWriter, 0);
    }

    public static void encode(Object object, XMLStreamWriter xMLStreamWriter, int n) throws Exception {
        XMLEncoder.encode(object, null, false, false, null, xMLStreamWriter, n);
    }

    public static String encode(Object object, int n) throws Exception {
        return XMLEncoder.encode(object, null, false, false, false, null, null, n);
    }

    public static String encodeAll(Object object) throws Exception {
        return XMLEncoder.encode(object, null, false, false, false, null, null, 0, false);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2, String string, XMLStreamWriter xMLStreamWriter, int n) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, bl2, false, string, xMLStreamWriter, n);
    }

    public static String encodeWithoutXmlHeader(Object object) throws Exception {
        return XMLEncoder.encode(object, null, false, false, true, null, null, 0);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2, boolean bl3, String string, XMLStreamWriter xMLStreamWriter, int n) throws Exception {
        return XMLEncoder.encode(object, passwordEncryptType, bl, bl2, bl3, string, xMLStreamWriter, n, true);
    }

    public static String encode(Object object, PasswordEncryptType passwordEncryptType, boolean bl, boolean bl2, boolean bl3, String string, XMLStreamWriter xMLStreamWriter, int n, boolean bl4) throws Exception {
        if (object == null) {
            return null;
        }
        if (object instanceof List && ((List)object).isEmpty()) {
            return null;
        }
        XMLEncoder xMLEncoder = null;
        xMLEncoder = passwordEncryptType == null ? new XMLEncoder(n, bl4) : new XMLEncoder(passwordEncryptType, n, bl4);
        if (string == null) {
            string = MODEL_CLASS_NAME;
        }
        return xMLEncoder.write(object, bl, bl2, bl3, string, xMLStreamWriter);
    }

    private String write(Object object, boolean bl, boolean bl2, boolean bl3, String string, XMLStreamWriter xMLStreamWriter) throws Exception {
        StringWriter stringWriter = new StringWriter();
        DOMResult dOMResult = null;
        if (xMLStreamWriter == null) {
            if (bl) {
                dOMResult = new DOMResult(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
                xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(dOMResult);
            } else {
                xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
            }
        }
        if (!bl3) {
            xMLStreamWriter.writeStartDocument();
        }
        if (EncoderUtil.isUseOptimizedSerialization() && object instanceof CVClass) {
            xMLStreamWriter.writeStartElement(EncoderUtil.getMessageName(object));
            this.write((CVClass)object, xMLStreamWriter, bl2);
            xMLStreamWriter.writeEndElement();
        } else {
            this.write(EncoderUtil.getMessageName(object), object, xMLStreamWriter, null, bl, bl2, string);
        }
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.flush();
        if (bl) {
            Node node = dOMResult.getNode();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Error ! " + illegalArgumentException.getClass().getName() + ", " + illegalArgumentException.getMessage());
            }
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        }
        return stringWriter.toString();
    }

    private void write(CVClass cVClass, XMLStreamWriter xMLStreamWriter, boolean bl) throws Exception {
        Object object;
        if (cVClass == null) {
            return;
        }
        List<BinaryFieldDef> list = cVClass.getAllFieldDefs();
        if (list == null) {
            return;
        }
        for (BinaryFieldDef binaryFieldDef : list) {
            if (binaryFieldDef == null || !binaryFieldDef.canWrite() || binaryFieldDef.IsList() || !binaryFieldDef.IsPrimitive() && !binaryFieldDef.IsEnum() || (object = cVClass.getFieldValue(binaryFieldDef.getHashId())) == null || binaryFieldDef.IsCDATA() || this.isSaveAsScript == 1 && binaryFieldDef.IsString()) continue;
            xMLStreamWriter.writeAttribute(binaryFieldDef.getName(), this.ValueToString(binaryFieldDef, cVClass, object, bl));
        }
        for (BinaryFieldDef binaryFieldDef : list) {
            if (binaryFieldDef == null || !binaryFieldDef.canWrite() || (object = cVClass.getFieldValue(binaryFieldDef.getHashId())) == null) continue;
            if (binaryFieldDef.IsList()) {
                List list2 = (List)object;
                if (binaryFieldDef.IsPrimitive() || binaryFieldDef.IsEnum()) {
                    for (Object e : list2) {
                        if (binaryFieldDef.IsCDATA() || this.isSaveAsScript == 1 && binaryFieldDef.IsString()) {
                            xMLStreamWriter.writeStartElement(binaryFieldDef.getName());
                            xMLStreamWriter.writeCData(e.toString());
                            xMLStreamWriter.writeEndElement();
                            continue;
                        }
                        xMLStreamWriter.writeStartElement(binaryFieldDef.getName());
                        xMLStreamWriter.writeAttribute("val", this.ValueToString(binaryFieldDef, cVClass, e, bl));
                        xMLStreamWriter.writeEndElement();
                    }
                    continue;
                }
                for (Object e : list2) {
                    xMLStreamWriter.writeStartElement(binaryFieldDef.getName());
                    this.write((CVClass)e, xMLStreamWriter, bl);
                    xMLStreamWriter.writeEndElement();
                }
                continue;
            }
            if (!binaryFieldDef.IsPrimitive() && !binaryFieldDef.IsEnum()) {
                xMLStreamWriter.writeStartElement(binaryFieldDef.getName());
                this.write((CVClass)object, xMLStreamWriter, bl);
                xMLStreamWriter.writeEndElement();
                continue;
            }
            if (!binaryFieldDef.IsCDATA() && (this.isSaveAsScript != 1 || !binaryFieldDef.IsString())) continue;
            xMLStreamWriter.writeStartElement(binaryFieldDef.getName());
            xMLStreamWriter.writeCData(object.toString());
            xMLStreamWriter.writeEndElement();
        }
    }

    public String ValueToString(BinaryFieldDef binaryFieldDef, CVClass cVClass, Object object, boolean bl) throws Exception {
        if (binaryFieldDef.IsBool()) {
            return (Boolean)object != false ? "1" : "0";
        }
        if (binaryFieldDef.IsStringType()) {
            Field field;
            block7: {
                field = null;
                Class<?> clazz = cVClass.getClass();
                try {
                    field = EncryptionUtils.getField(binaryFieldDef.getName(), clazz);
                }
                catch (Exception exception) {
                    if (!Logger.instance().isLogging()) break block7;
                    exception.printStackTrace();
                }
            }
            if (binaryFieldDef.IsBString()) {
                return EncoderUtil.encodeString(EncryptionUtils.encryptString((byte[])object, bl, field, this.defaultEncryptionType));
            }
            if (bl && ((String)object).length() > 0 && (field.getAnnotation(Password.class) != null || field.getAnnotation(Generate.class) != null && field.getAnnotation(Generate.class).source() == GenSource.GUI)) {
                return "XXXXXXXX";
            }
            return EncoderUtil.encodeString((String)object);
        }
        if (binaryFieldDef.IsEnum()) {
            return Integer.toString(((CVEnum)object).getEnumValue());
        }
        return object.toString();
    }

    private void write(String string, Object object, XMLStreamWriter xMLStreamWriter, Field field, boolean bl, boolean bl2, String string2) throws Exception {
        if (object != null) {
            boolean bl3;
            Object object2;
            Object object3;
            if (field != null) {
                ReadOnly object4 = field.getAnnotation(ReadOnly.class);
                if (this.suppressReadOnly && object4 != null) {
                    return;
                }
            }
            if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    this.write(string, t, xMLStreamWriter, field, bl, bl2, string2);
                }
                return;
            }
            if (object instanceof Object[]) {
                for (Object object4 : (Object[])object) {
                    this.write(string, object4, xMLStreamWriter, field, bl, bl2, string2);
                }
                return;
            }
            if (object instanceof long[]) {
                for (long l : (long[])object) {
                    this.write(string, l, xMLStreamWriter, field, bl, bl2, string2);
                }
                return;
            }
            xMLStreamWriter.writeStartElement(string);
            if (EncoderUtil.isPrimitive(object.getClass())) {
                if (object instanceof Boolean) {
                    object = (Boolean)object != false ? 1 : 0;
                } else if (object.getClass().isEnum()) {
                    object = EnumUtil.getEnumValue((Enum)object);
                } else if (object.getClass().equals(XMLDecoder.BYTE_ARRAY)) {
                    object = Base64.encodeToString((byte[])object);
                } else if (object instanceof String) {
                    MarkAsCDATA markAsCDATA = field.getAnnotation(MarkAsCDATA.class);
                    if (markAsCDATA != null) {
                        xMLStreamWriter.writeCData((String)object);
                        xMLStreamWriter.writeEndElement();
                        return;
                    }
                    object = EncoderUtil.encodeString((String)object);
                }
                xMLStreamWriter.writeAttribute("val", object.toString());
                xMLStreamWriter.writeEndElement();
                return;
            }
            this.writeFlagIfUnknown(field, object, xMLStreamWriter);
            boolean bl4 = false;
            Class<?> clazz = object.getClass();
            LinkedHashMap<String, Field> linkedHashMap = new LinkedHashMap<String, Field>();
            this.populateFileds(string2, clazz, linkedHashMap);
            for (Field field2 : linkedHashMap.values()) {
                EncoderUtil.setAccessible(field2);
                object3 = field2.getAnnotation(ReadOnly.class);
                if (object3 != null) continue;
                if (EncoderUtil.isPrimitive(field2) && !Modifier.isStatic(field2.getModifiers())) {
                    Object object5;
                    object2 = this.getValue(field2, object, bl);
                    XDate xDate = field2.getAnnotation(XDate.class);
                    CVTime cVTime = field2.getAnnotation(CVTime.class);
                    if (object2 == null) continue;
                    if (object2.getClass().equals(XMLDecoder.BYTE_ARRAY)) {
                        object2 = EncoderUtil.encodeString(EncryptionUtils.encryptString((byte[])object2, bl2, field2, this.defaultEncryptionType));
                    } else if (object2 instanceof String) {
                        object5 = field2.getAnnotation(MarkAsCDATA.class);
                        if (object5 != null) continue;
                        object2 = bl2 && ((String)object2).length() > 0 && (field2.getAnnotation(Password.class) != null || field2.getAnnotation(Generate.class) != null && field2.getAnnotation(Generate.class).source() == GenSource.GUI) ? "XXXXXXXX" : EncoderUtil.encodeString(object2.toString());
                    } else {
                        if (bl && xDate != null) {
                            long l = ((Number)object2).longValue() * 1000L;
                            xMLStreamWriter.writeAttribute(field2.getName(), DateFormat.getDateInstance().format(new Date(l)));
                            continue;
                        }
                        if (bl && cVTime != null) {
                            int n = ((Number)object2).intValue();
                            xMLStreamWriter.writeAttribute(field2.getName(), "" + n / 3600 + ":" + n % 3600 / 60);
                            continue;
                        }
                    }
                    object5 = object2.toString();
                    xMLStreamWriter.writeAttribute(field2.getName(), (String)object5);
                    continue;
                }
                bl3 = true;
            }
            if (bl3) {
                for (Field field2 : linkedHashMap.values()) {
                    if (!(EncoderUtil.isPrimitive(field2) || field2.isSynthetic() || Modifier.isStatic(field2.getModifiers()) || Modifier.isTransient(field2.getModifiers()))) {
                        object3 = this.getValue(field2, object, bl);
                        this.write(field2.getName(), object3, xMLStreamWriter, field2, bl, bl2, string2);
                        continue;
                    }
                    if (!EncoderUtil.isPrimitive(field2) || Modifier.isStatic(field2.getModifiers()) || !((object3 = this.getValue(field2, object, bl)) instanceof String) || (object2 = field2.getAnnotation(MarkAsCDATA.class)) == null) continue;
                    xMLStreamWriter.writeStartElement(field2.getName());
                    xMLStreamWriter.writeCData(object3.toString());
                    xMLStreamWriter.writeEndElement();
                }
            }
            xMLStreamWriter.writeEndElement();
        }
    }

    private void writeFlagIfUnknown(Field field, Object object, XMLStreamWriter xMLStreamWriter) throws Exception {
        boolean bl;
        boolean bl2 = bl = object != null && field != null && (field.getType().isInterface() || field.getType().getName().equals(Object.class.getName()));
        if (bl) {
            String string = object.getClass().getName();
            boolean bl3 = false;
            if (List.class.isAssignableFrom(field.getType())) {
                bl3 = true;
                Class<?> clazz = EncoderUtil.getTemplateClass(field);
                if (clazz != null && !clazz.isInterface() && !clazz.getName().equals(Object.class.getName())) {
                    return;
                }
            }
            xMLStreamWriter.writeAttribute("_object.", string);
            if (bl3) {
                xMLStreamWriter.writeAttribute("_list.", "");
            }
        }
    }

    private void populateFileds(final String string, final Class<?> clazz, final Map<String, Field> map) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (clazz.getSuperclass() != null && !clazz.getSuperclass().getName().equalsIgnoreCase(string)) {
                    XMLEncoder.this.populateFileds(string, clazz.getSuperclass(), map);
                }
                for (Field field : clazz.getDeclaredFields()) {
                    map.put(field.getName(), field);
                }
                return null;
            }
        });
    }

    private Object getValue(Field field, Object object, boolean bl) throws Exception {
        if (object == null) {
            return null;
        }
        EncoderUtil.setAccessible(field);
        if (field.isAccessible()) {
            Object object2 = field.get(object);
            if (field.getAnnotation(Bitwise.class) != null) {
                return EncoderUtil.getBitwiseValue(object2, bl);
            }
            if (object2 instanceof Boolean && !bl) {
                object2 = (Boolean)object2 != false ? 1 : 0;
            }
            if (object2 != null && object2.getClass().isEnum()) {
                if (bl) {
                    return object2.toString();
                }
                return EnumUtil.getEnumValue((Enum)object2);
            }
            return object2;
        }
        String string = field.getName();
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        return object.getClass().getMethod("get" + string, new Class[0]).invoke(object, new Object[0]);
    }
}

