/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryEncodingSelector;
import commvault.cte.common.xml.BinaryFieldDef;
import commvault.cte.common.xml.BinaryPackageContainer;
import commvault.cte.common.xml.BinaryPackageDef;
import commvault.cte.common.xml.BinaryPrimitiveType;
import commvault.cte.common.xml.Bitwise;
import commvault.cte.common.xml.CVClass;
import commvault.cte.common.xml.DateType;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.common.xml.EncryptionUtils;
import commvault.cte.common.xml.Password;
import commvault.cte.common.xml.PasswordEncryptType;
import commvault.cte.common.xml.XDate;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.util.EnumUtil;
import commvault.cte.util.Logger;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;

public class XMLDecoder {
    public static final String _OBJECT_ = "_object.";
    public static final String LIST = "_list.";
    public static Class<?> BYTE_ARRAY = null;
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static final String BASE_PACKAGE = "commvault.msgs.";
    private PasswordEncryptType defaultEncryptionType = PasswordEncryptType.SESSION_ENCRYPTION;
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private Object object = null;

    public XMLDecoder() {
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    private XMLDecoder(PasswordEncryptType passwordEncryptType) {
        this();
        this.defaultEncryptionType = passwordEncryptType;
    }

    public void setProperty(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.xmlInputFactory.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Object decode(String string) throws Exception {
        return XMLDecoder.decode(string, BASE_PACKAGE);
    }

    public static Object decode(String string, boolean bl) throws Exception {
        return XMLDecoder.decode(PasswordEncryptType.SESSION_ENCRYPTION, string, null, BASE_PACKAGE, bl);
    }

    public static Object decode(String string, Object object) throws Exception {
        return XMLDecoder.decode(string, object, null);
    }

    public static Object decode(String string, String string2) throws Exception {
        return XMLDecoder.decode(string, null, string2);
    }

    public static Object decode(Source source) throws Exception {
        return XMLDecoder.decode(source, null, null);
    }

    public static Object decode(XMLStreamReader xMLStreamReader) throws Exception {
        return XMLDecoder.decode(xMLStreamReader, null, null);
    }

    public static Object decode(XMLStreamReader xMLStreamReader, Object object) throws Exception {
        return XMLDecoder.decode(xMLStreamReader, object, null);
    }

    public static Object decode(XMLDecoder xMLDecoder, Reader reader) throws Exception {
        return xMLDecoder.parseDocument(reader, null, null);
    }

    public static Object decode(InputStream inputStream, Object object) throws Exception {
        return XMLDecoder.decode(inputStream, object, BASE_PACKAGE);
    }

    public static Object decode(Object object, Object object2, String string) throws Exception {
        return XMLDecoder.decode(PasswordEncryptType.SESSION_ENCRYPTION, object, object2, string);
    }

    public static Object decode(PasswordEncryptType passwordEncryptType, Object object, Object object2, String string) throws Exception {
        XMLDecoder xMLDecoder = new XMLDecoder(passwordEncryptType);
        return xMLDecoder.parseDocument(object, object2, string);
    }

    public static Object decode(PasswordEncryptType passwordEncryptType, Object object, Object object2, String string, boolean bl) throws Exception {
        XMLDecoder xMLDecoder = new XMLDecoder(passwordEncryptType);
        return xMLDecoder.parseDocument(object, object2, string);
    }

    public static Object decode(PasswordEncryptType passwordEncryptType, Object object, Object object2, String string, boolean bl, Map<String, Object> map) throws Exception {
        XMLDecoder xMLDecoder = new XMLDecoder(passwordEncryptType);
        xMLDecoder.setProperty(map);
        return xMLDecoder.parseDocument(object, object2, string);
    }

    private Object parseDocument(Object object, Object object2, String string) throws Exception {
        if (object instanceof String) {
            return this.parseDocument(this.xmlInputFactory.createXMLStreamReader(new StringReader((String)object)), object2, string);
        }
        if (object instanceof Source) {
            return this.parseDocument(this.xmlInputFactory.createXMLStreamReader((Source)object), object2, string);
        }
        if (object instanceof Reader) {
            return this.parseDocument(this.xmlInputFactory.createXMLStreamReader((Reader)object), object2, string);
        }
        if (object instanceof InputStream) {
            return this.parseDocument(this.xmlInputFactory.createXMLStreamReader((InputStream)object), object2, string);
        }
        if (object instanceof XMLStreamReader) {
            return this.parseDocument((XMLStreamReader)object, object2, string);
        }
        throw new Exception("Reader Not Supported");
    }

    private Object parseDocument(XMLStreamReader xMLStreamReader, Object object, String string) throws Exception {
        while (xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
            if (!xMLStreamReader.isStartElement()) continue;
            this.object = object;
            if (this.object == null) {
                String string2;
                Class<?> clazz;
                String string3 = BASE_PACKAGE;
                if (string != null) {
                    string3 = string;
                }
                this.object = (clazz = Class.forName(string2 = string3 + xMLStreamReader.getLocalName().replaceFirst("_", "."))).isEnum() ? clazz.getEnumConstants()[0] : clazz.newInstance();
            }
            if (EncoderUtil.isUseOptimizedSerialization() && this.object instanceof CVClass) {
                this.readObjectCVClass((CVClass)this.object, xMLStreamReader);
            } else {
                this.readObject(this.object, xMLStreamReader);
            }
            return this.object;
        }
        return null;
    }

    protected void setObject(Object object) {
        this.object = object;
    }

    private void readObjectCVClass(CVClass cVClass, XMLStreamReader xMLStreamReader) throws Exception {
        QName qName = xMLStreamReader.getName();
        this.processAttributesCVClass(cVClass, xMLStreamReader);
        while (xMLStreamReader.hasNext()) {
            Object object;
            Object object2;
            String string;
            int n;
            BinaryFieldDef binaryFieldDef;
            xMLStreamReader.next();
            if (xMLStreamReader.isEndElement() && qName.equals(xMLStreamReader.getName())) {
                return;
            }
            if (!xMLStreamReader.isStartElement() || (binaryFieldDef = this.getFieldDef(n = EncryptionUtils.getNameToFieldId(string = xMLStreamReader.getLocalName()), cVClass)) == null || !binaryFieldDef.getName().equals(string)) continue;
            int n2 = 0;
            BinaryPackageDef binaryPackageDef = null;
            if (!binaryFieldDef.IsPrimitive() && (binaryPackageDef = BinaryPackageContainer.getPackageDefById(this.getPackageID(n2 = binaryFieldDef.getType()))) == null) continue;
            if (!binaryFieldDef.IsList()) {
                if (binaryFieldDef.IsCDATA() || binaryFieldDef.IsString() && xMLStreamReader.getAttributeCount() == 0) {
                    object2 = xMLStreamReader.getElementText();
                    if (object2 == null) {
                        object2 = "";
                        while (xMLStreamReader.hasNext() && xMLStreamReader.next() == 12) {
                            object2 = (String)object2 + xMLStreamReader.getText();
                        }
                    }
                    cVClass.setFieldValue(n, object2);
                    continue;
                }
                if (binaryFieldDef.IsPrimitive()) {
                    object2 = xMLStreamReader.getAttributeValue(null, "val");
                    if (object2 == null) {
                        object2 = xMLStreamReader.getElementText();
                    }
                    if (binaryFieldDef.IsBString()) {
                        block31: {
                            object = null;
                            Class<?> clazz = cVClass.getClass();
                            try {
                                object = EncryptionUtils.getField(binaryFieldDef.getName(), clazz);
                            }
                            catch (Exception exception) {
                                if (!Logger.instance().isLogging()) break block31;
                                exception.printStackTrace();
                            }
                        }
                        EncryptionUtils.setFieldValue(cVClass, (Field)object, EncryptionUtils.decryptString(EncoderUtil.decodeString((String)object2), (Field)object, this.defaultEncryptionType));
                        continue;
                    }
                    cVClass.setFieldValue(n, this.getPrimitiveValue(cVClass, binaryFieldDef, (String)object2));
                    continue;
                }
                if (binaryFieldDef.IsEnum()) {
                    object2 = xMLStreamReader.getAttributeValue(null, "val");
                    if (object2 == null) {
                        object2 = xMLStreamReader.getElementText();
                    }
                    if (((String)object2).isEmpty()) continue;
                    object = null;
                    try {
                        int n3 = Integer.parseInt((String)object2);
                        object = binaryPackageDef.getEnumByValue(binaryFieldDef.getType(), n3);
                    }
                    catch (Exception exception) {
                        System.err.println("Received enum value : " + (String)object2 + " processing as enum name ");
                        object = binaryPackageDef.getEnumByValue(binaryFieldDef.getType(), (String)object2);
                    }
                    if (object == null) continue;
                    cVClass.setFieldValue(n, object);
                    continue;
                }
                object2 = binaryPackageDef.getInstance(n2);
                this.readObjectCVClass((CVClass)object2, xMLStreamReader);
                cVClass.setFieldValue(n, object2);
                continue;
            }
            object2 = (List)cVClass.getFieldValue(n);
            if (object2 == null) {
                object2 = new ArrayList();
            }
            if (binaryFieldDef.IsEnum()) {
                object = xMLStreamReader.getAttributeValue(null, "val");
                if (object == null) {
                    object = xMLStreamReader.getElementText();
                }
                if (!((String)object).isEmpty()) {
                    Object object3 = null;
                    try {
                        int n4 = Integer.parseInt((String)object);
                        object3 = binaryPackageDef.getEnumByValue(n2, n4);
                    }
                    catch (Exception exception) {
                        System.err.println("Received enum value : " + (String)object + " processing as enum name ");
                        object3 = binaryPackageDef.getEnumByValue(n2, (String)object);
                    }
                    if (object3 != null) {
                        object2.add(object3);
                    }
                }
            } else if (binaryFieldDef.IsCDATA() || binaryFieldDef.IsString() && xMLStreamReader.getAttributeCount() == 0) {
                object = xMLStreamReader.getElementText();
                if (object == null) {
                    object = "";
                    while (xMLStreamReader.hasNext() && xMLStreamReader.next() == 12) {
                        object = (String)object + xMLStreamReader.getText();
                    }
                }
                object2.add(object);
            } else if (binaryFieldDef.IsPrimitive()) {
                object = xMLStreamReader.getAttributeValue(null, "val");
                if (object == null) {
                    object = xMLStreamReader.getElementText();
                }
                if (!((String)object).isEmpty()) {
                    object2.add(this.getPrimitiveValue(cVClass, binaryFieldDef, (String)object));
                }
            } else {
                object = binaryPackageDef.getInstance(n2);
                this.readObjectCVClass((CVClass)object, xMLStreamReader);
                object2.add(object);
            }
            cVClass.setFieldValue(n, object2);
        }
    }

    private void processAttributesCVClass(CVClass cVClass, XMLStreamReader xMLStreamReader) throws Exception {
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string = xMLStreamReader.getAttributeLocalName(i);
            int n2 = EncryptionUtils.getNameToFieldId(string);
            BinaryFieldDef binaryFieldDef = this.getFieldDef(n2, cVClass);
            if (binaryFieldDef == null || !binaryFieldDef.getName().equals(string)) continue;
            if (binaryFieldDef.IsEnum()) {
                object2 = xMLStreamReader.getAttributeValue(i).trim();
                if (((String)object2).isEmpty()) continue;
                object = BinaryPackageContainer.getPackageDefById(this.getPackageID(binaryFieldDef.getType()));
                Object object3 = null;
                try {
                    int n3 = Integer.parseInt((String)object2);
                    object3 = ((BinaryPackageDef)object).getEnumByValue(binaryFieldDef.getType(), n3);
                }
                catch (Exception exception) {
                    System.err.println("Received enum value : [" + (String)object2 + "] processing as enum name ");
                    object3 = ((BinaryPackageDef)object).getEnumByValue(binaryFieldDef.getType(), (String)object2);
                }
                if (object3 == null) continue;
                cVClass.setFieldValue(n2, object3);
                continue;
            }
            if (!binaryFieldDef.IsPrimitive()) continue;
            if (binaryFieldDef.IsBString()) {
                block7: {
                    object2 = null;
                    object = cVClass.getClass();
                    try {
                        object2 = EncryptionUtils.getField(binaryFieldDef.getName(), (Class)object);
                    }
                    catch (Exception exception) {
                        if (!Logger.instance().isLogging()) break block7;
                        exception.printStackTrace();
                    }
                }
                EncryptionUtils.setFieldValue(cVClass, (Field)object2, EncryptionUtils.decryptString(EncoderUtil.decodeString(xMLStreamReader.getAttributeValue(i)), (Field)object2, this.defaultEncryptionType));
                continue;
            }
            cVClass.setFieldValue(n2, this.getPrimitiveValue(cVClass, binaryFieldDef, xMLStreamReader.getAttributeValue(i)));
        }
    }

    private Boolean HasXDateAnnotation(CVClass cVClass, BinaryFieldDef binaryFieldDef, String string) throws Exception {
        BinaryPrimitiveType binaryPrimitiveType = BinaryEncodingSelector.getInstance().getPrimitiveType(binaryFieldDef.getType());
        if ((string.contains("-") && binaryPrimitiveType == BinaryPrimitiveType.int_ || binaryPrimitiveType == BinaryPrimitiveType.long_ || binaryPrimitiveType == BinaryPrimitiveType.longlong_ || binaryPrimitiveType == BinaryPrimitiveType.uint_ || binaryPrimitiveType == BinaryPrimitiveType.ulong_) && EncryptionUtils.getField(binaryFieldDef.getName(), cVClass.getClass()).getAnnotation(XDate.class) != null) {
            return true;
        }
        return false;
    }

    public Object getPrimitiveValue(CVClass cVClass, BinaryFieldDef binaryFieldDef, String string) throws Exception {
        try {
            if (this.HasXDateAnnotation(cVClass, binaryFieldDef, string).booleanValue()) {
                string = this.ProcessXDate(EncryptionUtils.getField(binaryFieldDef.getName(), cVClass.getClass()).getAnnotation(XDate.class), string);
            }
            switch (BinaryEncodingSelector.getInstance().getPrimitiveType(binaryFieldDef.getType())) {
                case boolean_: {
                    return string.equals("true") || string.equals("1");
                }
                case int_: 
                case uint_: {
                    return Integer.parseInt(string);
                }
                case long_: 
                case ulong_: 
                case longlong_: {
                    return Long.parseLong(string);
                }
                case float_: {
                    return Float.valueOf(Float.parseFloat(string));
                }
                case double_: {
                    return Double.parseDouble(string);
                }
                case string_: 
                case wstring_: {
                    return EncoderUtil.decodeString(string);
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private BinaryFieldDef getFieldDef(int n, CVClass cVClass) {
        return cVClass.getBinaryFieldDefByID(n);
    }

    private int getPackageID(int n) {
        return n >> 24;
    }

    private void readObject(Object object, XMLStreamReader xMLStreamReader) throws Exception {
        QName qName = xMLStreamReader.getName();
        this.processAttributes(object, xMLStreamReader);
        while (xMLStreamReader.hasNext()) {
            boolean bl;
            Field field;
            boolean bl2;
            String string;
            block14: {
                xMLStreamReader.next();
                if (xMLStreamReader.isEndElement() && qName.equals(xMLStreamReader.getName())) {
                    return;
                }
                if (!xMLStreamReader.isStartElement()) continue;
                Class<?> clazz = object.getClass();
                string = xMLStreamReader.getAttributeValue(null, _OBJECT_);
                bl2 = xMLStreamReader.getAttributeValue(null, LIST) != null;
                field = null;
                try {
                    field = EncryptionUtils.getField(xMLStreamReader.getLocalName(), clazz);
                }
                catch (Exception exception) {
                    if (!Logger.instance().isLogging()) break block14;
                    exception.printStackTrace();
                }
            }
            if (field == null) continue;
            Class<Object> clazz = field.getType();
            boolean bl3 = bl = string != null && (field.getType().isInterface() || field.getType().getName().equals(Object.class.getName()));
            if (bl && (bl2 || List.class.isAssignableFrom(clazz))) {
                clazz = ArrayList.class;
            } else if (bl) {
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            if (BooleanObject.class.isAssignableFrom(clazz)) {
                this.setValue(object, field, this.createValue(field, EncoderUtil.getTemplateClass(field), xMLStreamReader));
                continue;
            }
            if (List.class.isAssignableFrom(clazz) || bl2) {
                EncoderUtil.setAccessible(field);
                ArrayList<Object> arrayList = (ArrayList<Object>)field.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    field.set(object, arrayList);
                }
                Class<?> clazz2 = string != null ? Class.forName(string) : EncoderUtil.getTemplateClass(field);
                arrayList.add(this.createValue(field, clazz2, xMLStreamReader));
                continue;
            }
            try {
                this.setValue(object, field, this.createValue(field, clazz, xMLStreamReader));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Object createValue(Field field, Class<?> clazz, XMLStreamReader xMLStreamReader) throws Exception {
        if (!EncoderUtil.isPrimitive(clazz)) {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            this.readObject(obj, xMLStreamReader);
            return obj;
        }
        String string = xMLStreamReader.getAttributeValue(null, "val");
        if (string == null) {
            string = xMLStreamReader.getElementText();
        }
        return this.getValue(field, clazz, string);
    }

    private void setValue(Object object, Field field, Object object2) throws IllegalArgumentException, IllegalAccessException {
        if (object instanceof List) {
            ((List)object).add(object2);
            return;
        }
        EncoderUtil.setAccessible(field);
        field.set(object, object2);
    }

    private void processAttributes(Object object, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getAttributeCount();
        Class<?> clazz = object.getClass();
        for (int i = 0; i < n; ++i) {
            String string = xMLStreamReader.getAttributeLocalName(i);
            try {
                if (clazz.isEnum()) {
                    this.object = this.getValue(null, clazz, xMLStreamReader.getAttributeValue(i));
                    continue;
                }
                Field field = EncryptionUtils.getField(string, clazz);
                this.setValue(object, field, xMLStreamReader.getAttributeValue(i));
                if (field.getAnnotation(Password.class) == null || (field = EncryptionUtils.getGenerateField(clazz)) == null) continue;
                this.setValue(object, field, xMLStreamReader.getAttributeValue(i));
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println("Field not found: " + object.getClass().getName() + "." + noSuchFieldException.getMessage());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void setValue(Object object, Field field, String string) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        boolean bl;
        if (object instanceof List) {
            ((List)object).add(string);
            return;
        }
        EncoderUtil.setAccessible(field);
        boolean bl2 = bl = field.getAnnotation(Bitwise.class) != null;
        if (bl) {
            field.set(object, EncoderUtil.getBitwiseObject(field.getType(), Integer.parseInt(string)));
        } else {
            try {
                field.set(object, this.getValue(field, field.getType(), string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Object getValue(Field field, Class clazz, String string) throws Exception {
        if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            string = this.ProcessXDate(field.getAnnotation(XDate.class), string);
            return Integer.parseInt(string);
        }
        if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
            try {
                int n = Integer.parseInt(string);
                return n > 0;
            }
            catch (NumberFormatException numberFormatException) {
                if (string.equalsIgnoreCase("true")) {
                    return true;
                }
                if (string.equalsIgnoreCase("false")) {
                    return false;
                }
                throw numberFormatException;
            }
        }
        if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            string = this.ProcessXDate(field.getAnnotation(XDate.class), string);
            return Long.parseLong(string);
        }
        if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            return Double.parseDouble(string);
        }
        if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (BYTE_ARRAY.equals(clazz)) {
            return EncryptionUtils.decryptString(EncoderUtil.decodeString(string), field, this.defaultEncryptionType);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                int n = Integer.parseInt(string);
                return EnumUtil.getEnum(clazz, n);
            }
            catch (Exception exception) {
                System.err.println("Received enum value : " + string + " processing as enum name ");
                return EnumUtil.getEnumFromString(clazz, string);
            }
        }
        if (String.class.equals((Object)clazz)) {
            return EncoderUtil.decodeString(string);
        }
        return string;
    }

    public String ProcessXDate(XDate xDate, String string) throws Exception {
        String string2;
        block3: {
            string2 = string;
            if (xDate != null) {
                try {
                    LocalDateTime localDateTime = null;
                    localDateTime = xDate.type() == DateType.DATE_TIME ? LocalDateTime.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : LocalDate.parse(string, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay();
                    string2 = Long.toString(localDateTime.atZone(ZoneId.systemDefault()).toEpochSecond());
                }
                catch (Exception exception) {
                    if (!Logger.instance().isLogging()) break block3;
                    String string3 = "Error parsing string [" + string + "] as XDate. Error : [" + exception.getMessage() + "]";
                    System.out.println(string3);
                }
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object = XMLDecoder.decode(EncoderUtil.getFileContent(stringArray[0]), "client.model.generated.");
        System.out.print(XMLEncoder.encode(object));
    }

    static {
        try {
            BYTE_ARRAY = Class.forName("[B");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private class BooleanObject {
        private BooleanObject() {
        }
    }
}

