/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.EncoderUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class SchemaGenerator {
    private static final String ATTRIBUTE = "xs:attribute";
    private static final String SCHEMA = "xs:schema";
    private static final String ELEMENT = "xs:element";
    private static final String EXTENSION = "xs:extension";
    private static final String COMPLEX_CONTENT = "xs:complexContent";
    private static final String SEQUENCE = "xs:sequence";
    private static final String NAME = "name";
    private static final String COMPLEX_TYPE = "xs:complexType";

    public static void main(String[] stringArray) {
        try {
            SchemaGenerator.main1(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void main1(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Please input xx File");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(".");
        PrintStream printStream = System.out;
        if (stringArray.length == 2) {
            file2 = new File(stringArray[1]);
        }
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf("."));
        String string2 = "commvault.msgs." + string;
        String string3 = "commvault\\msgs\\" + string;
        Pattern pattern = Pattern.compile("class\\s+([a-zA-Z0-9]+)(<T>)?");
        Matcher matcher = pattern.matcher(EncoderUtil.getFileContent(stringArray[0]));
        String string4 = EncoderUtil.getTemplateFormat("class.template");
        String string5 = EncoderUtil.getTemplateFormat("fields.template");
        String string6 = EncoderUtil.getTemplateFormat("gettersetter.template");
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", new Boolean(true));
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(new FileWriter(new File(file.getName().replace(".java", ".xsd"))));
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement(SCHEMA);
        xMLStreamWriter.writeDefaultNamespace("http://commvault.com/");
        xMLStreamWriter.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xMLStreamWriter.writeAttribute("targetNamespace", "http://commvault.com/");
        xMLStreamWriter.writeAttribute("elementFormDefault", "qualified");
        xMLStreamWriter.setDefaultNamespace("xs");
        while (matcher.find()) {
            Class clazz;
            String string7 = matcher.group(1);
            File file3 = new File(file2.getAbsoluteFile() + "\\" + string3 + "\\" + string7 + ".java");
            if (!file3.exists() && !file3.createNewFile()) {
                System.out.println("File could not be created" + file3);
            }
            printStream = new PrintStream(file3);
            Class<?> clazz2 = Class.forName(SchemaGenerator.getPackage(file) + string7);
            Object obj = clazz2.newInstance();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            xMLStreamWriter.writeStartElement(COMPLEX_TYPE);
            xMLStreamWriter.writeAttribute(NAME, string7);
            boolean bl = false;
            for (Field field : clazz2.getDeclaredFields()) {
                if (EncoderUtil.isPrimitive(field)) continue;
                if (!bl) {
                    xMLStreamWriter.writeStartElement(SEQUENCE);
                    bl = true;
                }
                if (field.getType().equals(Object.class)) continue;
                xMLStreamWriter.writeStartElement(ELEMENT);
                xMLStreamWriter.writeAttribute(NAME, field.getName());
                if (field.getGenericType() instanceof ParameterizedType) {
                    clazz = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    if (List.class.isAssignableFrom(field.getType())) {
                        xMLStreamWriter.writeAttribute("type", EncoderUtil.getXsdType(clazz));
                        xMLStreamWriter.writeAttribute("maxOccurs", "unbounded");
                    } else {
                        xMLStreamWriter.writeStartElement(COMPLEX_TYPE);
                        xMLStreamWriter.writeStartElement(COMPLEX_CONTENT);
                        xMLStreamWriter.writeStartElement(EXTENSION);
                        xMLStreamWriter.writeAttribute("base", EncoderUtil.getXsdType(field.getType()));
                        xMLStreamWriter.writeStartElement(SEQUENCE);
                        xMLStreamWriter.writeStartElement(ELEMENT);
                        xMLStreamWriter.writeAttribute("type", EncoderUtil.getXsdType(clazz));
                        xMLStreamWriter.writeAttribute(NAME, "value");
                        xMLStreamWriter.writeEndElement();
                        xMLStreamWriter.writeEndElement();
                        xMLStreamWriter.writeEndElement();
                        xMLStreamWriter.writeEndElement();
                        xMLStreamWriter.writeEndElement();
                    }
                } else {
                    xMLStreamWriter.writeAttribute("type", EncoderUtil.getXsdType(field.getType()));
                }
                xMLStreamWriter.writeEndElement();
            }
            if (bl) {
                xMLStreamWriter.writeEndElement();
            }
            for (Field field : clazz2.getDeclaredFields()) {
                boolean bl2;
                clazz = field.getType();
                String string8 = clazz.getSimpleName();
                if (field.getGenericType() instanceof ParameterizedType) {
                    field.getGenericType();
                    string8 = string8 + "<" + clazz.getSimpleName() + ">";
                }
                Object object = field.get(obj);
                String string9 = field.getName();
                if (object != null & (bl2 = EncoderUtil.isPrimitive(clazz))) {
                    xMLStreamWriter.writeStartElement(ATTRIBUTE);
                    xMLStreamWriter.writeAttribute(NAME, string9);
                    xMLStreamWriter.writeAttribute("type", EncoderUtil.getXsdType(clazz));
                    xMLStreamWriter.writeAttribute("default", object.toString());
                    xMLStreamWriter.writeEndElement();
                } else if (object == null) {
                    object = "null";
                }
                String string10 = string9.substring(0, 1).toUpperCase() + string9.substring(1);
                stringBuffer.append(MessageFormat.format(string5, string8, string9, object));
                stringBuffer2.append(MessageFormat.format(string6, string8, string10, string9));
            }
            printStream.print(MessageFormat.format(string4, string2, clazz2.getSimpleName(), stringBuffer.toString(), stringBuffer2.toString()));
            printStream.flush();
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.close();
    }

    private static String getPackage(File file) {
        return "msg.";
    }
}

