/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryEncodingSelector;
import commvault.cte.common.xml.BinaryEncodingType;
import commvault.cte.common.xml.BinaryFieldDef;
import commvault.cte.common.xml.BinaryInputStream;
import commvault.cte.common.xml.BinaryOutputStream;
import commvault.cte.common.xml.BinaryPackageContainer;
import commvault.cte.common.xml.BinaryPackageDef;
import commvault.cte.common.xml.CVClass;
import commvault.cte.common.xml.EncryptionUtils;
import commvault.cte.common.xml.PasswordEncryptType;
import commvault.cte.util.Logger;
import commvault.msgs.App.AppSubSystemReferenceClass;
import commvault.msgs.CM.CMSubSystemReferenceClass;
import commvault.msgs.CNSession.CNSessionSubSystemReferenceClass;
import commvault.msgs.Common.CommonSubSystemReferenceClass;
import commvault.msgs.CvEntities.CvEntitiesSubSystemReferenceClass;
import commvault.msgs.GalaxyUtilities.GalaxyUtilitiesSubSystemReferenceClass;
import commvault.msgs.VirtualServer.VirtualServerSubSystemReferenceClass;
import commvault.msgs.Workflow.WorkflowSubSystemReferenceClass;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinarySerializer {
    public static final int PACKAGE_ID_SHIFT = 24;
    public static final int SIZE_HASH_ID = 0xFEFEFEF;
    public static int count = 0;
    private PasswordEncryptType defaultEncryptionType;
    private int version;

    public BinarySerializer(PasswordEncryptType passwordEncryptType) {
        this.defaultEncryptionType = passwordEncryptType;
    }

    public BinarySerializer() {
        this.defaultEncryptionType = PasswordEncryptType.SESSION_ENCRYPTION;
    }

    private int getPackageID(int n) {
        return n >> 24;
    }

    public byte[] serializeBinary(Object object) throws IOException {
        return this.serializeBinary(object, 2);
    }

    public byte[] serializeBinary(Object object, int n) throws IOException {
        this.version = n;
        int n2 = 0;
        int n3 = 0;
        if (object == null) {
            return null;
        }
        CVClass cVClass = (CVClass)object;
        n3 = cVClass.getTagIdValue() << 24 | cVClass.getIdValue();
        BinaryOutputStream binaryOutputStream = this.serializeBinaryRec(cVClass, BinaryEncodingSelector.getInstance());
        n2 = binaryOutputStream.size() + 8;
        BinaryOutputStream binaryOutputStream2 = new BinaryOutputStream(n2);
        binaryOutputStream2.writeFixed32(n);
        binaryOutputStream2.writeFixed32(n3);
        binaryOutputStream2.copyStream(binaryOutputStream);
        return binaryOutputStream2.toByteArray();
    }

    private BinaryOutputStream serializeBinaryRec(CVClass cVClass, BinaryEncodingSelector binaryEncodingSelector) throws IOException, NullPointerException {
        int n = 0;
        BinaryEncodingType binaryEncodingType = binaryEncodingSelector.getEncodingForKey();
        BinaryEncodingType binaryEncodingType2 = binaryEncodingSelector.getEncodingForSize();
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream();
        List<BinaryFieldDef> list = null;
        if (cVClass != null) {
            list = cVClass.getAllFieldDefs();
        }
        if (list != null) {
            for (BinaryFieldDef binaryFieldDef : list) {
                Object object;
                if (binaryFieldDef == null || !binaryFieldDef.canWrite()) continue;
                int n2 = binaryFieldDef.getHashId();
                Object object2 = cVClass.getFieldValue(n2);
                n = 0;
                if (object2 == null) continue;
                BinaryEncodingType binaryEncodingType3 = binaryEncodingSelector.getEncodingForType(binaryFieldDef.getType());
                if (binaryFieldDef.IsEnum()) {
                    binaryEncodingType3 = BinaryEncodingType.VARINT;
                }
                int n3 = n2 << 3 | binaryEncodingType3.getEnumValue();
                if (binaryFieldDef.IsList()) {
                    object = (List)object2;
                    int n4 = object.size();
                    int n5 = 0x7F7F7F78 | BinaryEncodingType.VARINT.getEnumValue();
                    binaryOutputStream.writeKeyOrSize(binaryEncodingType, n5);
                    binaryOutputStream.writeVarInt32(n4);
                    if (binaryFieldDef.IsPrimitive() || binaryFieldDef.IsEnum()) {
                        if (binaryEncodingType3 == BinaryEncodingType.VARSIZE) {
                            if (!binaryFieldDef.IsStringType()) continue;
                            if (binaryFieldDef.IsBString()) {
                                binaryOutputStream.writeBStringList((List)object, n3);
                                continue;
                            }
                            binaryOutputStream.writeStringList((List)object, n3);
                            continue;
                        }
                        n3 = n2 << 3 | BinaryEncodingType.VARSIZE.getEnumValue();
                        binaryOutputStream.writeKeyOrSize(binaryEncodingType, n3);
                        if (binaryEncodingType3 == BinaryEncodingType.FIXED32) {
                            binaryOutputStream.writeKeyOrSize(binaryEncodingType2, n += n4 * 4);
                            binaryOutputStream.writeFloatList((List)object);
                            continue;
                        }
                        if (binaryEncodingType3 == BinaryEncodingType.FIXED64) {
                            binaryOutputStream.writeKeyOrSize(binaryEncodingType2, n += n4 * 8);
                            if (binaryFieldDef.IsLongLong()) {
                                binaryOutputStream.writeLongList((List)object);
                                continue;
                            }
                            binaryOutputStream.writeDoubleList((List)object);
                            continue;
                        }
                        if (binaryEncodingType3 != BinaryEncodingType.VARINT && binaryEncodingType3 != BinaryEncodingType.SVARINT) continue;
                        if (binaryFieldDef.IsBool()) {
                            binaryOutputStream.writeKeyOrSize(binaryEncodingType2, n4);
                            binaryOutputStream.writeBoolList((List)object);
                            continue;
                        }
                        if (binaryFieldDef.IsEnum()) {
                            binaryOutputStream.writeEnumList((List)object);
                            continue;
                        }
                        if (binaryEncodingType3 == BinaryEncodingType.VARINT) {
                            if (binaryFieldDef.IsInt()) {
                                binaryOutputStream.writeUnsignedIntegerList((List)object);
                                continue;
                            }
                            binaryOutputStream.writeUnsignedLIntegerList((List)object);
                            continue;
                        }
                        if (binaryFieldDef.IsInt()) {
                            binaryOutputStream.writeSignedIntegerList((List)object);
                            continue;
                        }
                        binaryOutputStream.writeSignedLIntegerList((List)object);
                        continue;
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        binaryOutputStream.writeKeyOrSize(binaryEncodingType, n3);
                        BinaryOutputStream binaryOutputStream2 = this.serializeBinaryRec((CVClass)e, binaryEncodingSelector);
                        binaryOutputStream.writeStream(binaryOutputStream2);
                    }
                    continue;
                }
                if (binaryFieldDef.IsPrimitive() || binaryFieldDef.IsEnum()) {
                    binaryOutputStream.writeKeyOrSize(binaryEncodingType, n3);
                    if (binaryEncodingType3 == BinaryEncodingType.FIXED32) {
                        binaryOutputStream.writeFloat(object2);
                        continue;
                    }
                    if (binaryEncodingType3 == BinaryEncodingType.FIXED64) {
                        if (binaryFieldDef.IsLongLong()) {
                            binaryOutputStream.writeLong(object2);
                            continue;
                        }
                        binaryOutputStream.writeDouble(object2);
                        continue;
                    }
                    if (binaryEncodingType3 == BinaryEncodingType.VARINT || binaryEncodingType3 == BinaryEncodingType.SVARINT) {
                        if (binaryFieldDef.IsBool()) {
                            binaryOutputStream.writeBool(object2);
                            continue;
                        }
                        if (binaryFieldDef.IsEnum()) {
                            binaryOutputStream.writeEnum(object2);
                            continue;
                        }
                        if (binaryEncodingType3 == BinaryEncodingType.VARINT) {
                            if (binaryFieldDef.IsInt()) {
                                binaryOutputStream.writeUnsignedInteger(object2);
                                continue;
                            }
                            binaryOutputStream.writeUnsignedLInteger(object2);
                            continue;
                        }
                        if (binaryFieldDef.IsInt()) {
                            binaryOutputStream.writeSignedInteger(object2);
                            continue;
                        }
                        binaryOutputStream.writeSignedLInteger(object2);
                        continue;
                    }
                    if (binaryEncodingType3 != BinaryEncodingType.VARSIZE) continue;
                    if (binaryFieldDef.IsStringType()) {
                        if (binaryFieldDef.IsBString() && this.version > 1) {
                            block33: {
                                object = null;
                                Class<?> clazz = cVClass.getClass();
                                try {
                                    object = EncryptionUtils.getField(binaryFieldDef.getName(), clazz);
                                }
                                catch (Exception exception) {
                                    if (!Logger.instance().isLogging()) break block33;
                                    exception.printStackTrace();
                                }
                            }
                            try {
                                binaryOutputStream.writeString(EncryptionUtils.encryptString((byte[])object2, false, (Field)object, this.defaultEncryptionType));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            continue;
                        }
                        binaryOutputStream.writeString(object2);
                        continue;
                    }
                    binaryOutputStream.writeVarInt32(0);
                    continue;
                }
                if (!(object2 instanceof CVClass)) continue;
                binaryOutputStream.writeKeyOrSize(binaryEncodingType, n3);
                object = this.serializeBinaryRec((CVClass)object2, binaryEncodingSelector);
                binaryOutputStream.writeStream((BinaryOutputStream)object);
            }
        }
        return binaryOutputStream;
    }

    public <T> T unSerializeBinary(byte[] byArray) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        BinaryInputStream binaryInputStream = new BinaryInputStream(byArray);
        this.version = binaryInputStream.readFixed32();
        int n = binaryInputStream.readFixed32();
        T t = null;
        t = this.unSerializeBinaryRec(binaryInputStream, BinaryEncodingSelector.getInstance(), n);
        return t;
    }

    private <T> T unSerializeBinaryRec(BinaryInputStream binaryInputStream, BinaryEncodingSelector binaryEncodingSelector, int n) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        block28: {
            int n2 = 0;
            BinaryEncodingType binaryEncodingType = binaryEncodingSelector.getEncodingForKey();
            BinaryEncodingType binaryEncodingType2 = binaryEncodingSelector.getEncodingForSize();
            BinaryEncodingType binaryEncodingType3 = BinaryEncodingType.UNDEF;
            int n3 = 0;
            int n4 = n >> 24;
            BinaryPackageDef binaryPackageDef = BinaryPackageContainer.getPackageDefById(n4);
            CVClass cVClass = null;
            if (binaryPackageDef != null) {
                cVClass = binaryPackageDef.getInstance(n);
            }
            if (cVClass == null) break block28;
            while (binaryInputStream.available() > 0) {
                BinaryEncodingType binaryEncodingType4;
                block29: {
                    BinaryPackageDef binaryPackageDef2;
                    int n5;
                    BinaryFieldDef binaryFieldDef;
                    int n6;
                    block30: {
                        List<Object> list;
                        block33: {
                            block31: {
                                block34: {
                                    block32: {
                                        int n7 = 0;
                                        int n8 = binaryInputStream.available();
                                        if (n8 < 4) {
                                            binaryInputStream.skip(n8);
                                            break;
                                        }
                                        n7 = binaryInputStream.readKeyOrSize(binaryEncodingType);
                                        if (n7 == 0) break;
                                        n6 = n7 >> 3;
                                        if (n6 == 0xFEFEFEF) {
                                            n3 = binaryInputStream.readVarInt32();
                                            if (n3 <= 0) continue;
                                            n7 = binaryInputStream.readKeyOrSize(binaryEncodingType);
                                            n6 = n7 >> 3;
                                        }
                                        binaryEncodingType4 = binaryEncodingType3.getBinaryEncodingType(n7 & 7);
                                        binaryFieldDef = cVClass.getBinaryFieldDefByID(n6);
                                        if (binaryFieldDef == null) break block29;
                                        binaryEncodingType4 = binaryEncodingSelector.getEncodingForType(binaryFieldDef.getType());
                                        n5 = 0;
                                        binaryPackageDef2 = null;
                                        if (binaryFieldDef.IsEnum()) {
                                            n5 = binaryFieldDef.getType();
                                            binaryPackageDef2 = BinaryPackageContainer.getPackageDefById(this.getPackageID(n5));
                                            binaryEncodingType4 = BinaryEncodingType.VARINT;
                                        }
                                        if (!binaryFieldDef.IsList()) break block30;
                                        list = null;
                                        if (!BinarySerializer.IsKnownDataSize(binaryEncodingType4)) break block31;
                                        n2 = binaryInputStream.readKeyOrSize(binaryEncodingType2);
                                        if (binaryEncodingType4 != BinaryEncodingType.FIXED32) break block32;
                                        list = binaryInputStream.readFloatList(n3);
                                        break block33;
                                    }
                                    if (binaryEncodingType4 != BinaryEncodingType.FIXED64) break block34;
                                    list = binaryFieldDef.IsLongLong() ? binaryInputStream.readLongList(n3) : binaryInputStream.readDoubleList(n3);
                                    break block33;
                                }
                                if (binaryEncodingType4 != BinaryEncodingType.VARINT && binaryEncodingType4 != BinaryEncodingType.SVARINT) break block33;
                                list = binaryFieldDef.IsBool() ? binaryInputStream.readBoolList(n3) : (binaryFieldDef.IsEnum() ? binaryInputStream.readEnumList(n3, n5, binaryPackageDef2) : (binaryEncodingType4 == BinaryEncodingType.VARINT ? binaryInputStream.readUnsignedIntList(n3, binaryFieldDef.IsInt()) : binaryInputStream.readSignedIntList(n3, binaryFieldDef.IsInt())));
                                break block33;
                            }
                            if (binaryFieldDef.IsStringType()) {
                                list = binaryFieldDef.IsBString() ? binaryInputStream.readBStringList(n3) : binaryInputStream.readStringList(n3);
                            } else {
                                list = new ArrayList();
                                for (int i = 0; binaryInputStream.available() > 0 && i < n3; ++i) {
                                    if (i != 0) {
                                        binaryInputStream.readKeyOrSize(binaryEncodingType);
                                    }
                                    int n9 = binaryFieldDef.getType();
                                    T t = this.unSerializeBinaryRec(binaryInputStream.createBinaryInputStream(), binaryEncodingSelector, n9);
                                    list.add(t);
                                }
                            }
                        }
                        cVClass.setFieldValue(n6, list);
                        continue;
                    }
                    if (binaryFieldDef.IsPrimitive() || binaryFieldDef.IsEnum()) {
                        if (binaryEncodingType4 == BinaryEncodingType.FIXED32) {
                            cVClass.setFieldValue(n6, Float.valueOf(binaryInputStream.readFloat()));
                            continue;
                        }
                        if (binaryEncodingType4 == BinaryEncodingType.FIXED64) {
                            if (binaryFieldDef.IsLongLong()) {
                                cVClass.setFieldValue(n6, binaryInputStream.readLong());
                                continue;
                            }
                            cVClass.setFieldValue(n6, binaryInputStream.readDouble());
                            continue;
                        }
                        if (binaryEncodingType4 == BinaryEncodingType.VARINT || binaryEncodingType4 == BinaryEncodingType.SVARINT) {
                            if (binaryFieldDef.IsBool()) {
                                cVClass.setFieldValue(n6, binaryInputStream.readBool());
                                continue;
                            }
                            if (binaryFieldDef.IsEnum()) {
                                cVClass.setFieldValue(n6, binaryInputStream.readEnum(n5, binaryPackageDef2));
                                continue;
                            }
                            int n10 = binaryEncodingType4 == BinaryEncodingType.VARINT ? binaryInputStream.readUnsignedInteger() : binaryInputStream.readSignedInteger();
                            if (binaryFieldDef.IsInt()) {
                                cVClass.setFieldValue(n6, n10);
                                continue;
                            }
                            cVClass.setFieldValue(n6, n10);
                            continue;
                        }
                        if (binaryEncodingType4 != BinaryEncodingType.VARSIZE) continue;
                        if (binaryFieldDef.IsStringType()) {
                            n2 = binaryInputStream.readKeyOrSize(binaryEncodingType2);
                            Field field = null;
                            if (binaryFieldDef.IsBString() && this.version > 1) {
                                String string;
                                block27: {
                                    string = binaryInputStream.readString(n2);
                                    Class<?> clazz = cVClass.getClass();
                                    try {
                                        field = EncryptionUtils.getField(binaryFieldDef.getName(), clazz);
                                    }
                                    catch (Exception exception) {
                                        if (!Logger.instance().isLogging()) break block27;
                                        exception.printStackTrace();
                                    }
                                }
                                try {
                                    EncryptionUtils.setFieldValue(cVClass, field, EncryptionUtils.decryptString(string, field, this.defaultEncryptionType));
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                continue;
                            }
                            cVClass.setFieldValue(n6, binaryInputStream.readString(n2));
                            continue;
                        }
                        Logger.instance().println("Error::Unhandled data");
                        continue;
                    }
                    int n11 = binaryFieldDef.getType();
                    T t = this.unSerializeBinaryRec(binaryInputStream.createBinaryInputStream(), binaryEncodingSelector, n11);
                    cVClass.setFieldValue(n6, t);
                    continue;
                }
                if (binaryEncodingType4 == BinaryEncodingType.FIXED32) {
                    binaryInputStream.skip(4L);
                    continue;
                }
                if (binaryEncodingType4 == BinaryEncodingType.FIXED64) {
                    binaryInputStream.skip(8L);
                    continue;
                }
                if (binaryEncodingType4 == BinaryEncodingType.VARINT) {
                    binaryInputStream.readVarInt32();
                    continue;
                }
                if (binaryEncodingType4 == BinaryEncodingType.SVARINT) {
                    binaryInputStream.readSignedVarInt32();
                    continue;
                }
                n2 = binaryInputStream.readKeyOrSize(binaryEncodingType2);
                binaryInputStream.skip(n2);
            }
            return (T)cVClass;
        }
        return null;
    }

    public static boolean IsKnownDataSize(BinaryEncodingType binaryEncodingType) {
        return binaryEncodingType == BinaryEncodingType.VARINT || binaryEncodingType == BinaryEncodingType.SVARINT || binaryEncodingType == BinaryEncodingType.FIXED32 || binaryEncodingType == BinaryEncodingType.FIXED64;
    }

    static {
        AppSubSystemReferenceClass.registerSubSystem();
        CMSubSystemReferenceClass.registerSubSystem();
        CNSessionSubSystemReferenceClass.registerSubSystem();
        CommonSubSystemReferenceClass.registerSubSystem();
        CvEntitiesSubSystemReferenceClass.registerSubSystem();
        GalaxyUtilitiesSubSystemReferenceClass.registerSubSystem();
        VirtualServerSubSystemReferenceClass.registerSubSystem();
        WorkflowSubSystemReferenceClass.registerSubSystem();
    }
}

