/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.BinaryEncodingType;
import commvault.cte.common.xml.BinaryPackageDef;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class BinaryInputStream
extends ByteArrayInputStream {
    public BinaryInputStream(byte[] byArray) {
        super(byArray);
    }

    public BinaryInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public BinaryInputStream createBinaryInputStream() throws IOException {
        int n = this.readKeyOrSize(BinaryEncodingType.VARINT);
        BinaryInputStream binaryInputStream = new BinaryInputStream(this.buf, this.pos, n);
        this.pos += n;
        return binaryInputStream;
    }

    public int zigZagDecode32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public int readRawByte() throws IOException {
        return this.read();
    }

    public byte[] readRawBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }

    public int readKeyOrSize(BinaryEncodingType binaryEncodingType) throws IOException {
        if (binaryEncodingType == BinaryEncodingType.FIXED32) {
            return this.readFixed32();
        }
        return this.readVarInt32();
    }

    public int readVarInt32() throws IOException {
        int n = this.readRawByte();
        int n2 = n & 0x7F;
        if ((n & 0x80) != 0) {
            n = this.readRawByte();
            n2 |= (n & 0x7F) << 7;
            if ((n & 0x80) != 0) {
                n = this.readRawByte();
                n2 |= (n & 0x7F) << 14;
                if ((n & 0x80) != 0) {
                    n = this.readRawByte();
                    n2 |= (n & 0x7F) << 21;
                    if ((n & 0x80) != 0) {
                        n = this.readRawByte();
                        n2 |= (n & 0x7F) << 28;
                    }
                }
            }
        }
        return n2;
    }

    public int readSignedVarInt32() throws IOException {
        return this.zigZagDecode32(this.readVarInt32());
    }

    public int readFixed32() throws IOException {
        return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
    }

    public long readFixed64() throws IOException {
        return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readFixed64());
    }

    public List readDoubleList(int n) throws IOException {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; this.available() > 0 && i < n; ++i) {
            arrayList.add(this.readDouble());
        }
        return arrayList;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public List readFloatList(int n) throws IOException {
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; this.available() > 0 && i < n; ++i) {
            arrayList.add(Float.valueOf(this.readFloat()));
        }
        return arrayList;
    }

    public long readLong() throws IOException {
        return this.readFixed64();
    }

    public List readLongList(int n) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; this.available() > 0 && i < n; ++i) {
            arrayList.add(this.readLong());
        }
        return arrayList;
    }

    public int readUnsignedInteger() throws IOException {
        return this.readVarInt32();
    }

    public List readUnsignedIntList(int n, boolean bl) throws IOException {
        int n2;
        if (bl) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (n2 = 0; this.available() > 0 && n2 < n; ++n2) {
                arrayList.add(this.readUnsignedInteger());
            }
            return arrayList;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        while (this.available() > 0 && n2 < n) {
            arrayList.add(Long.valueOf(this.readUnsignedInteger()));
            ++n2;
        }
        return arrayList;
    }

    public int readSignedInteger() throws IOException {
        return this.readSignedVarInt32();
    }

    public List readSignedIntList(int n, boolean bl) throws IOException {
        int n2;
        if (bl) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (n2 = 0; this.available() > 0 && n2 < n; ++n2) {
                arrayList.add(this.readSignedInteger());
            }
            return arrayList;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (this.available() > 0 && n2 < n) {
            arrayList.add(Long.valueOf(this.readSignedInteger()));
            ++n2;
        }
        return arrayList;
    }

    public boolean readBool() throws IOException {
        int n = this.readVarInt32();
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        return false;
    }

    public List<Boolean> readBoolList(int n) throws IOException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
        for (int i = 0; this.available() > 0 && i < n; ++i) {
            arrayList.add(this.readBool());
        }
        return arrayList;
    }

    public Object readEnum(int n, BinaryPackageDef binaryPackageDef) throws IOException {
        int n2 = this.readSignedVarInt32();
        return binaryPackageDef.getEnumByValue(n, n2);
    }

    public List readEnumList(int n, int n2, BinaryPackageDef binaryPackageDef) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; this.available() > 0 && i < n; ++i) {
            int n3 = this.readVarInt32();
            arrayList.add(binaryPackageDef.getEnumByValue(n2, n3));
        }
        return arrayList;
    }

    public String readString(int n) throws IOException {
        String string = null;
        try {
            if (n <= this.count - this.pos && n > 0) {
                string = new String(this.buf, this.pos, n, "UTF-8");
                this.pos += n;
            } else {
                string = new String(this.readRawBytes(n), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public List readStringList(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (this.available() > 0 && n != 0) {
            n3 = this.readKeyOrSize(BinaryEncodingType.VARINT);
            arrayList.add(this.readString(n3));
            ++n2;
        }
        while (this.available() > 0 && n2 < n) {
            this.readKeyOrSize(BinaryEncodingType.FIXED32);
            n3 = this.readKeyOrSize(BinaryEncodingType.VARINT);
            arrayList.add(this.readString(n3));
            ++n2;
        }
        return arrayList;
    }

    public List readBStringList(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
        if (this.available() > 0 && n != 0) {
            n3 = this.readKeyOrSize(BinaryEncodingType.VARINT);
            arrayList.add(this.readRawBytes(n3));
            ++n2;
        }
        while (this.available() > 0 && n2 < n) {
            this.readKeyOrSize(BinaryEncodingType.FIXED32);
            n3 = this.readKeyOrSize(BinaryEncodingType.VARINT);
            arrayList.add(this.readRawBytes(n3));
            ++n2;
        }
        return arrayList;
    }
}

