/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.xml.IGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AppGroupDef
implements IGroup {
    private String name;
    private int appGroup;
    private Set<Integer> apptypeIds = new HashSet<Integer>();

    public AppGroupDef(int n, String string, Integer ... integerArray) {
        this.name = string;
        this.appGroup = n;
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray2[i];
            this.apptypeIds.add(n3);
        }
    }

    public AppGroupDef(int n, String string, AppGroupDef ... appGroupDefArray) {
        this.name = string;
        this.appGroup = n;
        for (AppGroupDef appGroupDef : appGroupDefArray) {
            this.apptypeIds.addAll(appGroupDef.getApptypeIds());
        }
    }

    public AppGroupDef(int n, String string, Object ... objectArray) {
        this.name = string;
        this.appGroup = n;
        for (Object object : objectArray) {
            if (object instanceof Integer) {
                this.apptypeIds.add((Integer)object);
                continue;
            }
            if (object instanceof AppGroupDef) {
                this.apptypeIds.addAll(((AppGroupDef)object).getApptypeIds());
                continue;
            }
            if (!(object instanceof Integer[])) continue;
            Integer[] integerArray = (Integer[])object;
            int n2 = integerArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = integerArray[i];
                this.apptypeIds.add(n3);
            }
        }
        for (Object object : objectArray) {
            if (!(object instanceof ExceptGroup)) continue;
            this.apptypeIds.removeAll(((AppGroupDef)object).getApptypeIds());
        }
    }

    public static AppGroupDef EXCEPT(Object ... objectArray) {
        return new ExceptGroup(objectArray);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isIdExists(int n) {
        return this.apptypeIds.contains(n);
    }

    public Set<Integer> getApptypeIds() {
        return this.apptypeIds;
    }

    public int getAppGroup() {
        return this.appGroup;
    }

    @Override
    public boolean isGroupIntersect(IGroup iGroup) {
        AppGroupDef appGroupDef = (AppGroupDef)iGroup;
        return !Collections.disjoint(appGroupDef.getApptypeIds(), this.getApptypeIds());
    }

    @Override
    public boolean isSuperGroup(IGroup iGroup) {
        AppGroupDef appGroupDef = (AppGroupDef)iGroup;
        if (this.getApptypeIds().size() <= appGroupDef.getApptypeIds().size()) {
            return false;
        }
        return this.getApptypeIds().contains(appGroupDef.getApptypeIds());
    }

    static class ExceptGroup
    extends AppGroupDef {
        public ExceptGroup(Object[] objectArray) {
            super(0, "", objectArray);
        }

        @Override
        public boolean isIdExists(int n) {
            return !super.isIdExists(n);
        }
    }
}

