/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.FastStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractDOMStreamReader<T, I>
implements XMLStreamReader {
    protected int currentEvent = 7;
    private Map properties = new HashMap();
    private FastStack<ElementFrame<T, I>> frames = new FastStack();
    private ElementFrame<T, I> frame;

    public AbstractDOMStreamReader(ElementFrame<T, I> elementFrame) {
        this.frame = elementFrame;
        this.frames.push(this.frame);
    }

    protected ElementFrame<T, I> getCurrentFrame() {
        return this.frame;
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        return this.properties.get(string);
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.frame.ended) {
            this.frames.pop();
            if (!this.frames.empty()) {
                this.frame = this.frames.peek();
            } else {
                this.currentEvent = 8;
                return this.currentEvent;
            }
        }
        if (!this.frame.started) {
            this.frame.started = true;
            this.currentEvent = 1;
        } else if (this.frame.currentAttribute < this.getAttributeCount() - 1) {
            ++this.frame.currentAttribute;
            this.currentEvent = 10;
        } else if (this.frame.currentNamespace < this.getNamespaceCount() - 1) {
            ++this.frame.currentNamespace;
            this.currentEvent = 13;
        } else if (this.hasMoreChildren()) {
            this.currentEvent = this.nextChild();
            if (this.currentEvent == 1) {
                ElementFrame<T, I> elementFrame = this.getChildFrame();
                elementFrame.started = true;
                this.frame = elementFrame;
                this.frames.push(this.frame);
                this.currentEvent = 1;
                this.newFrame(elementFrame);
            }
        } else {
            this.frame.ended = true;
            this.currentEvent = 2;
            this.endElement();
        }
        return this.currentEvent;
    }

    protected void newFrame(ElementFrame<T, I> elementFrame) {
    }

    protected void endElement() {
    }

    protected abstract boolean hasMoreChildren();

    protected abstract int nextChild();

    protected abstract ElementFrame<T, I> getChildFrame();

    @Override
    public void require(int n, String string, String string2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract String getElementText() throws XMLStreamException;

    @Override
    public int nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            if (1 != this.next()) continue;
            return 1;
        }
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.frames.size() != 0 || !this.frame.ended;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public abstract String getNamespaceURI(String var1);

    @Override
    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        if (this.currentEvent == 4 || this.currentEvent == 12) {
            String string = this.getText();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }
        return this.currentEvent == 6;
    }

    @Override
    public int getEventType() {
        return this.currentEvent;
    }

    @Override
    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        char[] cArray2 = this.getText().toCharArray();
        if (n + n3 >= cArray2.length) {
            n3 = cArray2.length - n;
        }
        for (int i = 0; i < n3; ++i) {
            cArray[n2 + i] = cArray2[i + n];
        }
        return n3;
    }

    @Override
    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }

            @Override
            public int getLineNumber() {
                return 0;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public boolean hasName() {
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    public static class ElementFrame<T, I> {
        T element;
        I currentChild;
        boolean started;
        boolean ended;
        int currentAttribute = -1;
        int currentNamespace = -1;
        List<String> uris;
        List<String> prefixes;
        List<Object> attributes;
        List<Object> allAttributes;
        final ElementFrame<T, I> parent;

        public ElementFrame(T t, ElementFrame<T, I> elementFrame) {
            this.element = t;
            this.parent = elementFrame;
        }

        public ElementFrame(T t, ElementFrame<T, I> elementFrame, I i) {
            this.element = t;
            this.parent = elementFrame;
            this.currentChild = i;
        }

        public ElementFrame(T t) {
            this.element = t;
            this.parent = null;
            this.started = true;
            this.attributes = Collections.emptyList();
            this.prefixes = Collections.emptyList();
            this.uris = Collections.emptyList();
            this.allAttributes = Collections.emptyList();
        }

        public T getElement() {
            return this.element;
        }

        public I getCurrentChild() {
            return this.currentChild;
        }

        public void setCurrentChild(I i) {
            this.currentChild = i;
        }
    }
}

