/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.wsdl;

import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.PortOperation;
import commvault.cte.common.wsdl.WSDLDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Element;

public class PortType {
    private WSDLDocument wsdlDocument;
    private Element element;
    private QName name;
    private Map<QName, PortOperation> operations = new HashMap<QName, PortOperation>();
    private List<Binding> bindings = new ArrayList<Binding>();

    protected PortType(WSDLDocument wSDLDocument, Element element) {
        this.wsdlDocument = wSDLDocument;
        this.element = element;
        this.name = this.wsdlDocument.retrieveName(element.getAttributeValue("name"));
    }

    public QName getName() {
        return this.name;
    }

    protected void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    protected void parse() {
        for (Element element : this.element.getChildren("operation", this.element.getNamespace())) {
            PortOperation portOperation = new PortOperation(this.wsdlDocument, this, element);
            this.operations.put(portOperation.getName(), portOperation);
            portOperation.parse();
        }
    }

    public PortOperation[] getAllOperations() {
        return this.operations.values().toArray(new PortOperation[0]);
    }

    public PortOperation getOperation(String string) {
        QName qName = new QName(this.name.getNamespaceURI(), string);
        return this.operations.get(qName);
    }

    public PortOperation getOperation(QName qName) {
        return this.operations.get(qName);
    }
}

