/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.wsdl;

import commvault.cte.common.wsdl.BindingOperation;
import commvault.cte.common.wsdl.BindingProtocol;
import commvault.cte.common.wsdl.HTTPBinding;
import commvault.cte.common.wsdl.Port;
import commvault.cte.common.wsdl.PortType;
import commvault.cte.common.wsdl.SOAP12Binding;
import commvault.cte.common.wsdl.SOAPBinding;
import commvault.cte.common.wsdl.WSAWBinding;
import commvault.cte.common.wsdl.WSDLDocument;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class Binding {
    protected WSDLDocument wsdlDocument;
    protected Element element;
    private QName name;
    private PortType portType;
    private Map<QName, Port> ports = new HashMap<QName, Port>();
    protected Map<QName, BindingOperation> operations = new HashMap<QName, BindingOperation>();

    protected static Binding newInstance(WSDLDocument wSDLDocument, Element element) throws Exception {
        if (element.getChild("binding", wSDLDocument.schemaSoapNS) != null) {
            return new SOAPBinding(wSDLDocument, element);
        }
        if (element.getChild("binding", wSDLDocument.schemaSoap12NS) != null) {
            return new SOAP12Binding(wSDLDocument, element);
        }
        if (element.getChild("binding", wSDLDocument.schemaHttpNS) != null) {
            return new HTTPBinding(wSDLDocument, element);
        }
        return new WSAWBinding(wSDLDocument, element);
    }

    protected Binding(WSDLDocument wSDLDocument, Element element) {
        this.wsdlDocument = wSDLDocument;
        this.element = element;
        this.name = this.wsdlDocument.retrieveName(element.getAttributeValue("name"));
        QName qName = this.wsdlDocument.retrieveName(element.getAttributeValue("type"));
        this.portType = this.wsdlDocument.getPortType(qName);
        if (this.portType != null) {
            this.portType.addBinding(this);
        }
    }

    public BindingOperation getBindingOperation(QName qName) {
        return this.operations.get(qName);
    }

    public BindingOperation[] getBindingOperations() {
        return this.operations.values().toArray(new BindingOperation[0]);
    }

    protected void addPort(Port port) {
        this.ports.put(port.getName(), port);
    }

    public Port[] getPorts() {
        return this.ports.values().toArray(new Port[0]);
    }

    public QName getName() {
        return this.name;
    }

    public PortType getPortType() {
        return this.portType;
    }

    protected abstract void parse();

    protected abstract Namespace getNamespace();

    public abstract BindingProtocol getProtocol();
}

