/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.ui;

import commvault.cte.CteStringBank;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.NumericDocument;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HourMinComponent
extends JPanel
implements ActionListener {
    private static final String prefix = "commvault.cte.component.AlertNotifCriteriaPage";
    JNumericTextField daysPeriodField = new JNumericTextField("0", new NumericDocument(0L, Integer.MAX_VALUE));
    JNumericTextField hrPeriodField = new JNumericTextField("1", new NumericDocument(0L, Integer.MAX_VALUE));
    JNumericTextField minPeriodField = new JNumericTextField("0", new NumericDocument(0L, 59L));
    JLabel hrLabel = new JLabel(" " + CteStringBank.hr3s4.getI18n());
    JLabel minLabel = new JLabel(" " + CteStringBank.min3s4.getI18n());
    int minInMinutes = 1;
    private JLabel dayLebel = new JLabel(CteStringBank._Days.getI18n());

    public HourMinComponent(boolean bl, int n) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.daysPeriodField.setColumns(3);
        this.hrPeriodField.setColumns(3);
        this.minPeriodField.setColumns(3);
        this.minPeriodField.setIncrementalValue(n);
        this.add(this.daysPeriodField);
        this.daysPeriodField.setVisible(false);
        this.dayLebel.setVisible(false);
        this.add(this.dayLebel);
        this.add(this.hrPeriodField);
        this.add(this.hrLabel);
        this.add(this.minPeriodField);
        this.add(this.minLabel);
        this.hrPeriodField.setEnabled(bl);
        this.hrLabel.setEnabled(bl);
        this.minPeriodField.setEnabled(bl);
        this.minLabel.setEnabled(bl);
        this.hrPeriodField.addActionListener(this);
        this.hrPeriodField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("intValue")) {
                    int n = (Integer)propertyChangeEvent.getOldValue() * 60 * 60 + HourMinComponent.this.minPeriodField.getInt() * 60;
                    int n2 = (Integer)propertyChangeEvent.getNewValue() * 60 * 60 + HourMinComponent.this.minPeriodField.getInt() * 60;
                    HourMinComponent.this.firePropertyChange("time", n, n2);
                }
            }
        });
        this.minPeriodField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("intValue")) {
                    int n = HourMinComponent.this.hrPeriodField.getInt() * 60 * 60 + (Integer)propertyChangeEvent.getOldValue() * 60;
                    int n2 = HourMinComponent.this.hrPeriodField.getInt() * 60 * 60 + (Integer)propertyChangeEvent.getNewValue() * 60;
                    HourMinComponent.this.firePropertyChange("time", n, n2);
                }
            }
        });
        this.setMinOfMinutes();
    }

    public void showDayField() {
        this.daysPeriodField.setVisible(true);
        this.dayLebel.setVisible(true);
    }

    public void hideMinutesField() {
        this.minPeriodField.setVisible(false);
        this.minLabel.setVisible(false);
    }

    public void setMinInMinutes(int n) {
        this.minInMinutes = n;
    }

    public HourMinComponent(boolean bl) {
        this(bl, 1);
    }

    public HourMinComponent() {
        this(false, 1);
    }

    public HourMinComponent(int n) {
        this(false, 1);
        this.setMinInMinutes(n);
    }

    private void setMinOfMinutes() {
        if (this.hrPeriodField.getInt() == 0 && this.daysPeriodField.getInt() == 0) {
            this.minPeriodField.setMinValue(this.minInMinutes);
            this.minPeriodField.requestFocus();
        } else if (this.hrPeriodField.getInt() > 0) {
            this.minPeriodField.setMinValue(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.hrPeriodField) {
            this.setMinOfMinutes();
        }
    }

    public void setTime(int n) {
        int n2 = n / 60;
        int n3 = n2 / 1440;
        int n4 = (n2 -= n3 * 60 * 24) / 60;
        n2 -= n4 * 60;
        if (!this.daysPeriodField.isVisible()) {
            n4 += n3 * 24;
            n3 = 0;
        }
        this.hrPeriodField.setInt(n4);
        this.minPeriodField.setInt(n2);
        this.daysPeriodField.setInt(n3);
        this.setMinOfMinutes();
    }

    public int getTime() {
        int n = this.daysPeriodField.getInt();
        int n2 = this.minPeriodField.getInt();
        int n3 = this.hrPeriodField.getInt() + n * 24;
        return n2 * 60 + n3 * 60 * 60;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.hrPeriodField.setEnabled(bl);
        this.hrLabel.setEnabled(bl);
        this.minPeriodField.setEnabled(bl);
        this.minLabel.setEnabled(bl);
    }

    @Override
    public void requestFocus() {
        this.hrPeriodField.requestFocus();
    }

    public String getDisplayString() {
        return MessageFormat.format(CteStringBank._10012_days5_10112_hours5_10212_mins.getI18n(), this.daysPeriodField.getInt(), this.hrPeriodField.getInt(), this.minPeriodField.getInt());
    }
}

