/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.util.GDate;
import commvault.cte.common.schema.util.GDateSpecification;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XmlCalendar
extends GregorianCalendar {
    private static int defaultYear = Integer.MIN_VALUE;
    private static final int DEFAULT_DEFAULT_YEAR = 0;
    private static Date _beginningOfTime = new Date(Long.MIN_VALUE);

    public XmlCalendar(String string) {
        this(new GDate(string));
    }

    public XmlCalendar(GDateSpecification gDateSpecification) {
        this(GDate.timeZoneForGDate(gDateSpecification), gDateSpecification);
    }

    private XmlCalendar(TimeZone timeZone, GDateSpecification gDateSpecification) {
        super(timeZone);
        this.setGregorianChange(_beginningOfTime);
        this.clear();
        if (gDateSpecification.hasYear()) {
            int n = gDateSpecification.getYear();
            if (n > 0) {
                this.set(0, 1);
            } else {
                this.set(0, 0);
                n = -n;
            }
            this.set(1, n);
        }
        if (gDateSpecification.hasMonth()) {
            this.set(2, gDateSpecification.getMonth() - 1);
        }
        if (gDateSpecification.hasDay()) {
            this.set(5, gDateSpecification.getDay());
        }
        if (gDateSpecification.hasTime()) {
            this.set(11, gDateSpecification.getHour());
            this.set(12, gDateSpecification.getMinute());
            this.set(13, gDateSpecification.getSecond());
            if (gDateSpecification.getFraction().scale() > 0) {
                this.set(14, gDateSpecification.getMillisecond());
            }
        }
        if (gDateSpecification.hasTimeZone()) {
            this.set(15, gDateSpecification.getTimeZoneSign() * 1000 * 60 * (gDateSpecification.getTimeZoneHour() * 60 + gDateSpecification.getTimeZoneMinute()));
            this.set(16, 0);
        }
    }

    public XmlCalendar(Date date) {
        this(TimeZone.getDefault(), new GDate(date));
        this.complete();
    }

    public XmlCalendar(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal) {
        this(TimeZone.getDefault(), new GDate(n, n2, n3, n4, n5, n6, bigDecimal));
    }

    public XmlCalendar(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7, int n8, int n9) {
        this(new GDate(n, n2, n3, n4, n5, n6, bigDecimal, n7, n8, n9));
    }

    @Override
    public int get(int n) {
        if (!this.isSet(n) || this.isTimeSet) {
            return super.get(n);
        }
        return this.internalGet(n);
    }

    public XmlCalendar() {
        this.setGregorianChange(_beginningOfTime);
        this.clear();
    }

    public static int getDefaultYear() {
        if (defaultYear == Integer.MIN_VALUE) {
            try {
                String string = Integer.toString(Calendar.getInstance().get(1));
                defaultYear = string != null ? Integer.parseInt(string) : 0;
            }
            catch (Throwable throwable) {
                defaultYear = 0;
            }
        }
        return defaultYear;
    }

    public static void setDefaultYear(int n) {
        defaultYear = n;
    }

    @Override
    protected void computeTime() {
        boolean bl;
        boolean bl2 = bl = !this.isSet(1);
        if (bl) {
            this.set(1, XmlCalendar.getDefaultYear());
        }
        try {
            super.computeTime();
        }
        finally {
            if (bl) {
                this.clear(1);
            }
        }
    }

    @Override
    public String toString() {
        return new GDate(this).toString();
    }
}

