/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.ComplexType;
import commvault.cte.common.schema.EncoderUtils;
import commvault.cte.common.schema.SchemaAttribute;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.XmlElement;
import commvault.cte.common.schema.util.SchemaUtils;
import commvault.msgs.App.ControlAlignment;
import commvault.msgs.App.InputControlType;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.InputForm;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import workflow.types.XML;

public class SchemaEncoder {
    public static ActivitySchema encodeActivity(SchemaType schemaType) {
        ActivitySchema activitySchema = new ActivitySchema();
        activitySchema.getInputs().setName("inputs");
        activitySchema.getOutputs().setName("outputs");
        while (schemaType != null) {
            if (schemaType.getProperties() != null) {
                for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                    XMLSchema xMLSchema;
                    if (schemaProperty.getName().getLocalPart().equalsIgnoreCase("inputs")) {
                        xMLSchema = SchemaEncoder.encode(schemaProperty);
                        if (xMLSchema == null) continue;
                        activitySchema.getInputs().getChildren().addAll(xMLSchema.getChildren());
                        continue;
                    }
                    if (!schemaProperty.getName().getLocalPart().equalsIgnoreCase("outputs") || (xMLSchema = SchemaEncoder.encode(schemaProperty)) == null) continue;
                    activitySchema.getOutputs().getChildren().addAll(xMLSchema.getChildren());
                }
            }
            schemaType = schemaType.getBaseType();
        }
        return activitySchema;
    }

    public static XMLSchema encode(String string, SchemaType schemaType) {
        XMLSchema xMLSchema = new XMLSchema();
        xMLSchema.setName(string);
        SchemaEncoder.setSchema(xMLSchema, schemaType);
        SchemaEncoder.createChildren(xMLSchema, schemaType);
        SchemaUtils.clearParent(xMLSchema);
        return xMLSchema;
    }

    public static XMLSchema encode(String string, SchemaProperty schemaProperty) {
        XMLSchema xMLSchema = new XMLSchema();
        xMLSchema.setName(string);
        SchemaEncoder.setSchema(xMLSchema, schemaProperty);
        SchemaEncoder.createChildren(xMLSchema, schemaProperty.getType());
        SchemaUtils.clearParent(xMLSchema);
        return xMLSchema;
    }

    public static XMLSchema encode(SchemaProperty schemaProperty) {
        return SchemaEncoder.encode(schemaProperty.getName().getLocalPart(), schemaProperty);
    }

    public static XMLSchema encode(Element element) {
        return SchemaEncoder.encode(element.getName(), element);
    }

    public static XMLSchema encode(String string, Element element) {
        XMLSchema xMLSchema = new XMLSchema();
        xMLSchema.setName(string);
        String string2 = element.getAttributeValue("class");
        if (string2 != null) {
            xMLSchema.setClassName(string2);
            xMLSchema.setInputType(string2);
            try {
                Class<?> clazz = Class.forName(string2);
                xMLSchema.setType(SchemaUtils.buildType(clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (Element element2 : element.getChildren()) {
            SchemaUtils.addChild(xMLSchema, SchemaEncoder.encode(element2), false);
        }
        return xMLSchema;
    }

    public static void encode(SchemaElement schemaElement, XMLSchema xMLSchema) throws Exception {
        if (xMLSchema.getType().length() > 0) {
            QName qName = QName.valueOf(xMLSchema.getType());
            if (qName.getLocalPart() != null) {
                schemaElement.setType(schemaElement.getSchemaDocument().buildType(qName));
                schemaElement.setRequired(xMLSchema.getRequired());
                schemaElement.setList(xMLSchema.getListType());
                schemaElement.getAnnotation().setDocumentation(xMLSchema.getDocumentation());
                schemaElement.getAnnotation().getAppInfo().setReadOnly(xMLSchema.getReadOnly());
                schemaElement.getAnnotation().getAppInfo().setVisible(!xMLSchema.getHidden());
                schemaElement.getAnnotation().getAppInfo().setDisplayName(xMLSchema.getDisplayName());
                if (xMLSchema.getControlType(false) != null) {
                    schemaElement.getAnnotation().getAppInfo().setControlType(xMLSchema.getControlType().name());
                }
                if (xMLSchema.getOptions().size() > 0) {
                    schemaElement.getAnnotation().getAppInfo().setOptions(xMLSchema.getOptions());
                }
                schemaElement.setDefaultValue(xMLSchema.getDefaultValue());
            }
        } else {
            SchemaEncoder.encode(schemaElement.createComplexType(), xMLSchema);
        }
    }

    public static void encode(ComplexType complexType, XMLSchema xMLSchema) throws Exception {
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            Serializable serializable;
            if (xMLSchema2.getAttribute()) {
                serializable = QName.valueOf(xMLSchema2.getType());
                SchemaAttribute schemaAttribute = complexType.addAttribute(xMLSchema2.getName());
                schemaAttribute.setType((QName)serializable);
                schemaAttribute.setRequired(xMLSchema2.getRequired());
                schemaAttribute.getAnnotation().setDocumentation(xMLSchema2.getDocumentation());
                schemaAttribute.setDefaultValue(xMLSchema2.getDefaultValue());
                continue;
            }
            serializable = complexType.addElement(xMLSchema2.getName());
            SchemaEncoder.encode((SchemaElement)serializable, xMLSchema2);
        }
    }

    private static void setSchema(XMLSchema xMLSchema, SchemaProperty schemaProperty) {
        xMLSchema.setListType(schemaProperty.isList());
        xMLSchema.setRequired(schemaProperty.isRequried());
        xMLSchema.setAttribute(schemaProperty.isAttribute());
        xMLSchema.setDefaultValue(schemaProperty.getDefaultValue());
        if (schemaProperty.getAnnotation() != null) {
            if (schemaProperty.getAnnotation().getAppInfo().getOptions() != null) {
                xMLSchema.getOptions().addAll(Arrays.asList(schemaProperty.getAnnotation().getAppInfo().getOptions()));
            }
            if (schemaProperty.getAnnotation().getDocumentation().length() > 0) {
                xMLSchema.setDocumentation(schemaProperty.getAnnotation().getDocumentation());
            }
            if (schemaProperty.getAnnotation().getAppInfo().getDisplayName().length() > 0) {
                xMLSchema.setDisplayName(schemaProperty.getAnnotation().getAppInfo().getDisplayName());
            }
            if (schemaProperty.getAnnotation().getAppInfo().getControlType().length() > 0) {
                xMLSchema.setControlType(InputControlType.valueOf((String)schemaProperty.getAnnotation().getAppInfo().getControlType()));
            }
            if (schemaProperty.getAnnotation().getAppInfo().getControlAlignment().length() > 0) {
                xMLSchema.setAlignment(ControlAlignment.valueOf((String)schemaProperty.getAnnotation().getAppInfo().getControlAlignment()));
            }
            if (schemaProperty.getAnnotation().getAppInfo().getReadOnly()) {
                xMLSchema.setReadOnly(true);
            }
            if (!schemaProperty.getAnnotation().getAppInfo().isVisible()) {
                xMLSchema.setHidden(true);
            }
            if (schemaProperty.getAnnotation().getAppInfo().getSearchable()) {
                xMLSchema.setSearchable(true);
            }
            if (schemaProperty.getAnnotation().getAppInfo().getControlHidden()) {
                xMLSchema.setControlHidden(true);
            }
        }
        SchemaEncoder.setSchema(xMLSchema, schemaProperty.getType());
    }

    private static void setSchema(XMLSchema xMLSchema, SchemaType schemaType) {
        if (schemaType != null) {
            if (schemaType.getJavaClass() != null) {
                xMLSchema.setClassName(schemaType.getJavaClass().getName());
                xMLSchema.setInputType(schemaType.getJavaClass().getName());
                xMLSchema.setType(SchemaUtils.buildType(schemaType.getJavaClass()));
            } else if (schemaType.getName() != null) {
                xMLSchema.setType(schemaType.getName().toString());
                QName qName = QName.valueOf(schemaType.getName().toString());
                String string = qName.getNamespaceURI() + "." + qName.getLocalPart();
                try {
                    Class.forName(string);
                    xMLSchema.setClassName(string);
                    xMLSchema.setInputType(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (schemaType.getEnumerations() != null) {
                xMLSchema.getOptions().addAll(schemaType.getEnumerations());
            }
        } else {
            xMLSchema.setClassName(Object.class.getName());
            xMLSchema.setType(SchemaUtils.buildType(Object.class));
        }
    }

    private static void createChildren(XMLSchema xMLSchema, SchemaType schemaType) {
        if (schemaType != null) {
            List<SchemaProperty> list = schemaType.getProperties();
            if (list != null && list.size() > 0) {
                for (SchemaProperty schemaProperty : list) {
                    XMLSchema xMLSchema2 = new XMLSchema();
                    xMLSchema2.setName(schemaProperty.getName().getLocalPart());
                    SchemaEncoder.setSchema(xMLSchema2, schemaProperty);
                    if (SchemaUtils.containsParentType(xMLSchema2.getType(), xMLSchema)) {
                        xMLSchema.getRecursiveTypes().add(xMLSchema2);
                        continue;
                    }
                    xMLSchema.getChildren().add(xMLSchema2);
                    xMLSchema2.setParent(xMLSchema);
                    SchemaEncoder.createChildren(xMLSchema2, schemaProperty.getType());
                }
            }
            SchemaEncoder.createChildren(xMLSchema, schemaType.getBaseType());
        }
    }

    public static void updateForm(InputForm inputForm, String string) throws Exception {
        if (string == null || string.length() == 0) {
            return;
        }
        XML xML = XmlElement.load(SchemaEncoder.parseXml(string));
        for (XMLSchema xMLSchema : inputForm.getEntries()) {
            SchemaEncoder.updateEntry(xMLSchema, xML.getChildren(xMLSchema.getName()));
        }
    }

    private static void updateEntry(XMLSchema xMLSchema, List<XML> list) {
        boolean bl = true;
        xMLSchema.setDefaultValue("");
        xMLSchema.getDefaultValues().clear();
        for (XML xML : list) {
            String string = EncoderUtils.getDefaultValue(xML);
            if (string == null || string.length() <= 0) continue;
            if (bl) {
                xMLSchema.setDefaultValue(string);
            }
            bl = false;
            xMLSchema.getDefaultValues().add(string);
        }
        for (XML xML : xMLSchema.getChildren()) {
            for (XML xML2 : list) {
                SchemaEncoder.updateEntry((XMLSchema)xML, xML2.getChildren(xML.getName()));
            }
        }
    }

    public static InputForm encodeForm(XMLSchema xMLSchema) {
        return SchemaEncoder.encodeForm(xMLSchema, (XML)null);
    }

    public static InputForm encodeForm(XMLSchema xMLSchema, Element element) {
        return SchemaEncoder.encodeForm(xMLSchema, XmlElement.load(element));
    }

    public static InputForm encodeForm(XMLSchema xMLSchema, XML xML) {
        InputForm inputForm = new InputForm();
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            if (xML == null) {
                inputForm.getEntries().add(SchemaEncoder.encodeEntry(xMLSchema2, null));
                continue;
            }
            inputForm.getEntries().add(SchemaEncoder.encodeEntry(xMLSchema2, xML.getChildren(xMLSchema2.getName())));
        }
        return inputForm;
    }

    private static XMLSchema encodeEntry(XMLSchema xMLSchema, List<XML> list) {
        XMLSchema xMLSchema2 = new XMLSchema(xMLSchema);
        xMLSchema2.setInputName(xMLSchema.getName());
        xMLSchema2.setDefaultValue(null);
        xMLSchema2.getDefaultValues().clear();
        if (list == null || list.size() == 0) {
            if (xMLSchema.getDefaultValue().length() > 0) {
                xMLSchema2.setDefaultValue(xMLSchema.getDefaultValue());
                xMLSchema2.getDefaultValues().add(xMLSchema.getDefaultValue());
            }
        } else {
            boolean bl = true;
            for (XML object : list) {
                String string = EncoderUtils.getDefaultValue(object);
                if (string == null || string.length() <= 0) continue;
                if (bl) {
                    xMLSchema2.setDefaultValue(string);
                }
                bl = false;
                xMLSchema2.getDefaultValues().add(string);
            }
        }
        xMLSchema2.getChildren().clear();
        if (!EncoderUtils.isTypeFlattend(xMLSchema.getClassName())) {
            for (XMLSchema xMLSchema3 : xMLSchema.getChildren()) {
                if (list == null) {
                    xMLSchema2.getChildren().add(SchemaEncoder.encodeEntry(xMLSchema3, null));
                    continue;
                }
                for (XML xML : list) {
                    xMLSchema2.getChildren().add(SchemaEncoder.encodeEntry(xMLSchema3, xML.getChildren(xMLSchema3.getName())));
                }
            }
        }
        return xMLSchema2;
    }

    public static Element write(XMLSchema xMLSchema) {
        Element element = SchemaEncoder.createSchemaElement(xMLSchema, xMLSchema.getDefaultValue());
        SchemaEncoder.writeChildren(element, xMLSchema);
        return element;
    }

    private static void writeChildren(Element element, XMLSchema xMLSchema) {
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            if (xMLSchema2.getAttribute()) {
                element.setAttribute(xMLSchema2.getName(), xMLSchema2.getDefaultValue());
                continue;
            }
            Element element2 = SchemaEncoder.writeChild(element, xMLSchema2, xMLSchema2.getDefaultValue());
            SchemaEncoder.writeChildren(element2, xMLSchema2);
        }
    }

    public static Element write(XMLSchema xMLSchema, Element element) {
        return SchemaEncoder.write(xMLSchema.getChildren(), xMLSchema.getName(), element);
    }

    public static Element write(List<XMLSchema> list, String string, Element element) {
        Element element2 = new Element(string);
        SchemaEncoder.writeChildren(element2, list, element);
        return element2;
    }

    private static void writeChildren(Element element, List<XMLSchema> list, Element element2) {
        for (XMLSchema xMLSchema : list) {
            if (xMLSchema.getAttribute()) {
                element.setAttribute(xMLSchema.getName(), element2.getAttributeValue(xMLSchema.getName()));
                continue;
            }
            List list2 = element2.getChildren();
            if (list2.size() > 0) {
                for (Element element3 : list2) {
                    Element element4 = SchemaEncoder.writeChild(element, xMLSchema, element3.getText());
                    SchemaEncoder.writeChildren(element4, xMLSchema);
                }
                continue;
            }
            Element element5 = SchemaEncoder.writeChild(element, xMLSchema, xMLSchema.getDefaultValue());
            SchemaEncoder.writeChildren(element5, xMLSchema);
        }
    }

    private static Element writeChild(Element element, XMLSchema xMLSchema, String string) {
        Element element2 = SchemaEncoder.createSchemaElement(xMLSchema, string);
        element.addContent((Content)element2);
        return element2;
    }

    private static Element createSchemaElement(XMLSchema xMLSchema, String string) {
        Element element = xMLSchema.getName().length() > 0 ? new Element(xMLSchema.getName()) : new Element("root");
        if (xMLSchema.getClassName().length() > 0) {
            element.setAttribute("class", xMLSchema.getClassName());
        }
        element.setAttribute("_list_", String.valueOf(xMLSchema.getListType()));
        element.setText(string);
        return element;
    }

    public static Element parseXml(String string) throws Exception {
        if (string != null && string.length() > 0) {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build((Reader)new StringReader(string));
            return document.getRootElement();
        }
        return null;
    }
}

