/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.util.GDate;
import commvault.cte.common.schema.util.GDurationBuilder;
import commvault.cte.common.schema.util.GDurationSpecification;
import java.io.Serializable;
import java.math.BigDecimal;

public final class GDuration
implements GDurationSpecification,
Serializable {
    private static final long serialVersionUID = 1L;
    private int _sign;
    private int _CY;
    private int _M;
    private int _D;
    private int _h;
    private int _m;
    private int _s;
    private BigDecimal _fs;
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_YEAR = 1;
    private static final int SEEN_MONTH = 2;
    private static final int SEEN_DAY = 3;
    private static final int SEEN_HOUR = 4;
    private static final int SEEN_MINUTE = 5;
    private static final int SEEN_SECOND = 6;

    public GDuration() {
        this._sign = 1;
        this._fs = GDate._zero;
    }

    public GDuration(CharSequence charSequence) {
        int n;
        int n2 = 0;
        for (n = charSequence.length(); n > 0 && GDate.isSpace(charSequence.charAt(n - 1)); --n) {
        }
        while (n2 < n && GDate.isSpace(charSequence.charAt(n2))) {
            ++n2;
        }
        this._sign = 1;
        boolean bl = false;
        if (n2 < n && charSequence.charAt(n2) == '-') {
            this._sign = -1;
            ++n2;
        }
        if (n2 >= n || charSequence.charAt(n2) != 'P') {
            throw new IllegalArgumentException("duration must begin with P");
        }
        ++n2;
        int n3 = 0;
        this._fs = GDate._zero;
        while (n2 < n) {
            char c = charSequence.charAt(n2);
            if (c == 'T') {
                if (bl) {
                    throw new IllegalArgumentException("duration must have no more than one T'");
                }
                if (n3 > 3) {
                    throw new IllegalArgumentException("T in duration must precede time fields");
                }
                n3 = 3;
                bl = true;
                if (++n2 >= n) {
                    throw new IllegalArgumentException("illegal duration");
                }
                c = charSequence.charAt(n2);
            }
            if (!GDate.isDigit(c)) {
                throw new IllegalArgumentException("illegal duration at char[" + n2 + "]: '" + c + "'");
            }
            int n4 = GDate.digitVal(c);
            while (true) {
                char c2 = c = ++n2 < n ? charSequence.charAt(n2) : (char)'\u0000';
                if (!GDate.isDigit(c)) break;
                n4 = n4 * 10 + GDate.digitVal(c);
            }
            if (c == '.') {
                int n5 = n2;
                while (++n5 < n && GDate.isDigit(c = charSequence.charAt(n5))) {
                }
                this._fs = new BigDecimal(charSequence.subSequence(n2, n5).toString());
                if (n5 >= n || c != 'S') {
                    throw new IllegalArgumentException("illegal duration");
                }
                n2 = n5;
            }
            switch (n3) {
                case 0: {
                    if (c == 'Y') {
                        n3 = 1;
                        this._CY = n4;
                        break;
                    }
                }
                case 1: {
                    if (c == 'M') {
                        n3 = 2;
                        this._M = n4;
                        break;
                    }
                }
                case 2: {
                    if (c == 'D') {
                        n3 = 3;
                        this._D = n4;
                        break;
                    }
                }
                case 3: {
                    if (c == 'H') {
                        if (!bl) {
                            throw new IllegalArgumentException("time in duration must follow T");
                        }
                        n3 = 4;
                        this._h = n4;
                        break;
                    }
                }
                case 4: {
                    if (c == 'M') {
                        if (!bl) {
                            throw new IllegalArgumentException("time in duration must follow T");
                        }
                        n3 = 5;
                        this._m = n4;
                        break;
                    }
                }
                case 5: {
                    if (c == 'S') {
                        if (!bl) {
                            throw new IllegalArgumentException("time in duration must follow T");
                        }
                        n3 = 6;
                        this._s = n4;
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("duration must specify Y M D T H M S in order");
                }
            }
            ++n2;
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("duration must contain at least one number and its designator: " + charSequence);
        }
    }

    public GDuration(int n, int n2, int n3, int n4, int n5, int n6, int n7, BigDecimal bigDecimal) {
        if (n != 1 && n != -1) {
            throw new IllegalArgumentException();
        }
        this._sign = n;
        this._CY = n2;
        this._M = n3;
        this._D = n4;
        this._h = n5;
        this._m = n6;
        this._s = n7;
        this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
    }

    public GDuration(GDurationSpecification gDurationSpecification) {
        this._sign = gDurationSpecification.getSign();
        this._CY = gDurationSpecification.getYear();
        this._M = gDurationSpecification.getMonth();
        this._D = gDurationSpecification.getDay();
        this._h = gDurationSpecification.getHour();
        this._m = gDurationSpecification.getMinute();
        this._s = gDurationSpecification.getSecond();
        this._fs = gDurationSpecification.getFraction();
    }

    public Object clone() {
        return new GDuration(this);
    }

    @Override
    public final boolean isImmutable() {
        return true;
    }

    @Override
    public final int getSign() {
        return this._sign;
    }

    @Override
    public final int getYear() {
        return this._CY;
    }

    @Override
    public final int getMonth() {
        return this._M;
    }

    @Override
    public final int getDay() {
        return this._D;
    }

    @Override
    public final int getHour() {
        return this._h;
    }

    @Override
    public final int getMinute() {
        return this._m;
    }

    @Override
    public final int getSecond() {
        return this._s;
    }

    @Override
    public BigDecimal getFraction() {
        return this._fs;
    }

    @Override
    public boolean isValid() {
        return GDurationBuilder.isValidDuration(this);
    }

    @Override
    public final int compareToGDuration(GDurationSpecification gDurationSpecification) {
        return GDurationBuilder.compareDurations(this, gDurationSpecification);
    }

    public String toString() {
        return GDurationBuilder.formatDuration(this);
    }

    public GDuration add(GDurationSpecification gDurationSpecification) {
        int n = this._sign * gDurationSpecification.getSign();
        return this._add(gDurationSpecification, n);
    }

    public GDuration subtract(GDurationSpecification gDurationSpecification) {
        int n = -this._sign * gDurationSpecification.getSign();
        return this._add(gDurationSpecification, n);
    }

    private GDuration _add(GDurationSpecification gDurationSpecification, int n) {
        GDuration gDuration = new GDuration(this);
        gDuration._CY += n * gDurationSpecification.getYear();
        gDuration._M += n * gDurationSpecification.getMonth();
        gDuration._D += n * gDurationSpecification.getDay();
        gDuration._h += n * gDurationSpecification.getHour();
        gDuration._m += n * gDurationSpecification.getMinute();
        gDuration._s += n * gDurationSpecification.getSecond();
        if (gDurationSpecification.getFraction().signum() == 0) {
            return gDuration;
        }
        gDuration._fs = gDuration._fs.signum() == 0 && n == 1 ? gDurationSpecification.getFraction() : (n > 0 ? gDuration._fs.add(gDurationSpecification.getFraction()) : gDuration._fs.subtract(gDurationSpecification.getFraction()));
        return gDuration;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GDuration)) {
            return false;
        }
        GDuration gDuration = (GDuration)object;
        return this._sign == gDuration.getSign() && this._CY == gDuration.getYear() && this._M == gDuration.getMonth() && this._D == gDuration.getDay() && this._h == gDuration.getHour() && this._m == gDuration.getMinute() && this._s == gDuration.getSecond() && this._fs.equals(gDuration.getFraction());
    }

    public int hashCode() {
        return this._s + this._m * 67 + this._h * 3607 + this._D * 86407 + this._M * 2678407 + this._CY * 32140807 + this._sign * 11917049;
    }
}

