/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.util.GDate;
import commvault.cte.common.schema.util.GDateSpecification;
import commvault.cte.common.schema.util.GDuration;
import commvault.cte.common.schema.util.GDurationSpecification;
import commvault.cte.common.schema.util.XmlCalendar;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class GDateBuilder
implements GDateSpecification,
Serializable {
    private static final long serialVersionUID = 1L;
    private int _bits;
    private int _CY;
    private int _M;
    private int _D;
    private int _h;
    private int _m;
    private int _s;
    private BigDecimal _fs;
    private int _tzsign;
    private int _tzh;
    private int _tzm;
    static final BigInteger TEN = BigInteger.valueOf(10L);

    public GDateBuilder() {
    }

    public Object clone() {
        return new GDateBuilder(this);
    }

    public GDate toGDate() {
        return new GDate(this);
    }

    public GDateBuilder(GDateSpecification gDateSpecification) {
        if (gDateSpecification.hasTimeZone()) {
            this.setTimeZone(gDateSpecification.getTimeZoneSign(), gDateSpecification.getTimeZoneHour(), gDateSpecification.getTimeZoneMinute());
        }
        if (gDateSpecification.hasTime()) {
            this.setTime(gDateSpecification.getHour(), gDateSpecification.getMinute(), gDateSpecification.getSecond(), gDateSpecification.getFraction());
        }
        if (gDateSpecification.hasDay()) {
            this.setDay(gDateSpecification.getDay());
        }
        if (gDateSpecification.hasMonth()) {
            this.setMonth(gDateSpecification.getMonth());
        }
        if (gDateSpecification.hasYear()) {
            this.setYear(gDateSpecification.getYear());
        }
    }

    public GDateBuilder(CharSequence charSequence) {
        this(new GDate(charSequence));
    }

    public GDateBuilder(Calendar calendar) {
        this(new GDate(calendar));
    }

    public GDateBuilder(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal) {
        this._bits = 30;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        this._CY = n > 0 ? n : n + 1;
        this._M = n2;
        this._D = n3;
        this._h = n4;
        this._m = n5;
        this._s = n6;
        BigDecimal bigDecimal2 = this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    public GDateBuilder(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7, int n8, int n9) {
        this._bits = 31;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        this._CY = n > 0 ? n : n + 1;
        this._M = n2;
        this._D = n3;
        this._h = n4;
        this._m = n5;
        this._s = n6;
        this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
        this._tzsign = n7;
        this._tzh = n8;
        this._tzm = n9;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    public GDateBuilder(Date date) {
        this.setDate(date);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public int getFlags() {
        return this._bits;
    }

    @Override
    public final boolean hasTimeZone() {
        return (this._bits & 1) != 0;
    }

    @Override
    public final boolean hasYear() {
        return (this._bits & 2) != 0;
    }

    @Override
    public final boolean hasMonth() {
        return (this._bits & 4) != 0;
    }

    @Override
    public final boolean hasDay() {
        return (this._bits & 8) != 0;
    }

    @Override
    public final boolean hasTime() {
        return (this._bits & 0x10) != 0;
    }

    @Override
    public final boolean hasDate() {
        return (this._bits & 0xE) == 14;
    }

    @Override
    public final int getYear() {
        return this._CY > 0 ? this._CY : this._CY - 1;
    }

    @Override
    public final int getMonth() {
        return this._M;
    }

    @Override
    public final int getDay() {
        return this._D;
    }

    @Override
    public final int getHour() {
        return this._h;
    }

    @Override
    public final int getMinute() {
        return this._m;
    }

    @Override
    public final int getSecond() {
        return this._s;
    }

    @Override
    public final BigDecimal getFraction() {
        return this._fs;
    }

    @Override
    public final int getMillisecond() {
        if (this._fs == null || this._fs == GDate._zero) {
            return 0;
        }
        return this._fs.setScale(3, 4).unscaledValue().intValue();
    }

    @Override
    public final int getTimeZoneSign() {
        return this._tzsign;
    }

    @Override
    public final int getTimeZoneHour() {
        return this._tzh;
    }

    @Override
    public final int getTimeZoneMinute() {
        return this._tzm;
    }

    public void setYear(int n) {
        if (n < -292275295 || n > 292277265) {
            throw new IllegalArgumentException("year out of range");
        }
        if (n == 0) {
            throw new IllegalArgumentException("year cannot be 0");
        }
        this._bits |= 2;
        this._CY = n > 0 ? n : n + 1;
    }

    public void setMonth(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("month out of range");
        }
        this._bits |= 4;
        this._M = n;
    }

    public void setDay(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("day out of range");
        }
        this._bits |= 8;
        this._D = n;
    }

    public void setTime(int n, int n2, int n3, BigDecimal bigDecimal) {
        if (n < 0 || n > 24) {
            throw new IllegalArgumentException("hour out of range");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("minute out of range");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("second out of range");
        }
        if (bigDecimal != null && (bigDecimal.signum() < 0 || bigDecimal.compareTo(GDate._one) > 1)) {
            throw new IllegalArgumentException("fraction out of range");
        }
        if (n == 24 && (n2 != 0 || n3 != 0 || bigDecimal != null && GDate._zero.compareTo(bigDecimal) != 0)) {
            throw new IllegalArgumentException("when hour is 24, min sec and fracton must be 0");
        }
        this._bits |= 0x10;
        this._h = n;
        this._m = n2;
        this._s = n3;
        this._fs = bigDecimal == null ? GDate._zero : bigDecimal;
    }

    public void setTimeZone(int n, int n2, int n3) {
        if (!(n == 0 && n2 == 0 && n3 == 0 || (n == -1 || n == 1) && n2 >= 0 && n3 >= 0 && (n2 == 14 && n3 == 0 || n2 < 14 && n3 < 60))) {
            throw new IllegalArgumentException("time zone out of range (-14:00 to +14:00). (" + (n < 0 ? "-" : "+") + n2 + ":" + n3 + ")");
        }
        this._bits |= 1;
        this._tzsign = n;
        this._tzh = n2;
        this._tzm = n3;
    }

    public void setTimeZone(int n) {
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException("time zone out of range (-840 to 840 minutes). (" + n + ")");
        }
        int n2 = n < 0 ? -1 : (n > 0 ? 1 : 0);
        int n3 = (n *= n2) / 60;
        int n4 = n - n3 * 60;
        this.setTimeZone(n2, n3, n4);
    }

    public void clearYear() {
        this._bits &= 0xFFFFFFFD;
        this._CY = 0;
    }

    public void clearMonth() {
        this._bits &= 0xFFFFFFFB;
        this._M = 0;
    }

    public void clearDay() {
        this._bits &= 0xFFFFFFF7;
        this._D = 0;
    }

    public void clearTime() {
        this._bits &= 0xFFFFFFEF;
        this._h = 0;
        this._m = 0;
        this._s = 0;
        this._fs = null;
    }

    public void clearTimeZone() {
        this._bits &= 0xFFFFFFFE;
        this._tzsign = 0;
        this._tzh = 0;
        this._tzm = 0;
    }

    @Override
    public boolean isValid() {
        return GDateBuilder.isValidGDate(this);
    }

    static final boolean isValidGDate(GDateSpecification gDateSpecification) {
        if (gDateSpecification.hasYear() && gDateSpecification.getYear() == 0) {
            return false;
        }
        if (gDateSpecification.hasMonth() && (gDateSpecification.getMonth() < 1 || gDateSpecification.getMonth() > 12)) {
            return false;
        }
        if (gDateSpecification.hasDay() && (gDateSpecification.getDay() < 1 || gDateSpecification.getDay() > 31 || gDateSpecification.getDay() > 28 && gDateSpecification.hasMonth() && (gDateSpecification.hasYear() ? gDateSpecification.getDay() > GDateBuilder._maxDayInMonthFor(gDateSpecification.getYear() > 0 ? gDateSpecification.getYear() : gDateSpecification.getYear() + 1, gDateSpecification.getMonth()) : gDateSpecification.getDay() > GDateBuilder._maxDayInMonth(gDateSpecification.getMonth())))) {
            return false;
        }
        if (!(!gDateSpecification.hasTime() || gDateSpecification.getHour() >= 0 && gDateSpecification.getHour() <= 23 && gDateSpecification.getMinute() >= 0 && gDateSpecification.getMinute() <= 59 && gDateSpecification.getSecond() >= 0 && gDateSpecification.getSecond() <= 59 && gDateSpecification.getFraction().signum() >= 0 && gDateSpecification.getFraction().compareTo(GDate._one) < 0 || gDateSpecification.getHour() == 24 && gDateSpecification.getMinute() == 0 && gDateSpecification.getSecond() == 0 && gDateSpecification.getFraction().compareTo(GDate._zero) == 0)) {
            return false;
        }
        return !gDateSpecification.hasTimeZone() || gDateSpecification.getTimeZoneSign() == 0 && gDateSpecification.getTimeZoneHour() == 0 && gDateSpecification.getTimeZoneMinute() == 0 || (gDateSpecification.getTimeZoneSign() == -1 || gDateSpecification.getTimeZoneSign() == 1) && gDateSpecification.getTimeZoneHour() >= 0 && gDateSpecification.getTimeZoneMinute() >= 0 && (gDateSpecification.getTimeZoneHour() == 14 && gDateSpecification.getTimeZoneMinute() == 0 || gDateSpecification.getTimeZoneHour() < 14 && gDateSpecification.getTimeZoneMinute() < 60);
    }

    public void normalize() {
        if (this.hasDay() == this.hasMonth() && this.hasDay() == this.hasYear() && this.hasTimeZone() && this.hasTime()) {
            this.normalizeToTimeZone(0, 0, 0);
        } else {
            this._normalizeTimeAndDate();
        }
        if (this.hasTime() && this._fs != null && this._fs.scale() > 0) {
            if (this._fs.signum() == 0) {
                this._fs = GDate._zero;
            } else {
                int n;
                BigInteger bigInteger = this._fs.unscaledValue();
                String string = bigInteger.toString();
                for (n = string.length(); n > 0 && string.charAt(n - 1) == '0'; --n) {
                }
                if (n < string.length()) {
                    this._fs = this._fs.setScale(this._fs.scale() - string.length() + n);
                }
            }
        }
    }

    void normalize24h() {
        if (!this.hasTime() || this.getHour() != 24) {
            return;
        }
        this._normalizeTimeAndDate();
    }

    private void _normalizeTimeAndDate() {
        long l = 0L;
        if (this.hasTime()) {
            l = this._normalizeTime();
        }
        if (this.hasDay()) {
            this._D = (int)((long)this._D + l);
        }
        if (this.hasDate()) {
            this._normalizeDate();
        } else if (this.hasMonth() && (this._M < 1 || this._M > 12)) {
            int n = this._M;
            this._M = GDateBuilder._modulo(n, 1, 13);
            if (this.hasYear()) {
                this._CY += (int)GDateBuilder._fQuotient(n, 1, 13);
            }
        }
    }

    public void normalizeToTimeZone(int n, int n2, int n3) {
        if (!(n == 0 && n2 == 0 && n3 == 0 || (n == -1 || n == 1) && n2 >= 0 && n3 >= 0 && (n2 == 14 && n3 == 0 || n2 < 14 && n3 < 60))) {
            throw new IllegalArgumentException("time zone must be between -14:00 and +14:00");
        }
        if (!this.hasTimeZone() || !this.hasTime()) {
            throw new IllegalStateException("cannot normalize time zone without both time and timezone");
        }
        if (this.hasDay() != this.hasMonth() || this.hasDay() != this.hasYear()) {
            throw new IllegalStateException("cannot do date math without a complete date");
        }
        int n4 = n * n2 - this._tzsign * this._tzh;
        int n5 = n * n3 - this._tzsign * this._tzm;
        this._tzsign = n;
        this._tzh = n2;
        this._tzm = n3;
        this.addDuration(1, 0, 0, 0, n4, n5, 0, null);
    }

    public void normalizeToTimeZone(int n) {
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException("time zone out of range (-840 to 840 minutes). (" + n + ")");
        }
        int n2 = n < 0 ? -1 : (n > 0 ? 1 : 0);
        int n3 = (n *= n2) / 60;
        int n4 = n - n3 * 60;
        this.normalizeToTimeZone(n2, n3, n4);
    }

    public void addGDuration(GDurationSpecification gDurationSpecification) {
        this.addDuration(gDurationSpecification.getSign(), gDurationSpecification.getYear(), gDurationSpecification.getMonth(), gDurationSpecification.getDay(), gDurationSpecification.getHour(), gDurationSpecification.getMinute(), gDurationSpecification.getSecond(), gDurationSpecification.getFraction());
    }

    public void subtractGDuration(GDurationSpecification gDurationSpecification) {
        this.addDuration(-gDurationSpecification.getSign(), gDurationSpecification.getYear(), gDurationSpecification.getMonth(), gDurationSpecification.getDay(), gDurationSpecification.getHour(), gDurationSpecification.getMinute(), gDurationSpecification.getSecond(), gDurationSpecification.getFraction());
    }

    private void _normalizeDate() {
        if (this._M < 1 || this._M > 12 || this._D < 1 || this._D > GDateBuilder._maxDayInMonthFor(this._CY, this._M)) {
            int n = this._M;
            this._M = GDateBuilder._modulo(n, 1, 13);
            this._CY += (int)GDateBuilder._fQuotient(n, 1, 13);
            int n2 = this._D - 1;
            this._D = 1;
            this.setJulianDate(this.getJulianDate() + n2);
        }
    }

    private long _normalizeTime() {
        long l = 0L;
        if (this._fs != null && (this._fs.signum() < 0 || this._fs.compareTo(GDate._one) >= 0)) {
            BigDecimal bigDecimal = this._fs.setScale(0, 3);
            this._fs = this._fs.subtract(bigDecimal);
            l = bigDecimal.longValue();
        }
        if (l != 0L || this._s < 0 || this._s > 59 || this._m < 0 || this._m > 50 || this._h < 0 || this._h > 23) {
            long l2 = (long)this._s + l;
            l = GDateBuilder._fQuotient(l2, 60);
            this._s = GDateBuilder._mod(l2, 60, l);
            l2 = (long)this._m + l;
            l = GDateBuilder._fQuotient(l2, 60);
            this._m = GDateBuilder._mod(l2, 60, l);
            l2 = (long)this._h + l;
            l = GDateBuilder._fQuotient(l2, 24);
            this._h = GDateBuilder._mod(l2, 24, l);
        }
        return l;
    }

    public void addDuration(int n, int n2, int n3, int n4, int n5, int n6, int n7, BigDecimal bigDecimal) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = n5 != 0 || n6 != 0 || n7 != 0 || bigDecimal != null && bigDecimal.signum() != 0;
        if (bl2 && !this.hasTime()) {
            throw new IllegalStateException("cannot do time math without a complete time");
        }
        boolean bl4 = bl = this.hasDay() && (n4 != 0 || bl2);
        if (bl && !this.hasDate()) {
            throw new IllegalStateException("cannot do date math without a complete date");
        }
        if (n3 != 0 || n2 != 0) {
            if (this.hasDay()) {
                this._normalizeDate();
            }
            int n8 = this._M + n * n3;
            this._M = GDateBuilder._modulo(n8, 1, 13);
            this._CY = this._CY + n * n2 + (int)GDateBuilder._fQuotient(n8, 1, 13);
            if (this.hasDay()) {
                assert (this._D >= 1);
                n8 = GDateBuilder._maxDayInMonthFor(this._CY, this._M);
                if (this._D > n8) {
                    this._D = n8;
                }
            }
        }
        long l = 0L;
        if (bl2) {
            if (bigDecimal != null && bigDecimal.signum() != 0) {
                this._fs = this._fs.signum() == 0 && n == 1 ? bigDecimal : (n == 1 ? this._fs.add(bigDecimal) : this._fs.subtract(bigDecimal));
            }
            this._s += n * n7;
            this._m += n * n6;
            this._h += n * n5;
            l = this._normalizeTime();
        }
        if (bl) {
            this._D = (int)((long)this._D + ((long)(n * n4) + l));
            this._normalizeDate();
        }
    }

    private static int _maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            return GDateBuilder._isLeapYear(n) ? 29 : 28;
        }
        return 31;
    }

    private static int _maxDayInMonth(int n) {
        if (n == 4 || n == 6 || n == 9 || n == 11) {
            return 30;
        }
        if (n == 2) {
            return 29;
        }
        return 31;
    }

    @Override
    public final int getJulianDate() {
        return GDateBuilder.julianDateForGDate(this);
    }

    public void setJulianDate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("date before year -4713");
        }
        int n2 = n + 68569;
        int n3 = 4 * n2 / 146097;
        this._CY = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
        n2 = n2 - 1461 * this._CY / 4 + 31;
        this._M = 80 * n2 / 2447;
        this._D = n2 - 2447 * this._M / 80;
        n2 = this._M / 11;
        this._M = this._M + 2 - 12 * n2;
        this._CY = 100 * (n3 - 49) + this._CY + n2;
        this._bits |= 0xE;
    }

    public void setDate(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getOffset(date.getTime());
        int n2 = 1;
        if (n < 0) {
            n2 = -1;
            n = -n;
        }
        int n3 = n / 60000;
        int n4 = n3 / 60;
        this.setTimeZone(n2, n4, n3 -= n4 * 60);
        int n5 = n2 * (n4 * 60 + n3) * 60 * 1000;
        this.setTime(0, 0, 0, GDate._zero);
        this._bits |= 0xE;
        this._CY = 1970;
        this._M = 1;
        this._D = 1;
        this.addGDuration(new GDuration(1, 0, 0, 0, 0, 0, 0, BigDecimal.valueOf(date.getTime() + (long)n5, 3)));
        if (this._fs.signum() == 0) {
            this._fs = GDate._zero;
        }
    }

    public void setGDate(GDateSpecification gDateSpecification) {
        this._bits = gDateSpecification.getFlags() & 0x1F;
        int n = gDateSpecification.getYear();
        this._CY = n > 0 ? n : n + 1;
        this._M = gDateSpecification.getMonth();
        this._D = gDateSpecification.getDay();
        this._h = gDateSpecification.getHour();
        this._m = gDateSpecification.getMinute();
        this._s = gDateSpecification.getSecond();
        this._fs = gDateSpecification.getFraction();
        this._tzsign = gDateSpecification.getTimeZoneSign();
        this._tzh = gDateSpecification.getTimeZoneHour();
        this._tzm = gDateSpecification.getTimeZoneMinute();
    }

    @Override
    public XmlCalendar getCalendar() {
        return new XmlCalendar(this);
    }

    @Override
    public Date getDate() {
        return GDateBuilder.dateForGDate(this);
    }

    static int julianDateForGDate(GDateSpecification gDateSpecification) {
        if (!gDateSpecification.hasDate()) {
            throw new IllegalStateException("cannot do date math without a complete date");
        }
        int n = gDateSpecification.getDay();
        int n2 = gDateSpecification.getMonth();
        int n3 = gDateSpecification.getYear();
        n3 = n3 > 0 ? n3 : n3 + 1;
        int n4 = n - 32075 + 1461 * (n3 + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - (n2 - 14) / 12 * 12) / 12 - 3 * ((n3 + 4900 + (n2 - 14) / 12) / 100) / 4;
        if (n4 < 0) {
            throw new IllegalStateException("date too far in the past (year allowed to -4713)");
        }
        return n4;
    }

    static Date dateForGDate(GDateSpecification gDateSpecification) {
        long l = GDateBuilder.julianDateForGDate(gDateSpecification);
        long l2 = l - 2440588L;
        long l3 = 86400000L * l2;
        l3 += (long)gDateSpecification.getMillisecond();
        l3 += (long)(gDateSpecification.getSecond() * 1000);
        l3 += (long)(gDateSpecification.getMinute() * 60 * 1000);
        l3 += (long)(gDateSpecification.getHour() * 60 * 60 * 1000);
        if (gDateSpecification.hasTimeZone()) {
            l3 -= (long)(gDateSpecification.getTimeZoneMinute() * gDateSpecification.getTimeZoneSign() * 60 * 1000);
            l3 -= (long)(gDateSpecification.getTimeZoneHour() * gDateSpecification.getTimeZoneSign() * 60 * 60 * 1000);
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            int n = timeZone.getOffset(l3);
            l3 -= (long)n;
        }
        return new Date(l3);
    }

    private static boolean _isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static final long _fQuotient(long l, int n) {
        if (l < 0L == n < 0) {
            return l / (long)n;
        }
        return -(((long)n - l - 1L) / (long)n);
    }

    private static int _mod(long l, int n, long l2) {
        return (int)(l - l2 * (long)n);
    }

    private static final int _modulo(long l, int n, int n2) {
        long l2 = l - (long)n;
        int n3 = n2 - n;
        return GDateBuilder._mod(l2, n3, GDateBuilder._fQuotient(l2, n3)) + n;
    }

    private static final long _fQuotient(long l, int n, int n2) {
        return GDateBuilder._fQuotient(l - (long)n, n2 - n);
    }

    private void _setToFirstMoment() {
        if (!this.hasYear()) {
            this.setYear(1584);
        }
        if (!this.hasMonth()) {
            this.setMonth(1);
        }
        if (!this.hasDay()) {
            this.setDay(1);
        }
        if (!this.hasTime()) {
            this.setTime(0, 0, 0, GDate._zero);
        }
    }

    @Override
    public final int compareToGDate(GDateSpecification gDateSpecification) {
        return GDateBuilder.compareGDate(this, gDateSpecification);
    }

    static final int compareGDate(GDateSpecification gDateSpecification, GDateSpecification gDateSpecification2) {
        int n = gDateSpecification.getFlags() ^ gDateSpecification2.getFlags();
        if ((n & 0x1F) == 0) {
            if (gDateSpecification.hasTimeZone() && (gDateSpecification2.getTimeZoneHour() != gDateSpecification.getTimeZoneHour() || gDateSpecification2.getTimeZoneMinute() != gDateSpecification.getTimeZoneMinute() || gDateSpecification2.getTimeZoneSign() != gDateSpecification.getTimeZoneSign())) {
                gDateSpecification2 = new GDateBuilder(gDateSpecification2);
                int n2 = gDateSpecification.getFlags() & 0xE;
                if (n2 != 0 && n2 != 14 || !gDateSpecification.hasTime()) {
                    ((GDateBuilder)gDateSpecification2)._setToFirstMoment();
                    gDateSpecification = new GDateBuilder(gDateSpecification);
                    ((GDateBuilder)gDateSpecification)._setToFirstMoment();
                }
                ((GDateBuilder)gDateSpecification2).normalizeToTimeZone(gDateSpecification.getTimeZoneSign(), gDateSpecification.getTimeZoneHour(), gDateSpecification.getTimeZoneMinute());
            }
            return GDateBuilder.fieldwiseCompare(gDateSpecification, gDateSpecification2);
        }
        if ((n & 0x1E) != 0) {
            return 2;
        }
        if (!gDateSpecification.hasTimeZone()) {
            int n3 = GDateBuilder.compareGDate(gDateSpecification2, gDateSpecification);
            return n3 == 2 ? 2 : -n3;
        }
        GDateBuilder gDateBuilder = new GDateBuilder(gDateSpecification);
        if ((gDateSpecification.getFlags() & 0xE) == 12) {
            if (gDateSpecification.getDay() == 28 && gDateSpecification.getMonth() == 2) {
                if (gDateSpecification2.getDay() == 1 && gDateSpecification2.getMonth() == 3) {
                    gDateBuilder.setDay(29);
                }
            } else if (gDateSpecification2.getDay() == 28 && gDateSpecification2.getMonth() == 2 && gDateSpecification.getDay() == 1 && gDateSpecification.getMonth() == 3) {
                gDateBuilder.setMonth(2);
                gDateBuilder.setDay(29);
            }
        }
        gDateBuilder._setToFirstMoment();
        GDateBuilder gDateBuilder2 = new GDateBuilder(gDateSpecification2);
        gDateBuilder2._setToFirstMoment();
        gDateBuilder2.setTimeZone(1, 14, 0);
        gDateBuilder2.normalizeToTimeZone(gDateSpecification.getTimeZoneSign(), gDateSpecification.getTimeZoneHour(), gDateSpecification.getTimeZoneMinute());
        if (GDateBuilder.fieldwiseCompare(gDateBuilder, gDateBuilder2) == -1) {
            return -1;
        }
        GDateBuilder gDateBuilder3 = gDateBuilder2;
        gDateBuilder3.setGDate(gDateSpecification2);
        gDateBuilder3._setToFirstMoment();
        gDateBuilder3.setTimeZone(-1, 14, 0);
        gDateBuilder3.normalizeToTimeZone(gDateSpecification.getTimeZoneSign(), gDateSpecification.getTimeZoneHour(), gDateSpecification.getTimeZoneMinute());
        if (GDateBuilder.fieldwiseCompare(gDateBuilder, gDateBuilder3) == 1) {
            return 1;
        }
        return 2;
    }

    private static int fieldwiseCompare(GDateSpecification gDateSpecification, GDateSpecification gDateSpecification2) {
        int n;
        int n2;
        if (gDateSpecification.hasYear()) {
            n2 = gDateSpecification2.getYear();
            n = gDateSpecification.getYear();
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
        }
        if (gDateSpecification.hasMonth()) {
            n2 = gDateSpecification2.getMonth();
            n = gDateSpecification.getMonth();
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
        }
        if (gDateSpecification.hasDay()) {
            n2 = gDateSpecification2.getDay();
            n = gDateSpecification.getDay();
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
        }
        if (gDateSpecification.hasTime()) {
            n2 = gDateSpecification2.getHour();
            n = gDateSpecification.getHour();
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            int n3 = gDateSpecification2.getMinute();
            int n4 = gDateSpecification.getMinute();
            if (n4 < n3) {
                return -1;
            }
            if (n4 > n3) {
                return 1;
            }
            int n5 = gDateSpecification2.getSecond();
            int n6 = gDateSpecification.getSecond();
            if (n6 < n5) {
                return -1;
            }
            if (n6 > n5) {
                return 1;
            }
            BigDecimal bigDecimal = gDateSpecification2.getFraction();
            BigDecimal bigDecimal2 = gDateSpecification.getFraction();
            if (bigDecimal2 == null && bigDecimal == null) {
                return 0;
            }
            return (bigDecimal2 == null ? GDate._zero : bigDecimal2).compareTo(bigDecimal == null ? GDate._zero : bigDecimal);
        }
        return 0;
    }

    @Override
    public final int getBuiltinTypeCode() {
        return GDateBuilder.btcForFlags(this._bits);
    }

    static int btcForFlags(int n) {
        switch (n & 0x1E) {
            case 2: {
                return 18;
            }
            case 6: {
                return 17;
            }
            case 4: {
                return 21;
            }
            case 12: {
                return 19;
            }
            case 8: {
                return 20;
            }
            case 14: {
                return 16;
            }
            case 30: {
                return 14;
            }
            case 16: {
                return 15;
            }
        }
        return 0;
    }

    public void setBuiltinTypeCode(int n) {
        switch (n) {
            case 18: {
                this.clearMonth();
                this.clearDay();
                this.clearTime();
                return;
            }
            case 17: {
                this.clearDay();
                this.clearTime();
                return;
            }
            case 21: {
                this.clearYear();
                this.clearDay();
                this.clearTime();
                return;
            }
            case 19: {
                this.clearYear();
                this.clearTime();
                return;
            }
            case 20: {
                this.clearYear();
                this.clearMonth();
                this.clearTime();
                return;
            }
            case 16: {
                this.clearTime();
                return;
            }
            case 14: {
                return;
            }
            case 15: {
                this.clearYear();
                this.clearMonth();
                this.clearDay();
                return;
            }
        }
        throw new IllegalArgumentException("codeType must be one of SchemaType BTC_  DATE TIME related types.");
    }

    @Override
    public String canonicalString() {
        Serializable serializable;
        boolean bl;
        boolean bl2 = bl = this.hasTimeZone() && this.getTimeZoneSign() != 0 && this.hasTime() && this.hasDay() == this.hasMonth() && this.hasDay() == this.hasYear();
        if (!bl && this.getFraction() != null && this.getFraction().scale() > 0) {
            serializable = this.getFraction().unscaledValue();
            boolean bl3 = bl = ((BigInteger)serializable).mod(TEN).signum() == 0;
        }
        if (!bl) {
            return this.toString();
        }
        serializable = new GDateBuilder(this);
        ((GDateBuilder)serializable).normalize();
        return ((GDateBuilder)serializable).toString();
    }

    @Override
    public final String toString() {
        return GDate.formatGDate(this);
    }
}

