/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.GenericType;
import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaAttribute;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaImport;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.TypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class SchemaTypeSystem
implements Serializable {
    private Map<String, SchemaDocument> schemas = new HashMap<String, SchemaDocument>();
    private List<SchemaElement> globalElements = new ArrayList<SchemaElement>();
    private List<SchemaType> globalTypes = new ArrayList<SchemaType>();
    private List<SchemaAttribute> globalAttributes = new ArrayList<SchemaAttribute>();

    public static SchemaDocument parse(Element element, SchemaTypeSystem schemaTypeSystem) throws Exception {
        SchemaTypeSystem schemaTypeSystem2 = new SchemaTypeSystem(schemaTypeSystem);
        SchemaDocument schemaDocument = schemaTypeSystem2.addSchema(element);
        schemaTypeSystem2.checkNamespaces();
        schemaTypeSystem2.compile();
        return schemaDocument;
    }

    public SchemaTypeSystem() {
    }

    public SchemaTypeSystem(SchemaTypeSystem schemaTypeSystem) throws Exception {
        for (Map.Entry<String, SchemaDocument> entry : schemaTypeSystem.schemas.entrySet()) {
            this.schemas.put(entry.getKey(), entry.getValue());
        }
    }

    public SchemaTypeSystem(Document[] documentArray) throws Exception {
        if (documentArray == null) {
            return;
        }
        for (Document document : documentArray) {
            this.addSchema(document.getRootElement());
        }
        this.checkNamespaces();
        this.compile();
    }

    public SchemaTypeSystem(Element[] elementArray) throws Exception {
        if (elementArray == null) {
            return;
        }
        for (Element element : elementArray) {
            this.addSchema(element);
        }
        this.checkNamespaces();
        this.compile();
    }

    public SchemaTypeSystem(Element[] elementArray, SchemaTypeSystem schemaTypeSystem) throws Exception {
        if (elementArray == null) {
            return;
        }
        for (Map.Entry<String, SchemaDocument> entry : schemaTypeSystem.schemas.entrySet()) {
            this.schemas.put(entry.getKey(), entry.getValue());
        }
        for (Element element : elementArray) {
            this.addSchema(element);
        }
        this.checkNamespaces();
        this.compile();
    }

    protected SchemaDocument addSchema(Element element) throws Exception {
        SchemaDocument schemaDocument = new SchemaDocument(element, this);
        if (this.schemas.containsKey(schemaDocument.getTargetNamespace())) {
            throw new SchemaException("namespace [" + schemaDocument.getTargetNamespace() + "] already contains in type system");
        }
        this.schemas.put(schemaDocument.getTargetNamespace(), schemaDocument);
        return schemaDocument;
    }

    public SchemaDocument importSchema(Element element) throws Exception {
        SchemaDocument schemaDocument = this.addSchema(element);
        this.checkNamespaces(schemaDocument);
        schemaDocument.parse();
        return schemaDocument;
    }

    public SchemaDocument[] importSchema(SchemaTypeSystem schemaTypeSystem) throws Exception {
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        for (SchemaDocument schemaDocument : schemaTypeSystem.getSchemaDocuments()) {
            if (schemaDocument.sts.equals(this)) continue;
            SchemaDocument schemaDocument2 = this.getNamespace(schemaDocument.getTargetNamespace());
            if (schemaDocument2 == null) {
                arrayList.add(this.addSchema(schemaDocument.getSchema().clone()));
                continue;
            }
            schemaDocument2.merge(schemaDocument);
        }
        this.checkNamespaces();
        return arrayList.toArray(new SchemaDocument[0]);
    }

    public void validate() throws Exception {
        for (SchemaDocument schemaDocument : this.getSchemaDocuments()) {
            schemaDocument.parsed = false;
        }
        this.compile();
    }

    private void checkNamespaces() throws Exception {
        for (SchemaDocument schemaDocument : this.getSchemaDocuments()) {
            this.checkNamespaces(schemaDocument);
        }
    }

    private void checkNamespaces(SchemaDocument schemaDocument) throws Exception {
        for (SchemaImport schemaImport : schemaDocument.getImports()) {
            if (this.schemas.containsKey(schemaImport.getNamespace())) continue;
            Element element = null;
            try {
                element = this.retrieveImport(schemaImport);
            }
            catch (Exception exception) {
                System.err.println(String.format("could not retrieve import [%s] from [%s]", schemaImport.getNamespace(), schemaImport.getSchemaLocation()));
            }
            if (element == null) continue;
            SchemaDocument schemaDocument2 = new SchemaDocument(element, this);
            if (schemaDocument2.getTargetNamespace().equals(schemaImport.getNamespace())) {
                this.schemas.put(schemaDocument2.getTargetNamespace(), schemaDocument2);
                this.checkNamespaces(schemaDocument2);
                continue;
            }
            throw new SchemaException("target namespace [" + schemaDocument2.getTargetNamespace() + "] does not match imported namespace [" + schemaImport.getNamespace() + "], in schema namespace [" + schemaDocument.getTargetNamespace() + "]");
        }
    }

    protected void compile() throws Exception {
        for (SchemaDocument schemaDocument : this.schemas.values()) {
            schemaDocument.parse();
        }
        for (SchemaDocument schemaDocument : this.schemas.values()) {
            this.globalElements.addAll(schemaDocument.elements.values());
            this.globalTypes.addAll(schemaDocument.types.values());
            this.globalAttributes.addAll(schemaDocument.attributes.values());
        }
    }

    public SchemaElement getGlobalElement(String string, String string2) {
        try {
            return this.lookupElement(new QName(string, string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SchemaType lookupType(String string) {
        if (string == null) {
            return null;
        }
        GenericTypes genericTypes = TypeMap.fromName(string);
        if (genericTypes != null) {
            return genericTypes.getType();
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            System.err.println("cannot find name [" + string + "] in schema type system");
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        SchemaDocument schemaDocument = this.getNamespace(string2);
        if (schemaDocument == null) {
            System.err.println("cannot find namespace [" + string2 + "] in schema type system");
            return null;
        }
        SchemaType schemaType = schemaDocument.getType(string3);
        if (schemaType != null) {
            return schemaType;
        }
        System.err.println("cannot find name [" + string + "] in schema type system");
        return null;
    }

    protected SchemaElement lookupElement(QName qName) throws Exception {
        if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return null;
        }
        SchemaDocument schemaDocument = this.schemas.get(qName.getNamespaceURI());
        if (schemaDocument != null) {
            SchemaElement schemaElement = schemaDocument.getElement(qName.getLocalPart());
            if (schemaElement != null) {
                return schemaElement;
            }
            throw new SchemaException("could not find element [" + qName.getLocalPart() + "] in namespace [" + qName.getNamespaceURI() + "]");
        }
        throw new SchemaException("could not lookup namespace for element name [" + qName + "]");
    }

    public SchemaType getGlobalType(QName qName) {
        return this.getGlobalType(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public SchemaType getGlobalType(String string, String string2) {
        try {
            return this.lookupType(new QName(string, string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected SchemaType lookupType(QName qName) throws Exception {
        if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return new GenericType(qName);
        }
        SchemaDocument schemaDocument = this.schemas.get(qName.getNamespaceURI());
        if (schemaDocument != null) {
            SchemaType schemaType = schemaDocument.getType(qName.getLocalPart());
            if (schemaType != null) {
                return schemaType;
            }
            System.err.println(String.format("could not find type [%s] in namespace [%s]", qName.getLocalPart(), qName.getNamespaceURI()));
            return null;
        }
        System.err.println(String.format("could not lookup namespace for type name [%s]", qName));
        return null;
    }

    private Element retrieveImport(SchemaImport schemaImport) throws Exception {
        try {
            URL uRL = new URL(schemaImport.getSchemaLocation());
            return this.parseDom(uRL.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file = new File(schemaImport.getSchemaLocation());
                return this.parseDom(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element parseDom(InputStream inputStream) throws Exception {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement();
            return element;
        }
        finally {
            inputStream.close();
        }
    }

    public List<SchemaElement> getGlobalElements() {
        return this.globalElements;
    }

    public List<SchemaType> getGlobalTypes() {
        return this.globalTypes;
    }

    public List<SchemaAttribute> getGlobalAttributes() {
        return this.globalAttributes;
    }

    public SchemaDocument createSchema(String string) throws Exception {
        return this.createSchema(string, string);
    }

    public SchemaDocument createSchema(String string, String string2) throws Exception {
        if (!this.schemas.containsKey(string)) {
            SchemaDocument schemaDocument = new SchemaDocument(string, string2, this);
            this.schemas.put(string, schemaDocument);
            return schemaDocument;
        }
        throw new SchemaException("namespace [" + string + "] already exists");
    }

    public SchemaDocument getNamespace(String string) {
        return this.schemas.get(string);
    }

    public SchemaDocument[] getSchemaDocuments() {
        return this.schemas.values().toArray(new SchemaDocument[0]);
    }

    public Element[] getSchemas() {
        Element[] elementArray = new Element[this.schemas.size()];
        Iterator<SchemaDocument> iterator = this.schemas.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SchemaDocument schemaDocument = iterator.next();
            elementArray[n] = schemaDocument.getSchema();
            ++n;
        }
        return elementArray;
    }
}

