/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import commvault.cte.util.Application;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.JPanel;

public class CompGlassPane
extends JPanel {
    private static final String PROGRESS_BLUE_IMG_KEY = "Progress-Blue";
    private static final String PROGRESS_RED_IMG_KEY = "Progress-Red";
    private static final String PROGRESS_GREEN_IMG_KEY = "Progress-Green";
    private AlphaComposite composite;
    private Point location = new Point(25, 10);
    private static final Toolkit tk = Toolkit.getDefaultToolkit();
    private Image dragged = Application.instance().getIconSource().getImage("Progress-Blue");
    private boolean showProgress;
    private static final Random random = new Random();

    public CompGlassPane() {
        this.setOpaque(false);
        this.composite = AlphaComposite.getInstance(3, 0.8f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && mouseEvent.isShiftDown()) {
                    CompGlassPane.this.setVisible(false);
                }
            }
        });
    }

    public void setImage(Image image) {
        this.dragged = image;
    }

    public void setPoint(Point point) {
        this.location = point;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.showProgress) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(this.composite);
            int n = (int)(this.location.getX() - (double)(this.dragged.getWidth(this) / 2));
            int n2 = (int)(this.location.getY() - (double)(this.dragged.getHeight(this) / 2));
            graphics2D.drawString("Loading. Please wait", n + this.dragged.getWidth(this) + 15, n2 + 20);
            graphics2D.drawImage(this.dragged, n, n2, null);
        }
    }

    public void setShowProgressImg(boolean bl) {
        this.showProgress = bl;
    }
}

