/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.BaseFolder;
import commvault.cte.cm.ColumnType;
import commvault.cte.cm.db.DBBase;
import commvault.cte.cm.db.DBConnection;
import commvault.cte.cm.db.DBInsert;
import commvault.cte.cm.db.DBSelect;
import commvault.cte.cm.db.DBUpdate;
import commvault.msgs.CM.Column;
import commvault.msgs.CM.Folder;
import java.sql.ResultSet;

public abstract class FolderEntry
extends BaseFolder {
    private static final String VALUE_SELECT = "select * from %s where Id = %s";
    protected int rowId = 0;

    protected FolderEntry(Folder folder) {
        super(folder);
    }

    protected FolderEntry(Folder folder, int n) throws Exception {
        this(folder);
        this.rowId = n;
        this.loadValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValues() throws Exception {
        block7: {
            try (DBConnection dBConnection = null;){
                dBConnection = DBSelect.create(String.format(VALUE_SELECT, this.getTableName(), this.rowId));
                ResultSet resultSet = ((DBSelect)dBConnection).execute();
                if (resultSet.next()) {
                    for (Column column : this.columns) {
                        try {
                            column.setRowValue(resultSet.getString(column.getColumn().getSqlName()));
                        }
                        catch (Exception exception) {}
                    }
                    break block7;
                }
                throw new Exception("row [" + this.rowId + "] does not exist in folder [" + this.getFolder().getFolderName() + "]");
            }
        }
    }

    public Object getValue(String string) throws Exception {
        Column column = this.getColumn(string);
        if (column != null) {
            return column.getRowValue();
        }
        throw new Exception("column [" + string + "] does not exist in folder [" + this.getFolder().getFolderName() + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String string, Object object) throws Exception {
        Column column = this.getColumn(string);
        if (column == null) throw new Exception("column [" + string + "] does not exist in folder [" + this.getFolder().getFolderName() + "]");
        if (object == null) {
            column.setRowValue(null);
            return;
        } else {
            ColumnType columnType = ColumnType.fromInt(column.getColumnType());
            if (!object.getClass().isAssignableFrom(columnType.getJavaClass())) throw new Exception("column [" + string + "] in folder [" + this.getFolder().getFolderName() + "] does not accept values of type [" + object.getClass() + "]");
            column.setRowValue(String.valueOf(object));
        }
    }

    private void check() throws Exception {
        for (Column column : this.columns) {
            if (!column.getRequired() || column.getRowValue() != null) continue;
            throw new Exception("column [" + column.getColumn().getColumnName() + "] in folder [" + this.getFolder().getFolderName() + "] is required and does not allow null values");
        }
    }

    public void save() throws Exception {
        if (this.getFolder().getFolderId() > 0) {
            this.check();
            if (this.rowId == 0) {
                this.insert();
            } else {
                this.update();
            }
        } else {
            throw new Exception("cannot save entry to a null folder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert() throws Exception {
        block9: {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into ");
            stringBuilder.append(this.getTableName());
            stringBuilder.append(" (");
            int n2 = 0;
            for (n = 0; n < this.columns.size(); ++n) {
                if (((Column)this.columns.get(n)).getReadOnly()) continue;
                ++n2;
                stringBuilder.append(((Column)this.columns.get(n)).getColumn().getSqlName());
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            if (n2 > 0) {
                stringBuilder.append(") values (");
                for (n = 0; n < this.columns.size(); ++n) {
                    if (((Column)this.columns.get(n)).getReadOnly()) continue;
                    stringBuilder.append("?");
                    stringBuilder.append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(")");
            } else {
                stringBuilder.append("Default values");
            }
            try (DBConnection dBConnection = null;){
                dBConnection = DBInsert.create(stringBuilder.toString(), true);
                for (Column column : this.columns) {
                    if (column.getReadOnly()) continue;
                    ((DBBase)dBConnection).addParameter(column);
                }
                ((DBInsert)dBConnection).execute();
                ResultSet resultSet = ((DBInsert)dBConnection).getGeneratedKeys();
                if (resultSet.next()) {
                    this.rowId = resultSet.getInt(1);
                    break block9;
                }
                throw new Exception("new entry in folder [" + this.getFolder().getFolderName() + "] returned no key");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() throws Exception {
        if (this.rowId > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("update ");
            stringBuilder.append(this.getTableName());
            stringBuilder.append(" set ");
            stringBuilder.append("Modified = ?");
            for (int i = 0; i < this.columns.size(); ++i) {
                if (((Column)this.columns.get(i)).getReadOnly()) continue;
                stringBuilder.append(",");
                stringBuilder.append(((Column)this.columns.get(i)).getColumn().getSqlName());
                stringBuilder.append(" = ?");
            }
            stringBuilder.append(" where Id=" + this.rowId);
            try (DBUpdate dBUpdate = null;){
                dBUpdate = DBUpdate.create(stringBuilder.toString());
                for (Column column : this.columns) {
                    if (column.getReadOnly()) continue;
                    dBUpdate.addParameter(column);
                }
                dBUpdate.execute();
            }
        } else {
            throw new Exception("new folder entry cannot be updated");
        }
    }

    public void delete() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("delete from ");
        stringBuilder.append(this.getTableName());
        stringBuilder.append(" where Id=" + this.rowId);
        try (DBUpdate dBUpdate = null;){
            dBUpdate = DBUpdate.create(stringBuilder.toString());
            dBUpdate.execute();
        }
    }

    public int getRowId() {
        return this.rowId;
    }
}

