/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.binder.forms;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.SpinnerAdapterFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.validation.ValidationResult;
import com.jidesoft.field.IPTextField;
import commvault.cte.binder.BufferedPresentationModel;
import commvault.cte.binder.CVPresentationModel;
import commvault.cte.binder.Operator;
import commvault.cte.binder.ValueModelUtil;
import commvault.cte.binder.builder.UIFactory;
import commvault.cte.common.Enabler;
import commvault.cte.component.CNFilterListSelectionPanel;
import commvault.cte.component.CNListSelectionPanel;
import commvault.cte.component.NameTextField;
import commvault.cte.component.SComboBox;
import commvault.cte.component.SortedComboBoxModel;
import commvault.cte.util.Application;
import commvault.cte.util.EnumUtil;
import commvault.cte.util.ExceptionFileNotFoundInLangPack;
import commvault.cte.util.LangString;
import commvault.cte.util.Logger;
import commvault.cte.util.LookupInLangpack;
import commvault.cte.util.StringCategory;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class BindingPanel
extends JPanel {
    protected CVPresentationModel model;
    private ResourceBundle rb = null;
    private ValidationResult validationResult = null;
    private boolean showErrorMessage = true;
    private String msgbundleName;

    public BindingPanel(Object object, Trigger trigger, boolean bl) {
        super(new GridBagLayout());
        ResourceBundle resourceBundle = null;
        try {
            if (Application.instance().isAddInGui()) {
                this.msgbundleName = "commvault.i18n.MessagesBundle";
                resourceBundle = ResourceBundle.getBundle("commvault.i18n.MessagesBundle");
            } else {
                this.msgbundleName = object.getClass().getPackage().getName() + ".MessageBundle";
                resourceBundle = ResourceBundle.getBundle(object.getClass().getPackage().getName() + ".MessageBundle");
            }
        }
        catch (MissingResourceException missingResourceException) {
            String string = " Missing ResourceBundle << {0} >>  for class  << {1} >>";
            Object[] objectArray = new Object[]{missingResourceException.getClassName(), object.getClass().getName()};
            String string2 = MessageFormat.format(string, objectArray);
            System.err.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        final ResourceBundle resourceBundle2 = resourceBundle;
        this.rb = new ResourceBundle(){

            @Override
            public String getBaseBundleName() {
                return BindingPanel.this.msgbundleName;
            }

            @Override
            public Enumeration<String> getKeys() {
                if (resourceBundle2 == null) {
                    return new Enumeration<String>(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        @Override
                        public String nextElement() {
                            return null;
                        }
                    };
                }
                return resourceBundle2.getKeys();
            }

            @Override
            protected Object handleGetObject(String string) {
                try {
                    return resourceBundle2.getObject(string);
                }
                catch (Exception exception) {
                    return EnumUtil.checkExternalise(string);
                }
            }
        };
        this.model = trigger == null ? new CVPresentationModel<Object>(object) : new BufferedPresentationModel<Object>(object, (ValueModel)trigger);
    }

    public BindingPanel(Object object, Trigger trigger) {
        this(object, trigger, false);
    }

    public BindingPanel(Object object, boolean bl) {
        this(object, null, bl);
    }

    public BindingPanel(Object object) {
        this(object, null);
    }

    public CVPresentationModel getBindingModel() {
        return this.model;
    }

    public JRadioButton createRadioButton(String string, boolean bl) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return this.createRadioButton((ValueModel)abstractValueModel, this.model.getBean().getClass().getSimpleName(), string, bl);
    }

    private String getFromResourceBundle(String string, String string2) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.ROOT);
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            Logger.instance().println(Logger.FINER, "ResourceBundle not found in getFromResourceBundle" + string2);
            return EnumUtil.checkExternalise(string);
        }
    }

    private String getFromLangPack(String string, String string2, String string3) {
        try {
            if (string3.equals("")) {
                string3 = "en_US";
            }
            if (string3.equals("en_US")) {
                return this.rb.getString(string);
            }
            LookupInLangpack lookupInLangpack = LookupInLangpack.getInstance();
            if (lookupInLangpack == null) {
                throw new Exception("Langpack not found");
            }
            String string4 = string2;
            LangString langString = lookupInLangpack.lookupInFileInfo(string4, string3, string);
            if (langString.getCode() == 0) {
                return langString.getLanguageString();
            }
            if (langString.getCode() != 1) {
                if (string3.equals("fr_CA")) {
                    return this.getFromLangPack(string, string2, "fr");
                }
                if (string3.equals("es_MX")) {
                    return this.getFromLangPack(string, string2, "es");
                }
            }
            String string5 = this.rb.getString(string);
            if (langString.getCode() == 1) {
                langString = lookupInLangpack.lookupDuplicateInFileInfo(string4, string3, string, string5);
                if (langString.getCode() == 0) {
                    return langString.getLanguageString();
                }
                if (string3.equals("fr_CA")) {
                    return this.getFromLangPack(string, string2, "fr");
                }
                if (string3.equals("es_MX")) {
                    return this.getFromLangPack(string, string2, "es");
                }
            }
            return string5;
        }
        catch (ExceptionFileNotFoundInLangPack exceptionFileNotFoundInLangPack) {
            ExceptionFileNotFoundInLangPack exceptionFileNotFoundInLangPack2 = new ExceptionFileNotFoundInLangPack(string2);
            return this.getFromResourceBundle(string, string2);
        }
        catch (Exception exception) {
            Logger.instance().println(Logger.FINER, "Error while getting from langpack - bundle:" + string2 + " key:" + string + " locale:" + string3);
            return this.getFromResourceBundle(string, string2);
        }
    }

    public String getLocString(String string) {
        return this.getFromLangPack(string, this.msgbundleName, Locale.getDefault().toString());
    }

    public JRadioButton createRadioButton(ValueModel valueModel, String string, String string2, boolean bl) {
        String string3 = string + "." + string2;
        if (!bl) {
            string3 = string3 + ".falseText";
        }
        String string4 = string3;
        try {
            string4 = this.getLocString(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UIFactory.createRadioButton(valueModel, bl, string4);
    }

    public JRadioButton createRadioButton(String string, Object object) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        String string2 = object.getClass().getSimpleName() + "." + object;
        return UIFactory.createRadioButton((ValueModel)abstractValueModel, object, this.getLocString(string2));
    }

    public JRadioButton createRadioButton(String string, Object object, String string2) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        String string3 = object.getClass().getSimpleName() + "." + object;
        return UIFactory.createRadioButton((ValueModel)abstractValueModel, object, string2);
    }

    public JRadioButton createRadioButton(ValueModel valueModel, String string, Object object) {
        String string2 = object.getClass().getSimpleName() + "." + object;
        return UIFactory.createRadioButton(valueModel, object, this.getLocString(string2));
    }

    public JCheckBox createCheckBox(String string) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        String string2 = this.getLabel(string);
        return UIFactory.createCheckBox((ValueModel)abstractValueModel, (String)string2);
    }

    public JCheckBox createCheckBoxFromComponentValueModel(String string) {
        return UIFactory.createCheckBox((ValueModel)this.model.getComponentModel(string), (String)this.getLabel(string));
    }

    public JComboBox createComboBox(String string) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return new JComboBox(new ComboBoxAdapter(new DefaultComboBoxModel(), (ValueModel)abstractValueModel));
    }

    public JComboBox createComboBox(String string, SortedComboBoxModel sortedComboBoxModel) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return new JComboBox(new ComboBoxAdapter((ListModel)sortedComboBoxModel, (ValueModel)abstractValueModel));
    }

    public SComboBox createSComboBox(String string, SortedComboBoxModel sortedComboBoxModel) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return new SComboBox((ComboBoxModel)new ComboBoxAdapter((ListModel)sortedComboBoxModel, (ValueModel)abstractValueModel));
    }

    public JList createList(String string) {
        SelectionInList selectionInList = new SelectionInList();
        return UIFactory.createList((SelectionInList)selectionInList);
    }

    public CNListSelectionPanel createDnDPanel(String string, DefaultListCellRenderer defaultListCellRenderer) {
        return this.createDnDPanel(string, defaultListCellRenderer, false);
    }

    public CNListSelectionPanel createDnDPanel(String string, DefaultListCellRenderer defaultListCellRenderer, boolean bl) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return UIFactory.createDnDPanel((ValueModel)abstractValueModel, null, bl, false, defaultListCellRenderer);
    }

    public CNFilterListSelectionPanel createCNFilterDnDPanel(String string, DefaultListCellRenderer defaultListCellRenderer) {
        return this.createCNFilterDnDPanel(string, defaultListCellRenderer, false);
    }

    public CNFilterListSelectionPanel createCNFilterDnDPanel(String string, DefaultListCellRenderer defaultListCellRenderer, boolean bl) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return UIFactory.createCNFilterDnDPanel((ValueModel)abstractValueModel, null, bl, false, defaultListCellRenderer);
    }

    public JTextField createTextField(String string) {
        return this.createTextField(string, true);
    }

    public JTextField createTextField(String string, boolean bl) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return UIFactory.createTextField((ValueModel)abstractValueModel, (boolean)bl);
    }

    public NameTextField createNameTextField(String string) {
        NameTextField nameTextField = new NameTextField(128.0, "");
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        Bindings.bind((JTextField)nameTextField, (ValueModel)abstractValueModel);
        return nameTextField;
    }

    public NameTextField createNameTextField(String string, int n) {
        NameTextField nameTextField = new NameTextField((double)n, "");
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        Bindings.bind((JTextField)nameTextField, (ValueModel)abstractValueModel);
        return nameTextField;
    }

    public JTextArea createTextArea(String string) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return UIFactory.createTextArea((ValueModel)abstractValueModel, (boolean)true);
    }

    public JPasswordField createPassWordField(String string) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        JPasswordField jPasswordField = UIFactory.createPasswordField((ValueModel)abstractValueModel, (boolean)true);
        return jPasswordField;
    }

    public JSpinner createNumberSpinner(String string, int n, int n2, int n3, int n4) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        SpinnerNumberModel spinnerNumberModel = SpinnerAdapterFactory.createNumberAdapter((ValueModel)abstractValueModel, (int)n, (int)n2, (int)n3, (int)n4);
        return new JSpinner(spinnerNumberModel);
    }

    public JSpinner createSpinner(String string, int n, SpinnerModel spinnerModel) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        SpinnerAdapterFactory.connect((SpinnerModel)spinnerModel, (ValueModel)abstractValueModel, (Object)n);
        return new JSpinner(spinnerModel);
    }

    public JComponent setEnable(String string, JComponent jComponent, boolean bl) {
        if (bl) {
            new Enabler<JComponent>((ValueModel)this.model.getModel(string)).enable(jComponent);
        } else {
            new Enabler<JComponent>(ValueModelUtil.createValueModel((ValueModel)this.model.getModel(string), false, Operator.EQUAL)).enable(jComponent);
        }
        return jComponent;
    }

    public JLabel createLabel(String string) {
        AbstractValueModel abstractValueModel = this.model.getModel(string);
        return UIFactory.createLabel((ValueModel)abstractValueModel);
    }

    public String getLabel(String string) {
        return EnumUtil.getLabel(this.rb, this.model.getBean().getClass(), string);
    }

    public String getLabel(String string, String string2) {
        return EnumUtil.getLabel(this.rb, string, string2);
    }

    public String getTitle(String string) {
        throw new UnsupportedOperationException();
    }

    public String getString(StringCategory stringCategory, String string) {
        throw new UnsupportedOperationException();
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public ValidationResult createValidationResult() {
        this.validationResult = new ValidationResult();
        return this.validationResult;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void addError(String string) {
        this.validationResult.addError(string);
    }

    public void addWarning(String string) {
        this.validationResult.addWarning(string);
    }

    public void validateUserInput() {
    }

    public void updateCVTask() {
    }

    public boolean isUserInputValid() {
        return true;
    }

    public void dispose() {
        this.model.release();
    }

    public IPTextField createIPTextField(String string) {
        return new IPTextField(this.model.getModel(string).getValue().toString());
    }

    public IPTextField createIPTextField(ValueModel valueModel) {
        return new IPTextField(valueModel.getValue().toString());
    }

    public boolean isShowErrorMessage() {
        return this.showErrorMessage;
    }

    public void setShowErrorMessage(boolean bl) {
        this.showErrorMessage = bl;
    }
}

