/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.CteStringBank;
import commvault.cte.alert.AlertConstants;
import commvault.cte.alert.AlertEntityAppTypeContext;
import commvault.cte.alert.model.Alert;
import commvault.cte.alert.model.AlertNotifMsg;
import commvault.cte.alert.model.ReportingCriteria;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.component.Utilities;
import commvault.cte.component.tree.AlertMultiStateTreeNode;
import commvault.cte.component.tree.EntityContext;
import commvault.cte.component.tree.EntityTree;
import commvault.cte.component.tree.EntityTreePanel;
import commvault.cte.net.IdIdNameItem;
import commvault.msgs.App.SecurityAssociationForEntity;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.GenericEntity;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SummaryWriter {
    private static final String prefix = "commvault.cte.alert.AlertSummaryPage";
    private static final String SPACE = "&nbsp;";
    private static final String SUMMARY = CteStringBank.Summary.getI18n();
    private static final String MONITORED_NODES = CteStringBank.Monitored_Nodes.getI18n();
    private static final String ALERT_CRITERIA = CteStringBank.Alert_Criteria.getI18n();
    private static final String USER_USERGROUPS = CteStringBank.User_and_User_Groups.getI18n();
    private static final String NOTIFICATION_TYPE = CteStringBank.Notification_Types.getI18n();
    private static final String REPORTING_CRITERIA = CteStringBank.Reporting_Criteria.getI18n();
    private static final String EXTERNAL_GROUPS = CteStringBank.External_Groups.getI18n();
    private static final String NON_GALAXY_USERS = CteStringBank.Non15Galaxy_Users.getI18n();
    private static final String NON_GALAXY_USERS_TO = CteStringBank.Non15Galaxy_Users_To.getI18n();
    private static final String NON_GALAXY_USERS_CC = CteStringBank.Non15Galaxy_Users_Cc.getI18n();
    private static final String NON_GALAXY_USERS_BCC = CteStringBank.Non15Galaxy_Users_Bcc.getI18n();
    private static final String FEED_LOCATION = CteStringBank.RSS_Feeds_Location.getI18n();
    private static final String SECURITY_ASSOC = CteStringBank.Security_Assoc.getI18n();
    private static final String APP_TYPE_FILTER = CteStringBank.Agent_Type_Filter.getI18n();
    public static final int SCHEDULED_REPORT = 52;

    private SummaryWriter() {
    }

    private String writeSummary(Alert alert, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlStartTag());
        if (alert.getAlertDetails().getAlertType().getId() != 52 || !bl) {
            if (alert.getAlertDetails().getAlertCategory().getId() == 7) {
                stringBuffer.append(this.writeTitle(CteStringBank.Schedule_Information.getI18n()));
            } else {
                stringBuffer.append(this.writeTitle(CteStringBank.Alert_Information.getI18n()));
            }
            stringBuffer.append(this.writeInTabularForm(this.createAlertInfoMap(alert)));
            stringBuffer.append("<br>");
        }
        if (alert.getAlertDetails().getAlertCategory().getId() == 7) {
            stringBuffer.append(this.writeTitle(CteStringBank.Notification_Configuration.getI18n()));
        } else {
            stringBuffer.append(this.writeTitle(CteStringBank.Alert_Configuration.getI18n()));
        }
        stringBuffer.append(this.writeInTabularForm(this.getAlertConfigsMap(alert, 1)));
        if (alert.isEscalationSelected()) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.writeTitle(CteStringBank.Alert_Escalation_Configuration.getI18n()));
            stringBuffer.append(this.writeInTabularForm(this.getAlertConfigsMap(alert, 2)));
        }
        if (alert.getTokenRulesSummary() != null && !alert.getTokenRulesSummary().isEmpty()) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.writeTitle(CteStringBank.Token_rules.getI18n()));
            stringBuffer.append("<br>");
            stringBuffer.append(alert.getTokenRulesSummary());
        }
        if (alert.getSecurityAssociations().getAssociations().size() != 0) {
            stringBuffer.append("<br>");
            stringBuffer.append(this.writeTitle(CteStringBank.Security_Assoc.getI18n()));
            stringBuffer.append(this.writeInTabularForm(this.getSecurityAssociationsMap(alert)));
        }
        stringBuffer.append(this.getHTMLEndTag());
        return stringBuffer.toString();
    }

    private Map getSecurityAssociationsMap(Alert alert) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(CteStringBank.Alert_user.getI18n(), this.getString(this.getSecurityAssociations(alert, true)));
        linkedHashMap.put(CteStringBank.Alert_user_group.getI18n(), this.getString(this.getSecurityAssociations(alert, false)));
        return linkedHashMap;
    }

    public static JComponent getSummary(Alert alert) {
        return SummaryWriter.getSummary(alert, false);
    }

    public static JComponent getSummary(final Alert alert, boolean bl) {
        SummaryWriter summaryWriter = new SummaryWriter();
        final JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jTabbedPane.addTab(SUMMARY, jPanel);
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.setText(summaryWriter.writeSummary(alert, bl));
        jTextPane.setEnabled(alert.getAlertDetails().isEnabled());
        Utilities.fillRemaining(jPanel, new JScrollPane(jTextPane));
        if (alert.getRootEntity() != null && alert.getRootEntity().getChildren() != null && alert.getRootEntity().getChildren().size() != 0 || alert.getAlertDetails().getAlertCategory().getId() == 9) {
            final JPanel jPanel2 = new JPanel(new GridBagLayout());
            jTabbedPane.addTab(MONITORED_NODES, jPanel2);
            jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (jPanel2.getComponentCount() == 0) {
                        Object object;
                        HashMap<Integer, List<Integer>> hashMap;
                        jTabbedPane.setCursor(Cursor.getPredefinedCursor(3));
                        AlertMultiStateTreeNode alertMultiStateTreeNode = null;
                        AlertMultiStateTreeNode alertMultiStateTreeNode2 = null;
                        boolean bl = false;
                        if (alert.getAlertDetails().getAlertCategory().getId() == 9) {
                            hashMap = alert.getAlertDetails().getAlertType().getName();
                            alertMultiStateTreeNode2 = alert.getAlertServerObject().getAlertRuleRootNode((String)((Object)hashMap));
                            if (alertMultiStateTreeNode2 != null) {
                                bl = true;
                            }
                        }
                        if (bl) {
                            alertMultiStateTreeNode = alertMultiStateTreeNode2;
                        } else {
                            hashMap = null;
                            if ((alert.getAlertType().getActionsAllowed() & 0x10) != 0) {
                                hashMap = alert.getAlertServerObject().getClientAppTypeEntitiesMap();
                            }
                            object = new AlertEntityAppTypeContext(alert, -1, hashMap);
                            alertMultiStateTreeNode = new AlertMultiStateTreeNode(alert.getRootEntity(), (EntityContext)object);
                            ((AlertEntityAppTypeContext)object).loadSelectionsAndExclusions(alertMultiStateTreeNode);
                        }
                        hashMap = new EntityTree(alertMultiStateTreeNode, false);
                        if (alertMultiStateTreeNode.getChildCount() > 0) {
                            ((JTree)((Object)hashMap)).expandPath(new TreePath(((DefaultMutableTreeNode)alertMultiStateTreeNode.getChildAt(0)).getPath()));
                        }
                        object = new EntityTreePanel((EntityTree)((Object)hashMap));
                        ((EntityTreePanel)object).setShowSelectedOnly();
                        Utilities.fillRemaining(jPanel2, (JComponent)object);
                        jTabbedPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }
        return jTabbedPane;
    }

    private String writeTitle(String string) {
        return new StringBuffer("<font size=3><b>").append(string).append("</b></font>").toString();
    }

    private String getHtmlStartTag() {
        return "<html>";
    }

    private String getHTMLEndTag() {
        return "</html>";
    }

    private String writeInTabularForm(Map map, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(" <table cellspacing=0 cellpadding=0> ");
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            stringBuffer.append("<tr>");
            stringBuffer.append("<td nowrap align=left, valign=top>");
            if (bl2) {
                stringBuffer.append("<i>");
            }
            stringBuffer.append(SPACE).append(SPACE).append(SPACE).append(entry.getKey());
            if (bl2) {
                stringBuffer.append("</i>");
            }
            stringBuffer.append("</td>");
            if (!bl) {
                stringBuffer.append("<td nowrap align=left, valign=top> <b>");
                stringBuffer.append("&nbsp;:&nbsp;");
                stringBuffer.append("</b></td>");
            }
            if (entry.getValue() != null) {
                stringBuffer.append("<td align=left, valign=top>");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append(" </table> ");
        return stringBuffer.toString();
    }

    private String writeInTabularForm(Map map) {
        return this.writeInTabularForm(map, false, false);
    }

    private Map createAlertInfoMap(Alert alert) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(CteStringBank.Alert_Category.getI18n(), alert.getAlertDetails().getAlertCategory().getName());
        if (alert.getAlertDetails().getAlertCategory().getId() == 9) {
            linkedHashMap.put(CteStringBank.Alert_Type.getI18n(), alert.getAlertDetails().getAlertType().getName());
        } else {
            linkedHashMap.put(CteStringBank.Alert_Type.getI18n(), alert.getAlertType().getAlertTypeName());
        }
        List list = alert.getCriteria();
        if ((alert.getAlertDetails().getStatus() & 0x10) == 16) {
            list.add(CteStringBank.Send_individual_notification_for_this_alert.getI18n());
        }
        if ((alert.getAlertDetails().getStatus() & 0x400) == 1024) {
            if (alert.getAlertDetails().getAlertType().getId() == 3) {
                list.add(CteStringBank.Send_individual_notification_for_each_backed_up_discovered_virtual_machine.getI18n());
            } else {
                list.add(CteStringBank.Send_individual_notification_for_each_restored_discovered_virtual_machine.getI18n());
            }
        }
        if (alert.getAlertDetails().getAlertType().getId() == 58) {
            Object object = null;
            String string = null;
            Field field = null;
            boolean bl = false;
            try {
                object = XMLDecoder.decode(alert.getEventCriteria());
                Field[] fieldArray = object.getClass().getDeclaredFields();
                block2: for (int i = 0; i < fieldArray.length; ++i) {
                    Field field2 = fieldArray[i];
                    if (field2.getName().equals("criteriaName")) {
                        field2.setAccessible(true);
                        field = field2;
                        continue;
                    }
                    if (!field2.getName().equals("conditions")) continue;
                    field2.setAccessible(true);
                    ArrayList arrayList = (ArrayList)field2.get(object);
                    if (arrayList == null || arrayList.size() <= 0) continue;
                    Object e = arrayList.get(0);
                    Field[] fieldArray2 = e.getClass().getDeclaredFields();
                    for (int j = 0; j < fieldArray2.length; ++j) {
                        Field field3 = fieldArray2[j];
                        if (!field3.getName().equals("isregex")) continue;
                        field3.setAccessible(true);
                        bl = (Boolean)field3.get(e);
                        continue block2;
                    }
                }
                string = (String)field.get(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                linkedHashMap.put(ALERT_CRITERIA, string.toString().replace("|", " OR ").replaceAll("&", " AND "));
            } else {
                linkedHashMap.put(ALERT_CRITERIA, string.toString());
            }
        } else {
            linkedHashMap.put(ALERT_CRITERIA, this.getString(list.iterator()));
        }
        if (alert.getAlertDetails().getAlertCategory().getId() == 9 && (alert.getAlertDetails().getStatus() & 0x200) > 0) {
            linkedHashMap.put(CteStringBank.Custom_Alert_Status.getI18n(), CteStringBank.Custom_Disabled.getI18n());
        }
        if ((alert.getAlertDetails().getStatus() & 0x80) > 0) {
            linkedHashMap.put(CteStringBank.subscription_enabled.getI18n(), CteStringBank.Yes.getI18n());
        }
        return linkedHashMap;
    }

    private String getString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(this.modifyString(iterator.next().toString()));
        } else {
            return null;
        }
        while (iterator.hasNext()) {
            stringBuffer.append(',');
            stringBuffer.append(SPACE);
            stringBuffer.append(this.modifyString(iterator.next().toString()));
        }
        return stringBuffer.toString();
    }

    private Iterator getUserAndGroupsList(Alert alert, int n) {
        Object object;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; alert.getUserList() != null && n2 < alert.getUserList().size(); ++n2) {
            object = alert.getUserList().get(n2);
            ((Alert.AlertUser)object).addUserNameForMatchingCriteria(n, arrayList);
        }
        for (n2 = 0; alert.getUserGroupList() != null && n2 < alert.getUserGroupList().size(); ++n2) {
            object = (IdIdNameItem)alert.getUserGroupList().get(n2);
            if (((IdIdNameItem)object).getSecondId() != n) continue;
            arrayList.add("<b>" + ((IdIdNameItem)object).getName() + "</b>");
        }
        return arrayList.iterator();
    }

    private Iterator getExternalGroupsList(Alert alert, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; alert.getExternalGroupList() != null && i < alert.getExternalGroupList().size(); ++i) {
            IdIdNameItem idIdNameItem = (IdIdNameItem)alert.getExternalGroupList().get(i);
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add("<b>" + idIdNameItem.getName() + "</b>");
        }
        return arrayList.iterator();
    }

    private Iterator getSecurityAssociations(Alert alert, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; alert.getSecurityAssociations() != null && i < alert.getSecurityAssociations().getAssociations().size(); ++i) {
            SecurityAssociationForEntity securityAssociationForEntity = (SecurityAssociationForEntity)alert.getSecurityAssociations().getAssociations().get(i);
            String string = "";
            String string2 = string = securityAssociationForEntity.getProperties().getRole(false) == null ? CteStringBank.Custom_Role.getI18n() : securityAssociationForEntity.getProperties().getRole(false).getRoleName();
            if (string.equals(CteStringBank.Custom_Role.getI18n())) {
                StringBuilder stringBuilder = new StringBuilder();
                if (securityAssociationForEntity.getProperties(false) != null && securityAssociationForEntity.getProperties().getCategoryPermission(false) != null && securityAssociationForEntity.getProperties().getCategoryPermission().getCategoriesPermissionList(false) != null) {
                    for (GenericEntity genericEntity : securityAssociationForEntity.getProperties().getCategoryPermission().getCategoriesPermissionList()) {
                        if (genericEntity.get_type_(false) != null && genericEntity.get_type_().equals((Object)EntityType.CATEGORY_ENTITY)) {
                            stringBuilder.append(genericEntity.getCategoryName());
                            stringBuilder.append(",");
                            continue;
                        }
                        if (genericEntity.get_type_(false) == null || !genericEntity.get_type_().equals((Object)EntityType.PERMISSION_ENTITY)) continue;
                        stringBuilder.append(genericEntity.getPermissionName());
                        stringBuilder.append(",");
                    }
                }
                if (!stringBuilder.toString().isEmpty() && stringBuilder.toString().endsWith(",")) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                string = stringBuilder.toString();
            }
            if (((GenericEntity)securityAssociationForEntity.getUserOrGroup().get(0)).get_type_() == EntityType.USER_ENTITY) {
                if (!bl) continue;
                arrayList.add(((GenericEntity)securityAssociationForEntity.getUserOrGroup().get(0)).getUserName() + " - " + string);
                continue;
            }
            if (bl) continue;
            arrayList2.add(((GenericEntity)securityAssociationForEntity.getUserOrGroup().get(0)).getUserGroupName() + " - " + string);
        }
        if (bl) {
            return arrayList.iterator();
        }
        return arrayList2.iterator();
    }

    private Iterator getNonGalaxyUsersList(Alert alert, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; alert.getNonGalaxyUserList() != null && i < alert.getNonGalaxyUserList().size(); ++i) {
            IdIdNameItem idIdNameItem = alert.getNonGalaxyUserList().get(i);
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(idIdNameItem.getName());
        }
        return arrayList.iterator();
    }

    private Iterator getNonGalaxyUsersListCc(Alert alert, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; alert.getNonGalaxyUserListCc() != null && i < alert.getNonGalaxyUserListCc().size(); ++i) {
            IdIdNameItem idIdNameItem = alert.getNonGalaxyUserListCc().get(i);
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(idIdNameItem.getName());
        }
        return arrayList.iterator();
    }

    private Iterator getNonGalaxyUsersListBcc(Alert alert, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; alert.getNonGalaxyUserListBcc() != null && i < alert.getNonGalaxyUserListBcc().size(); ++i) {
            IdIdNameItem idIdNameItem = alert.getNonGalaxyUserListBcc().get(i);
            if (idIdNameItem.getSecondId() != n) continue;
            arrayList.add(idIdNameItem.getName());
        }
        return arrayList.iterator();
    }

    private Iterator getNotificationTypes(Alert alert, int n, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < AlertConstants.TABNAMES.length; ++i) {
            int n2;
            int n3 = n2 = n == 1 ? alert.getAlertDetails().getNotifType() : alert.getAlertDetails().getEscNotifType();
            if ((n2 & (int)Math.pow(2.0, i)) <= 0) continue;
            String string = AlertConstants.TABNAMES[i];
            if (string.equals(AlertConstants.EMAIL) && (n2 & 0x40000) > 0) {
                string = string.concat("(" + AlertConstants.NT_ACTION + ")");
            }
            if (string.equals(AlertConstants.LIVEFEEDS) && (n2 & 0x80000) > 0) {
                string = string.concat("(" + AlertConstants.NT_ACTION + ")");
            }
            if (string.equals(AlertConstants.ZERO) || AlertConstants.TABNAMES[i] == AlertConstants.NT_ACTION) continue;
            arrayList.add(string);
        }
        if (bl && alert.getRunCommand(n).isRunDataArchiver()) {
            arrayList.add(AlertConstants.RUN_DATA_ARCHIVER);
        }
        return arrayList.iterator();
    }

    private Map getAlertConfigsMap(Alert alert, int n) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (alert.getAlertDetails().getAlertCategory().getId() == 7) {
            linkedHashMap.put(CteStringBank.Action_Types.getI18n(), this.getString(this.getNotificationTypes(alert, n, true)));
        } else {
            linkedHashMap.put(NOTIFICATION_TYPE, this.getString(this.getNotificationTypes(alert, n, false)));
        }
        linkedHashMap.put(REPORTING_CRITERIA, this.getString(this.getReportingCriteria(n, alert)));
        if ((alert.getAlertDetails().getStatus() & 0x80) > 0) {
            linkedHashMap.put(CteStringBank.User_and_UserGroupsTo.getI18n(), null);
            linkedHashMap.put(CteStringBank.User_and_UserGroupsCc.getI18n(), null);
            linkedHashMap.put(CteStringBank.User_and_UserGroupsBcc.getI18n(), null);
        } else {
            linkedHashMap.put(CteStringBank.User_and_UserGroupsTo.getI18n(), this.getString(this.getUserAndGroupsForSummary(alert.getToUsersList(n))));
            linkedHashMap.put(CteStringBank.User_and_UserGroupsCc.getI18n(), this.getString(this.getUserAndGroupsForSummary(alert.getCcUsersList(n))));
            linkedHashMap.put(CteStringBank.User_and_UserGroupsBcc.getI18n(), this.getString(this.getUserAndGroupsForSummary(alert.getBccUsersList(n))));
        }
        linkedHashMap.put(NON_GALAXY_USERS_TO, this.getString(this.getNonGalaxyUsersList(alert, n)));
        linkedHashMap.put(NON_GALAXY_USERS_CC, this.getString(this.getNonGalaxyUsersListCc(alert, n)));
        linkedHashMap.put(NON_GALAXY_USERS_BCC, this.getString(this.getNonGalaxyUsersListBcc(alert, n)));
        if (((String)linkedHashMap.get(NOTIFICATION_TYPE)).contains(AlertConstants.EMAIL)) {
            linkedHashMap.put(CteStringBank.Sender_Display_Name.getI18n(), alert.getSenderDisplayName());
            linkedHashMap.put(CteStringBank.Sender_Email_Id.getI18n(), alert.getSenderEmailId());
        }
        linkedHashMap.put(FEED_LOCATION, this.getString(this.getFeedLocation(alert, n)));
        if ((alert.getAlertType().getActionsAllowed() & 0x10) != 0) {
            String string = this.getString(this.getAppTypeFilter(alert).iterator());
            if (string == null || string.length() == 0) {
                string = "All Agents";
            }
            linkedHashMap.put(APP_TYPE_FILTER, string);
        }
        return linkedHashMap;
    }

    private ArrayList<String> getAppTypeFilter(Alert alert) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<GenericEntity> list = alert.getAppTypeFilter();
        if (list != null) {
            for (GenericEntity genericEntity : list) {
                if (genericEntity.getAppName(false) != null) {
                    arrayList.add(genericEntity.getAppName());
                    continue;
                }
                arrayList.add(SummaryWriter.getAppGroupName(genericEntity.getAppGroupId()));
            }
        }
        return arrayList;
    }

    public static String getAppGroupName(int n) {
        switch (n) {
            case 1: {
                return "Protected Files";
            }
            case 2: {
                return "Archived Documents";
            }
            case 3: {
                return "Protected Documents";
            }
            case 5: {
                return "Archived Files";
            }
            case 6: {
                return "Protected Mail";
            }
            case 7: {
                return "Archived Mail";
            }
            case 8: {
                return "Journaled Mail";
            }
            case 10: {
                return "Oracle";
            }
            case 11: {
                return "DB2";
            }
            case 12: {
                return "Notes DB";
            }
            case 13: {
                return "Sybase";
            }
            case 14: {
                return "Exchange DB";
            }
            case 22: {
                return "Windows File System";
            }
            case 67: {
                return "Domino Mailbox Archiver";
            }
            case 68: {
                return "Notes Document";
            }
            case 83: {
                return "GroupWise DB";
            }
            case 90: {
                return "SQL Server";
            }
            case 100: {
                return "MySQL";
            }
            case 101: {
                return "SAP for Oracle";
            }
            case 104: {
                return "Notes DB (Transaction Log Subclients)";
            }
            case 111: {
                return "Informix";
            }
            case 114: {
                return "PostgreSQL";
            }
            case 115: {
                return "Documentum";
            }
            case 129: {
                return "Sap Hana";
            }
            case 134: {
                return "Big Data Apps";
            }
            case 135: {
                return "Cloud Apps";
            }
        }
        return "";
    }

    private boolean isOptionSelected(int n, int n2) {
        return (n & n2) > 0;
    }

    private Object[] getTime(int n) {
        int n2 = n / 60;
        int n3 = n2 / 60;
        Object[] objectArray = new Object[]{Integer.toString(n3), Integer.toString(n2 -= n3 * 60)};
        return objectArray;
    }

    private Iterator getFeedLocation(Alert alert, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = alert.getNotifMsgs();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            AlertNotifMsg alertNotifMsg = (AlertNotifMsg)listIterator.next();
            if (alertNotifMsg.getNotifType() != 1024 || alertNotifMsg.getEsclationLevel() != n) continue;
            arrayList.add(alertNotifMsg.getFeed().getBaseLocation() + "/" + alertNotifMsg.getFeed().getSelectedChannel());
        }
        return arrayList.iterator();
    }

    private Iterator getReportingCriteria(int n, Alert alert) {
        ReportingCriteria reportingCriteria = alert.getReportingCriteria(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (reportingCriteria == null) {
            return arrayList.iterator();
        }
        int n2 = reportingCriteria.getReportingOptions();
        if (this.isOptionSelected(n2, 1)) {
            arrayList.add(CteStringBank.Immediate_Notification.getI18n());
        }
        if (this.isOptionSelected(n2, 16)) {
            arrayList.add(CteStringBank.Notify_if_job_has_extended_retention.getI18n());
        }
        if (this.isOptionSelected(n2, 32)) {
            arrayList.add(CteStringBank.Notify_only_when_job_contains_failed_objects.getI18n());
        }
        if (this.isOptionSelected(n2, 8)) {
            arrayList.add(MessageFormat.format(CteStringBank.commvault_cte_component_AlertNotifCriteriaPage_key20.getI18n(), this.getTime(reportingCriteria.getDelayTimeSeconds())));
        }
        if (this.isOptionSelected(n2, 256)) {
            arrayList.add(MessageFormat.format(CteStringBank.commvault_cte_component_AlertNotifCriteriaPage_key22.getI18n(), this.getTime(reportingCriteria.getDelayTimeSeconds())));
        }
        if (this.isOptionSelected(n2, 2)) {
            if (alert.getAlertDetails().getAlertType().getId() == 58) {
                arrayList.add(MessageFormat.format(CteStringBank.Suppress_notification_for_matching_events.getI18n(), this.getTime(reportingCriteria.getPersistTimeSeconds())));
            } else {
                arrayList.add(MessageFormat.format(CteStringBank.commvault_cte_component_AlertNotifCriteriaPage_key21.getI18n(), this.getTime(reportingCriteria.getPersistTimeSeconds())));
            }
        }
        if (this.isOptionSelected(n2, 4)) {
            arrayList.add(CteStringBank.Notification_when_condition_clears.getI18n());
        }
        if (this.isOptionSelected(n2, 128)) {
            arrayList.add(CteStringBank.Notify_DDB_Job.getI18n());
        }
        if (alert.getMinJobCountForJobAnomaly() > 0) {
            arrayList.add(MessageFormat.format(CteStringBank.Notify_When_Job_Count_Is_More_Than_n.getI18n(), alert.getMinJobCountForJobAnomaly()));
        }
        return arrayList.iterator();
    }

    public String modifyString(String string) {
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private Iterator getUserAndGroupsForSummary(List<IdIdNameItem> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IdIdNameItem idIdNameItem : list) {
            if (idIdNameItem.getSecondId() == 1 || idIdNameItem.getSecondId() == 3) {
                arrayList.add(idIdNameItem.getName());
                continue;
            }
            if (idIdNameItem.getSecondId() != 2 && idIdNameItem.getSecondId() != 4) continue;
            arrayList.add("<b>" + idIdNameItem.getName() + "</b>");
        }
        return arrayList.iterator();
    }
}

