/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.upgraderequest;

import commvault.web.cloudreq.CloudRequest;
import commvault.web.cloudreq.CloudRequestType;
import commvault.web.core.config.ConfigProperties;
import commvault.web.core.util.CVCoreUtil;
import commvault.web.creconn.QueryExecutor;
import commvault.web.creconn.QueryExecutorImpl;
import commvault.web.creconn.StoredProcedure;
import commvault.web.creconn.db.CloudServicesDBSPOpReq;
import commvault.web.creconn.model.RowMap;
import commvault.web.upgraderequest.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@WebServlet(value={"/handleUpload.do"})
public class UploadHandler
extends HttpServlet {
    @Inject
    private ConfigProperties configProps;
    private static Logger logger = LogManager.getLogger((String)"commvault.web");
    private static QueryExecutor executor = CVCoreUtil.lookup(QueryExecutorImpl.class);

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doIt(httpServletRequest, httpServletResponse);
    }

    private void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        block17: {
            PrintWriter printWriter = httpServletResponse.getWriter();
            try {
                String string14;
                String string2;
                String string3;
                Object object;
                logger.trace((Object)"Reading Config Properties.");
                String string4 = this.configProps.getDwonloadLocation();
                String string5 = this.configProps.getSMTPHost();
                Object object2 = null;
                boolean bl = ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest);
                if (!bl) break block17;
                ServletContext servletContext = httpServletRequest.getSession().getServletContext();
                File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory(10240, file);
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
                List list = servletFileUpload.parseRequest(httpServletRequest);
                Iterator iterator = list.iterator();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (iterator.hasNext()) {
                    object = (FileItem)iterator.next();
                    if (object.isFormField()) {
                        string3 = object.getFieldName();
                        string2 = object.getString();
                        hashMap.put(string3, string2);
                        continue;
                    }
                    string3 = object.getFieldName();
                    string2 = object.getName();
                    hashMap.put(string3, string2);
                    object2 = object;
                }
                object = (String)hashMap.get("answer");
                if (Integer.parseInt(((String)object).trim()) != (Integer)httpServletRequest.getSession().getAttribute("captcha")) {
                    httpServletResponse.addHeader("success", "false");
                    this.handleError(printWriter, httpServletResponse, "Invalid captcha value. Please try again.");
                    return;
                }
                if (hashMap.get("file") == null || hashMap.get("firstname") == null || hashMap.get("lastname") == null || hashMap.get("primary_email") == null || hashMap.get("commcell_id") == null || hashMap.get("request_type") == null) {
                    this.handleError(printWriter, httpServletResponse, "First Name, Last Name, Primary Email and Commcell ID are mandatory fields.");
                    return;
                }
                string3 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("firstname")).toString());
                string2 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("lastname")).toString());
                String string6 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("commcell_id")).toString());
                String string7 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("primary_email")).toString());
                String string8 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("also_notify")).toString());
                String string9 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("partner_email_id")).toString());
                String string10 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("features_enabled")).toString());
                String string11 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("request_type")).toString());
                String string12 = StringEscapeUtils.escapeSql((String)((String)hashMap.get("comments")).toString());
                if (string9.length() == 0) {
                    string9 = "NULL";
                }
                if (string12.length() == 0) {
                    string12 = "NULL";
                }
                logger.info((Object)("Storing the following details into the DB:First Name:" + string3 + ";" + "Last Name:" + string2 + ";" + "CommCell ID:" + string6 + ";" + "Contact Email:" + string7 + "," + string8 + ";" + "Partner Email:" + string9 + ";" + "Features to Enable:" + string10 + ";" + "Comments:" + string12 + ";" + "Upgrade type:" + string11));
                CloudRequest cloudRequest = new CloudRequest();
                cloudRequest.setComments(string12);
                cloudRequest.setCompany(string6);
                cloudRequest.setFirstName(string3);
                cloudRequest.setLastName(string2);
                cloudRequest.setNotifyEmails(string7 + (string8.length() > 0 ? "," + string8 : ""));
                cloudRequest.setRequestTypeId(CloudRequestType.ExpressDBUpgradeV11);
                cloudRequest = UploadHandler.createUpgradeReq(cloudRequest);
                logger.info((Object)("Storing additional details to RequestsData table for request id " + cloudRequest.getRequestId()));
                UploadHandler.updateCloudReqData(cloudRequest, "FeaturesToEnable", string10);
                UploadHandler.updateCloudReqData(cloudRequest, "PartnerEmail", string9);
                UploadHandler.updateCloudReqData(cloudRequest, "UpgradeType", string11);
                UploadHandler.updateCloudReqData(cloudRequest, "UpgradeComments", string12);
                int n = cloudRequest.getRequestId();
                int n2 = cloudRequest.getErrorCode();
                logger.trace((Object)("created cloud request : " + n));
                if (n <= 0) {
                    this.handleError(printWriter, httpServletResponse, "Unable to create request, please talk to admin.");
                    return;
                }
                Object object3 = new File(string4, "" + n);
                ((File)object3).mkdir();
                logger.trace((Object)("created folder :" + ((File)object3).getAbsolutePath()));
                Object object4 = new File(((File)object3).getAbsolutePath() + "\\" + new File((String)hashMap.get("file")).getName());
                object2.write((File)object4);
                logger.trace((Object)("created File : " + object2.getName()));
                logger.trace((Object)"generating mail content.");
                object3 = Util.getMailText(n2, n, string6, httpServletRequest.getSession().getServletContext(), true, string3);
                httpServletRequest.getSession().setAttribute("Response", object3);
                object4 = ((String)hashMap.get("primary_email")).toString();
                String string13 = ((String)hashMap.get("also_notify")).toString();
                if (string13 != null) {
                    string13 = string13.replaceAll(";", ",");
                }
                String[] stringArray = string13.split(",");
                InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
                int n3 = 0;
                if (stringArray[0].length() > 0) {
                    for (String string14 : stringArray) {
                        if (string14.length() <= 0) continue;
                        internetAddressArray[n3] = new InternetAddress(string14);
                        ++n3;
                    }
                }
                String string15 = "YourUpgradeAdvisor@commvault.com";
                String string16 = string5;
                Properties properties = System.getProperties();
                properties.setProperty("mail.smtp.host", string16);
                string14 = Session.getDefaultInstance((Properties)properties);
                try {
                    MimeMessage messagingException = new MimeMessage((Session)string14);
                    MimeMultipart mimeMultipart = new MimeMultipart("related");
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    messagingException.setFrom((Address)new InternetAddress(string15));
                    messagingException.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress((String)object4));
                    messagingException.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("AutomatedCloudEmails@commvault.com"));
                    if (n3 > 0) {
                        messagingException.addRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
                    }
                    if (n > 1) {
                        messagingException.setSubject("Upgrade request for commcell [" + (String)hashMap.get("commcell_id") + "] has been received! [Request ID " + n + "]");
                    } else {
                        messagingException.setSubject("Upgrade request for commcell [" + (String)hashMap.get("commcell_id") + "] could not be processed");
                    }
                    mimeBodyPart.setContent(object3, "text/html");
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                    mimeBodyPart = new MimeBodyPart();
                    FileDataSource fileDataSource = new FileDataSource(httpServletRequest.getSession().getServletContext().getRealPath("/") + "\\upgraderequest\\images\\Cloud_Email.png");
                    mimeBodyPart.setDataHandler(new DataHandler(fileDataSource));
                    mimeBodyPart.setHeader("Content-ID", "<Cloud_Email>");
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                    messagingException.setContent((Multipart)mimeMultipart);
                    Transport.send((Message)messagingException);
                    logger.trace((Object)"mail sent sucessfully. ");
                }
                catch (MessagingException messagingException) {
                    messagingException.printStackTrace();
                }
                httpServletResponse.addHeader("success", "true");
                httpServletResponse.addHeader("errCode", String.valueOf(n2));
                httpServletResponse.addHeader("reqId", String.valueOf(n));
                httpServletResponse.addHeader("commcellId", String.valueOf(string6));
                httpServletResponse.addHeader("username", String.valueOf(string3));
                printWriter.println("Your upload was successful.<br/> You will receive an e-mail with the acknowledgement.<br/></h4>");
            }
            catch (Exception exception) {
                logger.debug((Object)exception.toString());
                this.handleError(printWriter, httpServletResponse, "Something went wrong. Please try again. If problem persists contact clouddbupgrade@commvault.com");
            }
        }
    }

    private void handleError(PrintWriter printWriter, HttpServletResponse httpServletResponse, String string) {
        httpServletResponse.addHeader("success", "false");
        printWriter.println(string);
    }

    private static CloudRequest createUpgradeReq(CloudRequest cloudRequest) {
        try {
            CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.CreateCloudRequest);
            cloudServicesDBSPOpReq.addParam(CloudRequestType.ExpressDBUpgradeV11.getValue()).addParam(cloudRequest.getCompany()).addParam(cloudRequest.getNotifyEmails()).addParamOrNull(cloudRequest.getUserName()).addParam(cloudRequest.getFirstName()).addParam(cloudRequest.getLastName());
            executor.executeOperation(cloudServicesDBSPOpReq);
            Iterator<RowMap> iterator = executor.iterator();
            while (iterator.hasNext()) {
                RowMap rowMap = iterator.next();
                cloudRequest.setRequestId(rowMap.getInt("RequestId"));
                cloudRequest.setErrorCode(rowMap.getInt("ErrorCode"));
                cloudRequest.setErrorString(rowMap.getString("ErrorStr"));
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Exception while creating cloud request", (Throwable)exception);
        }
        return cloudRequest;
    }

    private static boolean updateCloudReqData(CloudRequest cloudRequest, String string, String string2) throws SQLException {
        try {
            CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.UpdateCloudRequestData);
            cloudServicesDBSPOpReq.addParam(cloudRequest.getRequestId()).addParam(string).addParamOrNull(string2);
            executor.executeOperation(cloudServicesDBSPOpReq);
            Iterator<RowMap> iterator = executor.iterator();
            while (iterator.hasNext()) {
                RowMap rowMap = iterator.next();
                cloudRequest.setErrorCode(rowMap.getInt("ErrorCode"));
                cloudRequest.setErrorString(rowMap.getString("ErrorStr"));
            }
            if (cloudRequest.getErrorCode() == 0) {
                return true;
            }
            logger.error((Object)("Unable to add " + string + ", ErrorCode: " + cloudRequest.getErrorCode() + ", Error: " + cloudRequest.getErrorString()));
        }
        catch (Exception exception) {
            logger.error((Object)"Exception while creating cloud request", (Throwable)exception);
        }
        return true;
    }
}

