/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.registerappliance;

import commvault.web.core.util.CVCoreUtil;
import commvault.web.creconn.QueryExecutor;
import commvault.web.creconn.QueryExecutorImpl;
import commvault.web.creconn.StoredProcedure;
import commvault.web.creconn.db.CloudServicesDBSPOpReq;
import commvault.web.creconn.dto.ReportDataResponse;
import commvault.web.registerappliance.SalesInfo;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebServlet(value={"/UpdateApplianceInfoHandler.do"})
public class UpdateApplianceInfoHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(UpdateApplianceInfoHandler.class);
    private QueryExecutor executor = CVCoreUtil.lookup(QueryExecutorImpl.class);

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendRedirect("/registerappliance/methodNotSupported.jsp");
    }

    private String buildXml(SalesInfo salesInfo) {
        String string = null;
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ROOT");
            document.appendChild(element);
            Element element2 = document.createElement("SALESINFO");
            element.appendChild(element2);
            element2.setAttribute("salesorder", salesInfo.getSalesorder());
            element2.setAttribute("vendor", String.valueOf(salesInfo.getVendorId()));
            element2.setAttribute("companyname", salesInfo.getCompanyname());
            element2.setAttribute("companyaddr", salesInfo.getCompanyaddr());
            element2.setAttribute("companycity", salesInfo.getCompanycity());
            element2.setAttribute("companypostal", salesInfo.getCompanypostal());
            element2.setAttribute("companycountry", salesInfo.getCompanycountry());
            for (int i = 0; i < salesInfo.appSeInfo.length; ++i) {
                object = document.createElement("APPSEINFO");
                element.appendChild((Node)object);
                object.setAttribute("senumber", salesInfo.appSeInfo[i].getSenumber());
                object.setAttribute("capacity", salesInfo.appSeInfo[i].getCapacity());
                object.setAttribute("controllerse", salesInfo.appSeInfo[i].getControllerse());
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object = transformerFactory.newTransformer();
            ((Transformer)object).setOutputProperty("omit-xml-declaration", "yes");
            ((Transformer)object).setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            ((Transformer)object).transform(dOMSource, streamResult);
            string = stringWriter.toString();
            logger.info((Object)("XML: " + string));
        }
        catch (Exception exception) {
            string = null;
            logger.error((Object)"Exception while creating xml");
        }
        return string;
    }

    private int writeXmlToDb(String string) {
        int n = -1;
        CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.saveApplianceInfo);
        cloudServicesDBSPOpReq.addParam(string);
        try {
            ReportDataResponse reportDataResponse = this.executor.executeOperation(cloudServicesDBSPOpReq);
            n = Integer.getInteger(reportDataResponse.getOutput());
        }
        catch (Exception exception) {
            n = -1;
            logger.error((Object)"Error while connection to CRE MEtric DB", (Throwable)exception);
        }
        return n;
    }
}

