/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.registerappliance;

import commvault.web.core.filter.RequestContext;
import commvault.web.core.msg.ClientResp;
import commvault.web.core.msg.IdName;
import commvault.web.core.util.CVCoreUtil;
import commvault.web.creconn.QueryExecutor;
import commvault.web.creconn.QueryExecutorImpl;
import commvault.web.creconn.StoredProcedure;
import commvault.web.creconn.db.CloudServicesDBSPOpReq;
import commvault.web.creconn.exception.MetricsException;
import commvault.web.creconn.model.RowMap;
import commvault.web.registerappliance.ApplianceDetails;
import commvault.web.registerappliance.ApplianceUserDetails;
import commvault.web.registerappliance.Constants;
import commvault.web.registerappliance.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebServlet(urlPatterns={"/checkapplianceserial.do", "/saveapplianceinfo.do", "/saveappliancecompanyinfo.do", "/appliancergistration.do", "/closeapplianceusersession.do", "/getcountries.do"})
public class ApplianceHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_COMMCELL_ID = "FFFFF";
    private static final String DEFAULT_COMMCELL_IP = "255.255.255.255";
    private static final Logger logger = Logger.getLogger(ApplianceHandler.class);
    private QueryExecutor executor = CVCoreUtil.lookup(QueryExecutorImpl.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("application/json; charset=UTF-8");
        if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/getcountries.do")) {
            this.getCountries();
        } else {
            httpServletResponse.sendRedirect("/MethodNotSupported.jsp");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("application/json; charset=UTF-8");
        if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/checkapplianceserial.do")) {
            this.handleSerialCheck();
        } else if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/saveapplianceinfo.do")) {
            this.saveApplianceInfoInSession();
        } else if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/saveappliancecompanyinfo.do")) {
            this.saveApplianceCompanyInfoInSession();
        } else if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/appliancergistration.do")) {
            this.handleRegistration();
        } else if (httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length()).equalsIgnoreCase("/closeapplianceusersession.do")) {
            this.closeSession();
        } else {
            httpServletResponse.sendRedirect("/MethodNotSupported.jsp");
        }
    }

    private void closeSession() throws IOException {
        int n = 0;
        String string = "";
        String string2 = "";
        HttpSession httpSession = RequestContext.getRequest().getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        String string3 = "/registerappliance/fujitsu/index.jsp";
        string2 = "\"nextpage\": \"" + string3 + "\"";
        RequestContext.getResponse().getWriter().write("{\"code\": " + n + ", \"msg\": \"" + string + "\", \"data\": {" + string2 + "}}");
    }

    private void saveApplianceCompanyInfoInSession() throws IOException {
        String string = RequestContext.getRequest().getParameter("companyname");
        HttpServletRequest httpServletRequest = RequestContext.getRequest();
        String string2 = httpServletRequest.getParameter("companyaddr");
        String string3 = httpServletRequest.getParameter("companycity");
        String string4 = httpServletRequest.getParameter("companystate");
        String string5 = httpServletRequest.getParameter("companypostal");
        String string6 = httpServletRequest.getParameter("companycountry");
        int n = 0;
        String string7 = "";
        String string8 = "";
        ApplianceUserDetails applianceUserDetails = (ApplianceUserDetails)httpServletRequest.getSession().getAttribute("APPLIANCE_USER");
        if (applianceUserDetails == null) {
            applianceUserDetails = new ApplianceUserDetails();
        }
        if (string != null && !string.isEmpty()) {
            applianceUserDetails.setCompanyname(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            applianceUserDetails.setAddress(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            applianceUserDetails.setCity(string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            applianceUserDetails.setState(string4);
        }
        if (string5 != null && !string5.isEmpty()) {
            applianceUserDetails.setPostalcode(string5);
        }
        if (string6 != null && !string6.isEmpty()) {
            applianceUserDetails.setCountry(string6);
        }
        httpServletRequest.getSession().setAttribute("APPLIANCE_USER", (Object)applianceUserDetails);
        String string9 = "/registerappliance/fujitsu/ContactInfo.jsp";
        string8 = "\"nextpage\": \"" + string9 + "\"";
        RequestContext.getResponse().getWriter().write("{\"code\": " + n + ", \"msg\": \"" + string7 + "\", \"data\": {" + string8 + "}}");
    }

    private void saveApplianceInfoInSession() throws IOException {
        HttpServletRequest httpServletRequest = RequestContext.getRequest();
        String[] stringArray = httpServletRequest.getParameterValues("applianceserial[]");
        String[] stringArray2 = httpServletRequest.getParameterValues("commcells[]");
        String[] stringArray3 = httpServletRequest.getParameterValues("ips[]");
        String[] stringArray4 = httpServletRequest.getParameterValues("serials[]");
        String[] stringArray5 = httpServletRequest.getParameterValues("regcodes[]");
        int n = 0;
        String string = "";
        String string2 = "";
        if (stringArray.length == stringArray2.length && stringArray.length == stringArray3.length) {
            ArrayList<ApplianceDetails> arrayList = (ArrayList<ApplianceDetails>)httpServletRequest.getSession().getAttribute("APPLIANCE_DETAILS");
            if (arrayList == null) {
                arrayList = new ArrayList<ApplianceDetails>();
            }
            ArrayList<ApplianceDetails> arrayList2 = new ArrayList<ApplianceDetails>();
            for (int i = 0; i < stringArray.length; ++i) {
                ApplianceDetails applianceDetails = this.findSerialsInList(arrayList, stringArray[i]);
                if (applianceDetails == null) {
                    applianceDetails = new ApplianceDetails();
                }
                applianceDetails.setSerailnumber(stringArray[i]);
                if (applianceDetails.getCommcellid() == null || applianceDetails.getCommcellid().isEmpty()) {
                    applianceDetails.setCommcellid(stringArray2[i].toUpperCase());
                }
                if (applianceDetails.getCommcellip() == null || applianceDetails.getCommcellip().isEmpty()) {
                    applianceDetails.setCommcellip(stringArray3[i]);
                }
                if (applianceDetails.getCommcellserial() == null || applianceDetails.getCommcellserial().isEmpty()) {
                    applianceDetails.setCommcellserial(stringArray4[i]);
                }
                if (applianceDetails.getCommcellregcode() == null || applianceDetails.getCommcellregcode().isEmpty()) {
                    applianceDetails.setCommcellregcode(stringArray5[i]);
                }
                arrayList2.add(applianceDetails);
            }
            RequestContext.getRequest().getSession().setAttribute("APPLIANCE_DETAILS", arrayList2);
            String string3 = "/registerappliance/fujitsu/CompanyInfo.jsp";
            string2 = "\"nextpage\": \"" + string3 + "\"";
        } else {
            n = 4;
            string = "Length mismatch, please verify inputs.";
        }
        RequestContext.getResponse().getWriter().write("{\"code\": " + n + ", \"msg\": \"" + string + "\", \"data\": {" + string2 + "}}");
    }

    private void handleRegistration() throws IOException {
        HttpServletRequest httpServletRequest = RequestContext.getRequest();
        String string = httpServletRequest.getParameter("firstname");
        String string2 = httpServletRequest.getParameter("lastname");
        String string3 = httpServletRequest.getParameter("companyemail");
        String string4 = httpServletRequest.getParameter("phonenumber");
        int n = 0;
        String string5 = "";
        String string6 = "";
        String string7 = "/registerappliance/fujitsu/CompanyInfo.jsp";
        ApplianceUserDetails applianceUserDetails = (ApplianceUserDetails)httpServletRequest.getSession().getAttribute("APPLIANCE_USER");
        if (applianceUserDetails == null) {
            n = Constants.SHOW_USER_ERROR_CODE;
            string5 = "There is no details about your commpany, you will be redirected to commpany details page.";
        } else {
            if (string != null && !string.isEmpty()) {
                applianceUserDetails.setFirstname(string);
            }
            if (string2 != null && !string2.isEmpty()) {
                applianceUserDetails.setLasname(string2);
            }
            if (string3 != null && !string3.isEmpty()) {
                applianceUserDetails.setEmailid(string3);
            }
            if (string4 != null && !string4.isEmpty()) {
                applianceUserDetails.setPhonenumber(string4);
            }
            httpServletRequest.getSession().setAttribute("APPLIANCE_USER", (Object)applianceUserDetails);
            try {
                n = this.saveDataInDB();
                if (n == 1) {
                    n = 5;
                    string5 = "Either you have skipped some pages and came to this page directly.";
                }
                if (n == 0) {
                    Object object;
                    Object object2;
                    Object object3;
                    String string8;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("SalesOrder: " + (String)httpServletRequest.getSession().getAttribute("APP_SALES_ORDER"));
                    arrayList.add("First Name: " + applianceUserDetails.getFirstname() + "<br>Last Name: " + applianceUserDetails.getLasname() + "<br>Email: " + applianceUserDetails.getEmailid() + "<br>Phone: " + applianceUserDetails.getPhonenumber());
                    arrayList.add("Company Name: " + applianceUserDetails.getCompanyname() + "<br>Street Address: " + applianceUserDetails.getAddress() + "<br>Postal code: " + applianceUserDetails.getPostalcode() + "<br>Country: " + applianceUserDetails.getCountry());
                    ArrayList arrayList2 = (ArrayList)httpServletRequest.getSession().getAttribute("APPLIANCE_DETAILS");
                    int n2 = 0;
                    int n3 = 0;
                    boolean bl = false;
                    String[] stringArray = new String[arrayList2.size()];
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        bl = false;
                        Object object4 = (ApplianceDetails)arrayList2.get(i);
                        string8 = ((ApplianceDetails)object4).getCommcellid().toUpperCase() + "_" + ((ApplianceDetails)object4).getCommcellip();
                        if (((ApplianceDetails)object4).getCommcellid().toUpperCase().startsWith(DEFAULT_COMMCELL_ID) || ((ApplianceDetails)object4).getCommcellip().trim().equalsIgnoreCase(DEFAULT_COMMCELL_IP)) {
                            bl = true;
                        }
                        if (Utils.searchStringArray(stringArray, string8, false)) {
                            object3 = (String)hashMap.get(string8);
                            object3 = ((String)object3).replaceAll("\\{\\#s\\#\\}", ", " + ((ApplianceDetails)object4).getSerailnumber() + "{#s#}");
                            object3 = ((String)object3).replaceAll("\\{\\#t\\#\\}", " + " + ((ApplianceDetails)object4).getCapacity() + "{#t#}");
                            object3 = ((String)object3).replaceAll("\\{\\#sws\\#\\}", ", " + ((ApplianceDetails)object4).getCommcellserial() + "{#sws#}");
                            object3 = ((String)object3).replaceAll("\\{\\#regc\\#\\}", " , " + ((ApplianceDetails)object4).getCommcellregcode() + "{#regc#}");
                            object2 = Pattern.compile("\\{\\#TCV\\[(.*?)\\]\\#\\}");
                            object = ((Pattern)object2).matcher((CharSequence)object3);
                            while (((Matcher)object).find()) {
                                String string9 = ((Matcher)object).group(1);
                                int n4 = Integer.parseInt(string9) + Integer.parseInt(((ApplianceDetails)object4).getCapacity());
                                object3 = ((String)object3).replaceAll("\\{\\#TCV\\[" + Integer.parseInt(string9) + "\\]\\#\\}", "{#TCV[" + n4 + "]#}");
                            }
                            object3 = ((String)object3).replaceAll("\\{\\#one\\#\\}", "");
                            hashMap.put(string8, object3);
                            continue;
                        }
                        if (bl) {
                            ++n3;
                        } else {
                            ++n2;
                        }
                        stringArray[i] = string8;
                        object3 = "CommcellID: " + ((ApplianceDetails)object4).getCommcellid() + " having IP address: " + ((ApplianceDetails)object4).getCommcellip() + "<br>";
                        if (bl) {
                            object3 = "New Commcell #" + n3 + " <br>";
                        }
                        object3 = (String)object3 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {#line#}<br>";
                        object3 = ((String)object3).replaceAll("\\{\\#line\\#\\}", "Serial numbers: " + ((ApplianceDetails)object4).getSerailnumber() + "{#s#}");
                        object3 = (String)object3 + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {#line#}";
                        object3 = ((String)object3).replaceAll("\\{\\#line\\#\\}", "Total capacity in TB = " + ((ApplianceDetails)object4).getCapacity() + "{#t#}" + "{#TCV[" + ((ApplianceDetails)object4).getCapacity() + "]#}{#one#}");
                        if (bl) {
                            object3 = (String)object3 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {#line#}";
                            object3 = ((String)object3).replaceAll("\\{\\#line\\#\\}", "IP address: " + ((ApplianceDetails)object4).getCommcellip());
                        }
                        object3 = (String)object3 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {#line#}";
                        object3 = ((String)object3).replaceAll("\\{\\#line\\#\\}", "Software Serial No: " + ((ApplianceDetails)object4).getCommcellserial() + "{#sws#}");
                        object3 = (String)object3 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {#line#}";
                        object3 = ((String)object3).replaceAll("\\{\\#line\\#\\}", "Software Registration Code: " + ((ApplianceDetails)object4).getCommcellregcode() + "{#regc#}");
                        hashMap.put(string8, object3);
                    }
                    arrayList.add("Total # of Appliances: " + arrayList2.size() + "<br>Total # of Commcells: " + (n2 + n3));
                    for (Object object4 : hashMap.keySet()) {
                        string8 = (String)hashMap.get(object4);
                        if (string8.contains("{#one#}")) {
                            string8 = string8.replaceAll("\\{\\#one\\#\\}", "");
                            string8 = string8.replaceAll("\\{\\#TCV\\[(.*?)\\]\\#\\}", "");
                        } else {
                            object3 = Pattern.compile("\\{\\#TCV\\[(.*?)\\]\\#\\}");
                            object2 = ((Pattern)object3).matcher(string8);
                            while (((Matcher)object2).find()) {
                                object = ((Matcher)object2).group(1);
                                int n5 = Integer.parseInt((String)object);
                                string8 = string8.replaceAll("\\{\\#TCV\\[" + n5 + "\\]\\#\\}", " = " + n5);
                            }
                        }
                        string8 = string8.replaceAll("\\{\\#s\\#\\}", "");
                        string8 = string8.replaceAll("\\{\\#t\\#\\}", "");
                        string8 = string8.replaceAll("\\{\\#sws\\#\\}", "");
                        string8 = string8.replaceAll("\\{\\#regc\\#\\}", "");
                        arrayList.add(string8);
                    }
                    Utils.sendMessage(null, arrayList, null, (String)httpServletRequest.getSession().getAttribute("APP_SALES_ORDER"));
                }
            }
            catch (Exception exception) {
                n = 2;
                string5 = "Exception while saving data, please try again later or contact administrator.";
            }
            string7 = "/registerappliance/fujitsu/registrationOP.jsp";
        }
        string6 = "\"nextpage\": \"" + string7 + "\"";
        RequestContext.getResponse().getWriter().write("{\"code\": " + n + ", \"msg\": \"" + string5 + "\", \"data\": {" + string6 + "}}");
    }

    private int saveDataInDB() {
        int n;
        block11: {
            n = 0;
            boolean bl = true;
            try {
                Object object;
                Object object2;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement("ROOT");
                document.appendChild(element);
                Element element2 = document.createElement("USERINFO");
                element.appendChild(element2);
                HttpServletRequest httpServletRequest = RequestContext.getRequest();
                ApplianceUserDetails applianceUserDetails = (ApplianceUserDetails)httpServletRequest.getSession().getAttribute("APPLIANCE_USER");
                if (applianceUserDetails == null) {
                    bl = false;
                    throw new RuntimeException("User object is null");
                }
                element2.setAttribute("vendortype", Integer.toString((Integer)httpServletRequest.getSession().getAttribute("VENDOR_TYPE")));
                element2.setAttribute("companyname", applianceUserDetails.getCompanyname());
                element2.setAttribute("commpanyaddress", applianceUserDetails.getAddress());
                element2.setAttribute("commpanycity", applianceUserDetails.getCity());
                element2.setAttribute("commpanypostalcode", applianceUserDetails.getPostalcode());
                element2.setAttribute("commpanystate", applianceUserDetails.getState());
                element2.setAttribute("commpanycountry", applianceUserDetails.getCountry());
                element2.setAttribute("firstname", applianceUserDetails.getFirstname());
                element2.setAttribute("lastname", applianceUserDetails.getLasname());
                element2.setAttribute("emailid", applianceUserDetails.getEmailid());
                element2.setAttribute("phonenumber", applianceUserDetails.getPhonenumber());
                List list = (List)httpServletRequest.getSession().getAttribute("APPLIANCE_DETAILS");
                if (list == null || list.size() == 0) {
                    bl = false;
                    throw new RuntimeException("Appliance object is null");
                }
                for (int i = 0; i < list.size(); ++i) {
                    object2 = (ApplianceDetails)list.get(i);
                    object = document.createElement("APPLIANCE");
                    element.appendChild((Node)object);
                    object.setAttribute("serial", ((ApplianceDetails)object2).getSerailnumber());
                    object.setAttribute("commcell", ((ApplianceDetails)object2).getCommcellid());
                    object.setAttribute("ip", ((ApplianceDetails)object2).getCommcellip());
                    object.setAttribute("swserial", ((ApplianceDetails)object2).getCommcellserial());
                    object.setAttribute("swregcode", ((ApplianceDetails)object2).getCommcellregcode());
                }
                if (bl) {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    object2 = transformerFactory.newTransformer();
                    ((Transformer)object2).setOutputProperty("omit-xml-declaration", "yes");
                    ((Transformer)object2).setOutputProperty("indent", "yes");
                    object = new DOMSource(document);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    ((Transformer)object2).transform((Source)object, streamResult);
                    logger.info((Object)("XML: " + stringWriter.toString()));
                    CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.saveApplianceInfo);
                    String string = stringWriter.toString();
                    cloudServicesDBSPOpReq.addParam(string);
                    String string2 = "";
                    try {
                        this.executor.executeOperation(cloudServicesDBSPOpReq);
                        if (this.executor.hasRecords()) {
                            RowMap rowMap = this.executor.getFirstRow();
                            int n2 = rowMap.getInt("StatusCode");
                            if (n2 != 0) {
                                n = n2 == -1 ? 2 : 4;
                                logger.error((Object)("Error while updating appliance -- code: " + rowMap.getString("StatusCode") + ", msg: " + rowMap.getString("ErrorMsg")));
                            } else {
                                string2 = rowMap.getString("ErrorMsg");
                                httpServletRequest.getSession().setAttribute("APP_SALES_ORDER", (Object)string2);
                            }
                            break block11;
                        }
                        n = -1;
                    }
                    catch (MetricsException metricsException) {
                        logger.error((Object)"Error while connection to CRE MEtric DB", (Throwable)metricsException);
                    }
                    break block11;
                }
                n = 1;
            }
            catch (Exception exception) {
                logger.error((Object)"Eaception while saving data to db", (Throwable)exception);
                n = 3;
            }
        }
        return n;
    }

    private void handleSerialCheck() throws IOException {
        HttpServletRequest httpServletRequest = RequestContext.getRequest();
        String string = httpServletRequest.getParameter("applianceserial");
        Integer n = Integer.parseInt(httpServletRequest.getParameter("vendortype"));
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        try {
            Object object;
            ArrayList<String> arrayList = (ArrayList<String>)httpServletRequest.getSession().getAttribute("APP_SERIALS");
            if (arrayList != null && !arrayList.contains(string)) {
                httpServletRequest.getSession().removeAttribute("APP_SERIALS");
                arrayList = null;
            }
            if (arrayList == null || arrayList.size() == 0) {
                arrayList = new ArrayList<String>();
                object = new ArrayList();
                CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.CheckApplianceSerial);
                cloudServicesDBSPOpReq.addParam(string).addParam(n);
                String string4 = "";
                try {
                    this.executor.executeOperation(cloudServicesDBSPOpReq);
                    if (this.executor.hasRecords()) {
                        Iterator<RowMap> iterator = this.executor.iterator();
                        while (iterator.hasNext()) {
                            RowMap rowMap = iterator.next();
                            int n3 = rowMap.getInt("StatusCode");
                            if (n3 != 0) {
                                string2 = rowMap.getString("ErrorMsg");
                                n2 = n3 == -1 ? 2 : 4;
                                logger.error((Object)("Error checking serial -- code: " + rowMap.getString("StatusCode") + ", msg: " + rowMap.getString("ErrorMsg")));
                                continue;
                            }
                            string4 = rowMap.getString("ErrorMsg");
                            ApplianceDetails applianceDetails = new ApplianceDetails();
                            applianceDetails.setSerailnumber(rowMap.getString("Serial"));
                            if (rowMap.getString("CommcellID") == null || rowMap.getString("CommcellID").isEmpty()) {
                                applianceDetails.setCommcellid(null);
                            } else {
                                applianceDetails.setCommcellid(rowMap.getString("CommcellID").toUpperCase());
                            }
                            applianceDetails.setCommcellip(rowMap.getString("CommcellIP"));
                            applianceDetails.setCapacity(rowMap.getString("Capacity"));
                            applianceDetails.setCommcellserial(rowMap.getString("CommcellSerial").toUpperCase());
                            applianceDetails.setCommcellregcode(rowMap.getString("CommcellRegCode").toUpperCase());
                            if (string4 == null || string4.isEmpty()) {
                                string4 = rowMap.getString("Vendor");
                            }
                            arrayList.add(rowMap.getString("Serial"));
                            object.add(applianceDetails);
                        }
                    } else {
                        n2 = 3;
                        string2 = "Somthing unexpected happened, please contact administrator.";
                    }
                    httpServletRequest.getSession().setAttribute("APP_SERIALS", arrayList);
                    httpServletRequest.getSession().setAttribute("APPLIANCE_DETAILS", object);
                    httpServletRequest.getSession().setAttribute("VENDOR_TYPE", (Object)n);
                    httpServletRequest.getSession().setAttribute("VENDOR_NAME", (Object)string4);
                }
                catch (Exception exception) {
                    n2 = 2;
                    string2 = "Error while querying db.";
                    logger.error((Object)"Eaception while executing storedprocedure", (Throwable)exception);
                }
            }
            if (arrayList.size() > 0) {
                object = "/registerappliance/fujitsu/ApplianceInfo.jsp";
                string3 = "\"nextpage\": \"" + (String)object + "\"";
            }
        }
        catch (Exception exception) {
            n2 = 3;
            logger.error((Object)exception);
            string2 = "Somthing unexpected happened, please contact administrator.";
        }
        RequestContext.getResponse().getWriter().write("{\"code\": " + n2 + ", \"msg\": \"" + string2.replaceAll("\"", "\\\\\"") + "\", \"data\": {" + string3 + "}}");
    }

    private void getCountries() throws IOException {
        String string = "";
        ClientResp clientResp = new ClientResp();
        ArrayList<IdName> arrayList = new ArrayList<IdName>();
        arrayList.add(new IdName(0, ""));
        try {
            CloudServicesDBSPOpReq cloudServicesDBSPOpReq = new CloudServicesDBSPOpReq(StoredProcedure.getCountires);
            this.executor.executeOperation(cloudServicesDBSPOpReq);
            this.executor.executeOperation(cloudServicesDBSPOpReq);
            if (this.executor.hasRecords()) {
                Iterator<RowMap> iterator = this.executor.iterator();
                while (iterator.hasNext()) {
                    RowMap rowMap = iterator.next();
                    IdName idName = new IdName(rowMap.getInt("id"), rowMap.getString("name"));
                    arrayList.add(idName);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Exception while getting country names", (Throwable)exception);
            string = "Some exception happened, please talk to administrator.";
            clientResp.setErrorResponse(string);
        }
        clientResp.addData("countries", arrayList);
        RequestContext.getResponse().getWriter().write(clientResp.toJson());
    }

    private ApplianceDetails findSerialsInList(List<ApplianceDetails> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            ApplianceDetails applianceDetails = list.get(i);
            if (!applianceDetails.getSerailnumber().equalsIgnoreCase(string)) continue;
            return applianceDetails;
        }
        return null;
    }
}

