/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn;

import commvault.web.creconn.DataStatementOperation;
import commvault.web.creconn.entity.DataType;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OpReq {
    private static final Logger logger = Logger.getLogger(OpReq.class);
    public static final String SP_NAME_PARAM = "spName";
    public static final String COMMCELL_UNIQUE_ID = "commUniId";
    public static final String NULL = "NULL";
    DataStatementOperation operation;
    final String QUERY_PARAMETER_PREFIX = "parameter.";
    Map<String, Object> requestParams;
    int paramIndex = 0;
    final String PARAM = "param";
    private DefaultDataSet dataSet;

    public OpReq(DataStatementOperation dataStatementOperation, DefaultDataSet defaultDataSet) {
        this.operation = dataStatementOperation;
        this.dataSet = defaultDataSet;
        this.init();
    }

    private void init() {
        this.requestParams = new HashMap<String, Object>();
        this.requestParams.put("operation", this.operation.name());
        this.requestParams.put("offset", String.valueOf(0));
        this.requestParams.put("limit", String.valueOf(-1));
        this.requestParams.put("dateFormat", "milliseconds");
        this.requestParams.put("nullValue", "");
        this.requestParams.put("livefeed", Boolean.TRUE.toString());
        this.requestParams.put("syscol", Boolean.FALSE.toString());
        this.requestParams.put("priority", Priority.normal.name());
    }

    public DataStatementOperation getOperation() {
        return this.operation;
    }

    public void setOperation(DataStatementOperation dataStatementOperation) {
        this.operation = dataStatementOperation;
    }

    public OpReq addParam(Object object) {
        return this.addParam(DataType.String, object);
    }

    public OpReq addParam(DataType dataType, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempted to add null value to request; verify that the correct value is being passed. If null is really desired as a parameter value, use the method addParamOrNull instead.");
        }
        this.requestParams.put("parameter.param" + ++this.paramIndex, object.toString());
        return this;
    }

    public OpReq addParam(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempted to add null value to request; verify that the correct value is being passed. If null is really desired as a parameter value, use the method addParamOrNull instead.");
        }
        this.requestParams.put("parameter." + string, object.toString());
        return this;
    }

    public OpReq addNull() {
        this.requestParams.put("parameter.param" + ++this.paramIndex, NULL);
        return this;
    }

    public OpReq addNull(String string) {
        this.requestParams.put("parameter." + string, NULL);
        return this;
    }

    public OpReq addParamOrNull(Object object) {
        return this.addParamOrNull(DataType.String, object);
    }

    public OpReq addParamOrNull(DataType dataType, Object object) {
        if (object != null) {
            return this.addParam(dataType, object);
        }
        return this.addNull();
    }

    public OpReq addParamOrNull(String string, Object object) {
        if (object != null) {
            return this.addParam(string, object);
        }
        return this.addNull(string);
    }

    public void turnOnCache() {
        this.requestParams.put("livefeed", Boolean.FALSE.toString());
    }

    public void setDateFormat(String string) {
        this.requestParams.put("dateFormat", string);
    }

    public void setNullValue(String string) {
        this.requestParams.put("nullValue", string);
    }

    public void setCacheID(String string) {
        this.requestParams.put("cacheId", string);
    }

    public void setOffset(int n) {
        this.requestParams.put("offset", String.valueOf(n));
    }

    public void setLimit(int n) {
        this.requestParams.put("limit", String.valueOf(n));
    }

    public void setPriority(Priority priority) {
        this.requestParams.put("priority", priority.name());
    }

    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }

    public final String getDataSetName() {
        return this.dataSet.name();
    }

    public static enum Priority {
        high,
        normal,
        low;

    }

    public static enum DefaultDataSet {
        COMMCELL_DEFAULT,
        METRICS_DEFAULT,
        MSDB_DEFAULT,
        GATHER_LOGS_DEFAULT;

    }
}

