/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.creconn;

import commvault.web.core.config.ConfigProperties;
import commvault.web.core.msg.CheckCredentialResp;
import commvault.web.core.net.RequestMethod;
import commvault.web.core.util.CVCoreUtil;
import commvault.web.core.util.UriUtil;
import commvault.web.core.util.WebServerLogin;
import commvault.web.creconn.CreRequestObject;
import commvault.web.creconn.provider.GenericResponseHandler;
import commvault.web.creconn.resp.GenericResp;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.core.Config;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;

public class CustomReportsClient {
    private static final Logger logger = Logger.getLogger(CustomReportsClient.class);
    private static final String REPORTSPLUS_ENGINE_END_POINT = "reportsplusengine/";
    protected static final String LOGIN_TOKEN_INFO = "LOGIN_TOKEN_INFO";
    protected static final String TOKEN_HEADER_KEY = "Cookie2";
    protected static final String CLIENT_LOCATION = "client-location";
    protected static final String TIME_ZONE = "timezone";
    protected static final String LOCALE_HEADER = "Accept-Language";
    public static final String[] TOKEN_PARAMETERS = new String[]{"Cookie2", "token", "AuthToken"};
    private boolean isServiceInitialized;
    @Inject
    private HttpServletRequest httpServletRequest;
    private String endPoint;
    WebTarget target = null;
    ClientConfig config = null;
    Client client = null;
    private WebServerLogin loginService = CVCoreUtil.lookup(WebServerLogin.class);
    private final ConfigProperties configProps = CVCoreUtil.lookup(ConfigProperties.class);

    private String headersToString(MultivaluedMap<String, String> multivaluedMap) {
        MultivaluedStringMap multivaluedStringMap = new MultivaluedStringMap();
        for (Map.Entry entry : multivaluedMap.entrySet()) {
            if (Arrays.asList(TOKEN_PARAMETERS).contains(entry.getKey())) {
                multivaluedStringMap.putSingle(entry.getKey(), (Object)"**********");
                continue;
            }
            multivaluedStringMap.put(entry.getKey(), entry.getValue());
        }
        return multivaluedStringMap.toString();
    }

    private WebTarget getTarget() throws Exception {
        if (!this.isServiceInitialized) {
            this.config = new ClientConfig();
            this.config.register(GenericResponseHandler.class);
            this.config.register((Object)new ClientRequestFilter(){

                public void filter(ClientRequestContext clientRequestContext) throws IOException {
                    MultivaluedMap multivaluedMap = clientRequestContext.getHeaders();
                    multivaluedMap.add((Object)CustomReportsClient.TOKEN_HEADER_KEY, (Object)this.loginToWebserverAndGetLoginToken(true));
                    String string = null;
                    if (CustomReportsClient.this.httpServletRequest != null && CustomReportsClient.this.httpServletRequest.getSession() != null) {
                        Object object;
                        String string2 = CustomReportsClient.this.httpServletRequest.getHeader("X-Forwarded-For");
                        if (string2 != null) {
                            object = string2.split(",");
                            if (object != null) {
                                string2 = object[0];
                            }
                        } else {
                            string2 = CustomReportsClient.this.httpServletRequest.getRemoteAddr();
                        }
                        multivaluedMap.add((Object)CustomReportsClient.CLIENT_LOCATION, (Object)string2);
                        multivaluedMap.add((Object)"sessionId", (Object)CustomReportsClient.this.httpServletRequest.getSession().getId());
                        multivaluedMap.add((Object)CustomReportsClient.TIME_ZONE, (Object)CustomReportsClient.this.httpServletRequest.getHeader("timeZoneInfo"));
                        multivaluedMap.add((Object)"operatorCompanyId", (Object)CustomReportsClient.this.httpServletRequest.getHeader("operatorCompanyId"));
                        object = (Locale)Config.get((ServletRequest)CustomReportsClient.this.httpServletRequest, (String)"javax.servlet.jsp.jstl.fmt.locale");
                        String string3 = string = object == null ? null : ((Locale)object).toString();
                        if (string == null) {
                            string = "en_US";
                        }
                        multivaluedMap.add((Object)CustomReportsClient.LOCALE_HEADER, (Object)string);
                        logger.info((Object)("request url [" + clientRequestContext.getUri() + "], method [" + clientRequestContext.getMethod() + "], headers [" + CustomReportsClient.this.headersToString((MultivaluedMap<String, String>)clientRequestContext.getStringHeaders()) + "]"));
                    }
                }

                public String loginToWebserverAndGetLoginToken(boolean bl) {
                    if (CustomReportsClient.this.httpServletRequest != null && CustomReportsClient.this.httpServletRequest.getSession() != null) {
                        CheckCredentialResp checkCredentialResp;
                        if (CustomReportsClient.this.loginService == null) {
                            CustomReportsClient.this.loginService = CVCoreUtil.lookup(WebServerLogin.class);
                        }
                        if ((checkCredentialResp = CustomReportsClient.this.loginService.login(bl)).getToken() == null || checkCredentialResp.getToken().isEmpty()) {
                            logger.error((Object)"Unable to call Custom report engine, as not able to login to webserver.");
                        }
                        return checkCredentialResp.getToken();
                    }
                    return null;
                }
            });
            this.client = ClientBuilder.newClient((Configuration)this.config);
            String string = this.configProps.getCREengineURL();
            this.target = this.client.target(string);
            if (this.target != null) {
                this.setServiceInitialized(true);
            }
        }
        return this.target;
    }

    private <T> T handleResponse(Response response, Class<T> clazz) throws Exception {
        int n = response.getStatus();
        if (n == 200 || n == 204) {
            return (T)response.readEntity(clazz);
        }
        if (n == 500 || n == 401 || n == 403) {
            this.handleException(response);
        } else {
            this.handleException(response);
        }
        return null;
    }

    private void handleException(Response response) throws Exception {
        GenericResp genericResp = (GenericResp)response.readEntity(GenericResp.class);
        Exception exception = new Exception(genericResp.getErrorMessage());
        throw exception;
    }

    public <T> T getResponse(CreRequestObject creRequestObject, Class<T> clazz) throws Exception {
        Response response = this.getResponse(creRequestObject);
        return this.handleResponse(response, clazz);
    }

    private Response getResponse(CreRequestObject creRequestObject) throws Exception {
        RequestMethod requestMethod = creRequestObject.getRequestMethod();
        switch (requestMethod) {
            case GET: {
                return this.invokeGet(creRequestObject);
            }
            case PUT: {
                return this.invokePut(creRequestObject);
            }
            case POST: {
                return this.invokePost(creRequestObject);
            }
            case DELETE: {
                return this.invokeDelete(creRequestObject);
            }
        }
        return null;
    }

    private Invocation.Builder getBuilder(CreRequestObject creRequestObject) throws Exception {
        Object object;
        String string = creRequestObject.getApi();
        if (this.endPoint == null) {
            this.endPoint = REPORTSPLUS_ENGINE_END_POINT;
        }
        WebTarget webTarget = this.getTarget();
        Map<String, Object> map2 = creRequestObject.getParamMap();
        if (map2 != null && !map2.isEmpty()) {
            for (String map3 : map2.keySet()) {
                Object object2;
                Iterator<String> iterator = map2.get(map3);
                if (iterator instanceof List) {
                    object2 = (List)((Object)iterator);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        webTarget = webTarget.queryParam(map3, new Object[]{UriUtil.encodeURIComponent(string2)});
                    }
                    continue;
                }
                object2 = iterator != null ? String.valueOf(iterator) : "";
                webTarget = webTarget.queryParam(map3, new Object[]{object2});
            }
        }
        string = this.endPoint + string;
        Invocation.Builder builder = webTarget.path(string).request(new String[]{creRequestObject.getMediaType()}).accept(new String[]{creRequestObject.getAcceptHeader()});
        Map<String, String> map = creRequestObject.getHeaderMap();
        if (map != null && !map.isEmpty()) {
            for (Object object2 : map.keySet()) {
                object = String.valueOf(map.get(object2));
                builder = builder.header((String)object2, object);
            }
        }
        return builder;
    }

    private Response invokeDelete(CreRequestObject creRequestObject) throws Exception {
        return (Response)this.getBuilder(creRequestObject).delete(Response.class);
    }

    private Response invokePost(CreRequestObject creRequestObject) throws Exception {
        Entity entity = Entity.entity((Object)creRequestObject.getReqObject(), (String)creRequestObject.getMediaType());
        return (Response)this.getBuilder(creRequestObject).post(entity, Response.class);
    }

    private Response invokePut(CreRequestObject creRequestObject) throws Exception {
        return (Response)this.getBuilder(creRequestObject).put(Entity.entity((Object)creRequestObject.getReqObject(), (String)creRequestObject.getMediaType()), Response.class);
    }

    private Response invokeGet(CreRequestObject creRequestObject) throws Exception {
        return (Response)this.getBuilder(creRequestObject).get(Response.class);
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String string) {
        this.endPoint = string;
    }

    public boolean isServiceInitialized() throws Exception {
        if (!this.isServiceInitialized) {
            try {
                this.getTarget();
            }
            catch (Exception exception) {
                throw new Exception("CustomReportsEngine is not initilaized. Please check the logs for any errors.");
            }
        }
        return this.isServiceInitialized;
    }

    private void setServiceInitialized(boolean bl) {
        this.isServiceInitialized = bl;
    }
}

