/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.util;

import commvault.web.core.config.ConfigProperties;
import commvault.web.core.filter.RequestContext;
import commvault.web.core.msg.CheckCredentialReq;
import commvault.web.core.msg.CheckCredentialResp;
import commvault.web.core.net.RequestObject;
import commvault.web.core.net.ServerBroker;
import commvault.web.core.util.CVCoreUtil;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class WebServerLogin {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    @Inject
    private ServerBroker serverBroker;
    @Inject
    private ConfigProperties configProps;

    private WebServerLogin() {
    }

    public CheckCredentialResp login(boolean bl) {
        if (RequestContext.getRequest().getSession().getAttribute("LOGIN_TOKEN_INFO") != null && !bl) {
            return (CheckCredentialResp)RequestContext.getRequest().getSession().getAttribute("LOGIN_TOKEN_INFO");
        }
        CheckCredentialResp checkCredentialResp = new CheckCredentialResp();
        CheckCredentialReq checkCredentialReq = new CheckCredentialReq();
        String string = this.configProps.getWebServerUser();
        String string2 = this.configProps.getWebServerPWDB64();
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            logger.error((Object)"There is no user name or password in config file connecting to webconsole.");
            return checkCredentialResp;
        }
        checkCredentialReq.setUsername(string);
        checkCredentialReq.setPassword(string2);
        checkCredentialReq.setFlags(0);
        RequestObject requestObject = new RequestObject(this.configProps.getWebServerURL() + "Login", checkCredentialReq);
        requestObject.setReqContentType("application/json");
        requestObject.setAcceptHeader("application/json");
        try {
            String string3;
            if (this.serverBroker == null) {
                this.serverBroker = CVCoreUtil.lookup(ServerBroker.class);
            }
            if ((string3 = this.serverBroker.getStringResponse(requestObject)) != null && !string3.isEmpty()) {
                checkCredentialResp = (CheckCredentialResp)CVCoreUtil.getRespObjectFromJson(CheckCredentialResp.class, string3);
                if (checkCredentialResp.getUserGUID() != null && !checkCredentialResp.getUserGUID().isEmpty()) {
                    RequestContext.getRequest().getSession().setAttribute("LOGIN_TOKEN_INFO", (Object)checkCredentialResp);
                }
            } else {
                logger.error((Object)"Unable to login in webserver");
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Exception while login to webserver", (Throwable)exception);
        }
        return checkCredentialResp;
    }
}

