/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.util;

import commvault.web.core.filter.RequestContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Util {
    private static final Logger logger = Logger.getLogger((String)"commvault.web");
    private static String webappCanonicalPath;
    private static String webinfCanonicalPath;
    private static HashSet<String> validResources;

    public static String getProperty(String string) {
        Properties properties = (Properties)RequestContext.getRequest().getServletContext().getAttribute("config.properties");
        return properties.getProperty(string);
    }

    public static boolean isSafeInclude(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (webappCanonicalPath == null || webinfCanonicalPath == null) {
            try {
                webappCanonicalPath = new File(RequestContext.getRequest().getServletContext().getRealPath("/")).getCanonicalPath();
                webinfCanonicalPath = new File(RequestContext.getRequest().getServletContext().getRealPath("/WEB-INF")).getCanonicalPath();
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to get canonical path from servelet context. " + iOException.getMessage()));
            }
        }
        if (string.startsWith(RequestContext.getRequest().getContextPath())) {
            string = string.substring(RequestContext.getRequest().getContextPath().length());
        }
        String string2 = "";
        try {
            string2 = new File(RequestContext.getRequest().getServletContext().getRealPath(string)).getCanonicalPath();
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to get canonical path of include. Path: " + string), (Throwable)exception);
            return false;
        }
        if (string2.startsWith(webappCanonicalPath) && !string2.startsWith(webinfCanonicalPath)) {
            if (validResources.contains(string2)) {
                return true;
            }
            if (Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
                validResources.add(string2);
                return true;
            }
        }
        logger.error((Object)("Removing insecure include. Path: " + string));
        return false;
    }

    static {
        validResources = new HashSet();
    }
}

