/*
 * Decompiled with CFR 0.152.
 */
package commvault.web.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class UriUtil {
    private static final String[][] decMap = new String[][]{{"\\+", "%20"}, {"\\%21", "!"}, {"\\%27", "'"}, {"\\%28", "("}, {"\\%29", ")"}, {"\\%7E", "~"}};

    public static String encodeURIComponent(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
            for (String[] stringArray : decMap) {
                string2 = string2.replaceAll(stringArray[0], stringArray[1]);
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String decodeURIComponent(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = null;
            string2 = URLDecoder.decode(string, "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private UriUtil() {
    }
}

